/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_21_6.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GHoloRowEntityContent
extends Entity
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final HashMap<UUID, EntityTypes<?>> currentEntityTypes = new HashMap();

    public GHoloRowEntityContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.as, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        this.g(true);
        for (GHoloUpdateType updateType : GHoloUpdateType.values()) {
            this.handleUpdate(updateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        MinecraftKey resourceLocation = MinecraftKey.c((String)content.toLowerCase());
        if (resourceLocation == null) {
            return;
        }
        Optional entityData = BuiltInRegistries.f.c(resourceLocation);
        if (entityData.isEmpty()) {
            return;
        }
        EntityTypes entityType = (EntityTypes)((Holder.c)entityData.get()).a();
        if (create || this.currentEntityTypes.get(player.getUniqueId()) != entityType) {
            this.currentEntityTypes.put(player.getUniqueId(), entityType);
            serverPlayer.g.b((Packet)new PacketPlayOutSpawnEntity(this.ar(), this.aG, this.dC(), this.dE(), this.dI(), this.dR(), this.dP(), entityType, 0, this.dA(), (double)this.dP()));
        }
        serverPlayer.g.b((Packet)this.getDataPacket());
    }

    private PacketPlayOutEntityMetadata getDataPacket() {
        List defaultResetData;
        ArrayList data = this.au().c();
        if (data == null) {
            data = new ArrayList();
        }
        if ((defaultResetData = this.au().b()) != null) {
            data.addAll(defaultResetData);
        }
        return new PacketPlayOutEntityMetadata(this.ar(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.ar(), PositionMoveRotation.a((Entity)this), Set.of(), false);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.g.b((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.a_(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.b(yaw, pitch);
            }
        }
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.g.b((Packet)this.getDataPacket());
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.g.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.ar()}));
    }

    protected void a(DataWatcher.a builder) {
    }

    public boolean a(WorldServer serverLevel, DamageSource damageSource, float value) {
        return false;
    }

    protected void a(ValueInput valueInput) {
    }

    protected void a(ValueOutput valueOutput) {
    }
}

