/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_21_2.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import io.papermc.paper.adventure.PaperAdventure;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GHoloRowTextContent
extends Display.TextDisplay
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final DataWatcherObject<IChatBaseComponent> holoTextData;
    private final DataWatcherObject<Vector3f> holoScaleData;

    /*
     * WARNING - void declaration
     */
    public GHoloRowTextContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.bv, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        int n;
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        this.al.a(aH, (Object)10000);
        DataWatcherObject textAccessor = null;
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Field[] fieldArray = Display.TextDisplay.class.getDeclaredFields();
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                Field field = fieldArray[n];
                if (!field.getType().equals(DataWatcherObject.class)) continue;
                fieldList.add(field);
            }
            Field field = (Field)fieldList.getFirst();
            field.setAccessible(true);
            textAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable e) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", e);
        }
        this.holoTextData = textAccessor;
        DataWatcherObject scaleAccessor = null;
        try {
            void var8_18;
            ArrayList<Field> arrayList = new ArrayList<Field>();
            Field[] fieldArray = Display.class.getDeclaredFields();
            n = fieldArray.length;
            boolean bl = false;
            while (var8_18 < n) {
                Field field2 = fieldArray[var8_18];
                if (field2.getType().equals(DataWatcherObject.class)) {
                    arrayList.add(field2);
                }
                ++var8_18;
            }
            Field field = (Field)arrayList.get(4);
            field.setAccessible(true);
            scaleAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable throwable) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", throwable);
        }
        this.holoScaleData = scaleAccessor;
        for (GHoloUpdateType gHoloUpdateType : GHoloUpdateType.values()) {
            this.handleUpdate(gHoloUpdateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (create) {
            serverPlayer.f.b((Packet)new PacketPlayOutSpawnEntity(this.ar(), this.at, this.dB(), this.dD(), this.dH(), this.dO(), this.dM(), this.aq(), 0, this.dz(), (double)this.dM()));
        }
        serverPlayer.f.b((Packet)this.getDataPacket(content));
    }

    private PacketPlayOutEntityMetadata getDataPacket(String content) {
        ArrayList<DataWatcher.c> data = this.au().c();
        if (data == null) {
            data = new ArrayList<DataWatcher.c>();
        } else {
            data.removeIf(dataValue -> dataValue.a() == this.holoTextData.a());
        }
        List defaultResetData = this.au().b();
        if (defaultResetData != null) {
            data.addAll(defaultResetData);
        }
        if (content != null) {
            IChatBaseComponent textData = this.gHoloMain.supportsPaperFeature() ? PaperAdventure.asVanilla((Component)((Component)this.gHoloMain.getTextFormatUtil().toFormattedComponent(content))) : CraftChatMessage.fromString((String)this.gHoloMain.getTextFormatUtil().toFormattedText(content), (boolean)false, (boolean)true)[0];
            data.add(new DataWatcher.c(this.holoTextData.a(), this.holoTextData.b(), (Object)textData));
        }
        return new PacketPlayOutEntityMetadata(this.ar(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.ar(), PositionMoveRotation.a((Entity)this), Set.of(), false);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.f.b((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.a_(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.b(yaw, pitch);
                break;
            }
            case RANGE: {
                double range = rowData.getRange() != 120.0 ? rowData.getRange() : (holoData.getRange() != 120.0 ? holoData.getRange() : 120.0);
                this.b((float)(range / 64.0));
                break;
            }
            case BACKGROUND_COLOR: {
                String backgroundColor = !Objects.equals(rowData.getBackgroundColor(), "#000000") ? rowData.getBackgroundColor() : (!Objects.equals(holoData.getBackgroundColor(), "#000000") ? holoData.getBackgroundColor() : "#000000");
                this.setBackgroundColor(backgroundColor);
                break;
            }
            case TEXT_OPACITY: {
                byte textOpacity = rowData.getTextOpacity() != 0 ? rowData.getTextOpacity() : (holoData.getTextOpacity() != 0 ? holoData.getTextOpacity() : (byte)0);
                this.setRealTextOpacity(textOpacity);
                break;
            }
            case TEXT_SHADOW: {
                boolean textShadow = rowData.getTextShadow() ? rowData.getTextShadow() : (holoData.getTextShadow() ? holoData.getTextShadow() : false);
                this.setTextShadow(textShadow);
                break;
            }
            case TEXT_ALIGNMENT: {
                String textAlignment = !Objects.equals(rowData.getTextAlignment(), "center") ? rowData.getTextAlignment() : (!Objects.equals(holoData.getTextAlignment(), "center") ? holoData.getTextAlignment() : "center");
                this.setTextAlignment(textAlignment);
                break;
            }
            case BILLBOARD: {
                String billboard = !Objects.equals(rowData.getBillboard(), "center") ? rowData.getBillboard() : (!Objects.equals(holoData.getBillboard(), "center") ? holoData.getBillboard() : "center");
                this.setBillboard(billboard);
                break;
            }
            case SEE_THROUGH: {
                boolean seeThrough = rowData.getSeeThrough() ? rowData.getSeeThrough() : (holoData.getSeeThrough() ? holoData.getSeeThrough() : false);
                this.setSeeThrough(seeThrough);
                break;
            }
            case SCALE: {
                SimpleVector scale = !Objects.equals(rowData.getRawScale(), GHoloData.DEFAULT_SCALE) ? rowData.getRawScale() : (!Objects.equals(holoData.getRawScale(), GHoloData.DEFAULT_SCALE) ? holoData.getRawScale() : GHoloData.DEFAULT_SCALE);
                this.al.a(this.holoScaleData, (Object)new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ()));
                break;
            }
            case BRIGHTNESS: {
                Byte brightness = rowData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? rowData.getBrightness() : (holoData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? holoData.getBrightness() : GHoloData.DEFAULT_BRIGHTNESS);
                this.a(brightness != null ? new Brightness((int)brightness.byteValue(), Brightness.c.c()) : null);
            }
        }
    }

    private void setBackgroundColor(String color) {
        if (((String)color).equalsIgnoreCase("transparent")) {
            this.al.a(aI, (Object)0);
            return;
        }
        Object object = color = ((String)color).startsWith("#") ? ((String)color).substring(1) : color;
        if (((String)color).length() == 6) {
            color = (String)color + "40";
        }
        color = ((String)color).substring(((String)color).length() - 2) + ((String)color).substring(0, ((String)color).length() - 2);
        this.al.a(aI, (Object)((int)Long.parseLong((String)color, 16)));
    }

    private void setRealTextOpacity(byte textOpacity) {
        int clampedPercent = Math.max(0, Math.min(textOpacity, 100));
        int valueInRange26To255 = 255 - clampedPercent * 231 / 100;
        byte signedAlphaValue = (byte)(valueInRange26To255 > 127 ? valueInRange26To255 - 256 : valueInRange26To255);
        this.c(signedAlphaValue);
    }

    private void setTextAlignment(String textAlignment) {
        this.d((byte)(textAlignment.equalsIgnoreCase(Display.TextDisplay.Align.b.name()) ? this.x() | 8 : this.x() & 0xFFFFFFF7));
        this.d((byte)(textAlignment.equalsIgnoreCase(Display.TextDisplay.Align.c.name()) ? this.x() | 0x10 : this.x() & 0xFFFFFFEF));
    }

    private void setBillboard(String billboard) {
        this.a(Display.BillboardConstraints.valueOf((String)billboard.toUpperCase()));
    }

    private void setTextShadow(boolean hasTextShadow) {
        this.d((byte)(hasTextShadow ? this.x() | 1 : this.x() & 0xFFFFFFFE));
    }

    private void setSeeThrough(boolean canSeeThrough) {
        this.d((byte)(canSeeThrough ? this.x() | 2 : this.x() & 0xFFFFFFFD));
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.f.b((Packet)this.getDataPacket(null));
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.f.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.ar()}));
    }
}

