/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_21_11.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GHoloRowItemStackContent
extends EntityItem
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final DataWatcherObject<ItemStack> holoItemData;

    public GHoloRowItemStackContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.av, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        this.g(true);
        this.m();
        this.q();
        DataWatcherObject itemAccessor = null;
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Field[] fieldArray = EntityItem.class.getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                if (!field.getType().equals(DataWatcherObject.class)) continue;
                fieldList.add(field);
            }
            Field field = (Field)fieldList.getFirst();
            field.setAccessible(true);
            itemAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable e) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", e);
        }
        this.holoItemData = itemAccessor;
        for (GHoloUpdateType updateType : GHoloUpdateType.values()) {
            this.handleUpdate(updateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (create) {
            serverPlayer.g.b((Packet)new PacketPlayOutSpawnEntity(this.aA(), this.aH, this.dP(), this.dR(), this.dV(), this.ee(), this.ec(), this.ay(), 0, this.dN(), (double)this.ec()));
        }
        serverPlayer.g.b((Packet)this.getDataPacket(content));
    }

    private PacketPlayOutEntityMetadata getDataPacket(String content) {
        Optional itemData;
        MinecraftKey identifier;
        ArrayList<DataWatcher.c> data = this.aD().c();
        if (data == null) {
            data = new ArrayList<DataWatcher.c>();
        } else {
            data.removeIf(dataValue -> dataValue.a() == this.holoItemData.a());
        }
        List defaultResetData = this.aD().b();
        if (defaultResetData != null) {
            data.addAll(defaultResetData);
        }
        if (content != null && (identifier = MinecraftKey.c((String)content.toLowerCase())) != null && (itemData = BuiltInRegistries.h.c(identifier)).isPresent()) {
            data.add(new DataWatcher.c(this.holoItemData.a(), this.holoItemData.b(), (Object)((Item)((Holder.c)itemData.get()).a()).m()));
        }
        return new PacketPlayOutEntityMetadata(this.aA(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport(this.aA(), PositionMoveRotation.a((Entity)this), Set.of(), false);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.g.b((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.a_(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.a(yaw, pitch);
            }
        }
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.g.b((Packet)this.getDataPacket(null));
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.g.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.aA()}));
    }
}

