/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_20_5.object.interaction;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.interaction.GInteraction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.GInteractionUpdateType;
import dev.geco.gholo.object.interaction.IGInteractionEntity;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GInteractionEntity
extends Interaction
implements IGInteractionEntity {
    protected final GInteraction interaction;
    protected final GHoloMain gHoloMain;

    public GInteractionEntity(GInteraction interaction) {
        super(EntityTypes.ae, (World)((CraftWorld)interaction.getRawLocation().getWorld()).getHandle());
        this.interaction = interaction;
        this.gHoloMain = GHoloMain.getInstance();
        this.persist = false;
        for (GInteractionUpdateType updateType : GInteractionUpdateType.values()) {
            this.handleUpdate(updateType);
        }
    }

    @Override
    public void loadInteraction() {
        PacketPlayOutSpawnEntity addEntityPacket = new PacketPlayOutSpawnEntity(this.al(), this.az, this.du(), this.dw(), this.dA(), this.dH(), this.dF(), this.ak(), 0, this.ds(), (double)this.dF());
        PacketPlayOutEntityMetadata setEntityDataPacket = this.getDataPacket();
        String permission = this.getPermission();
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.c.b((Packet)addEntityPacket);
            serverPlayer.c.b((Packet)setEntityDataPacket);
        }
    }

    @Override
    public void loadInteraction(@NotNull Player player) {
        if (!player.getWorld().equals((Object)this.interaction.getRawLocation().getWorld())) {
            return;
        }
        String permission = this.getPermission();
        if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b((Packet)new PacketPlayOutSpawnEntity(this.al(), this.az, this.du(), this.dw(), this.dA(), this.dH(), this.dF(), this.ak(), 0, this.ds(), (double)this.dF()));
        serverPlayer.c.b((Packet)this.getDataPacket());
    }

    private PacketPlayOutEntityMetadata getDataPacket() {
        List defaultResetData;
        ArrayList data = this.ap().c();
        if (data == null) {
            data = new ArrayList();
        }
        if ((defaultResetData = this.ap().b()) != null) {
            data.addAll(defaultResetData);
        }
        return new PacketPlayOutEntityMetadata(this.al(), data);
    }

    @Override
    public void publishUpdate(@NotNull GInteractionUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GInteractionUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport((Entity)this);
            String permission = this.getPermission();
            for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.c.b((Packet)teleportEntityPacket);
            }
            return;
        }
        if (updateType == GInteractionUpdateType.PERMISSION) {
            this.unloadInteraction();
            this.loadInteraction();
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GInteractionUpdateType updateType) {
        GInteractionData data = this.interaction.getRawData();
        switch (updateType) {
            case LOCATION: {
                SimpleLocation location = this.interaction.getLocation();
                this.a_(location.getX(), location.getY(), location.getZ());
                break;
            }
            case SIZE: {
                this.a(data.getRawSize().getWidth());
                this.b(data.getRawSize().getHeight());
            }
        }
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        PacketPlayOutEntityMetadata setEntityDataPacket = this.getDataPacket();
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.c.b((Packet)setEntityDataPacket);
        }
    }

    private String getPermission() {
        GInteractionData interactionData = this.interaction.getRawData();
        return interactionData.getPermission() != null ? interactionData.getPermission() : GInteractionData.DEFAULT_PERMISSION;
    }

    @Override
    public void unloadInteraction() {
        PacketPlayOutEntityDestroy removeEntityPacket = new PacketPlayOutEntityDestroy(new int[]{this.al()});
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.c.b((Packet)removeEntityPacket);
        }
    }

    @Override
    public void unloadInteraction(@NotNull Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.al()}));
    }
}

