/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_20_5.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GHoloRowEntityContent
extends Entity
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final HashMap<UUID, EntityTypes<?>> currentEntityTypes = new HashMap();

    public GHoloRowEntityContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.ag, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        this.f(true);
        for (GHoloUpdateType updateType : GHoloUpdateType.values()) {
            this.handleUpdate(updateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        MinecraftKey resourceLocation = MinecraftKey.a((String)content.toLowerCase());
        if (resourceLocation == null) {
            return;
        }
        try {
            EntityTypes entityType = (EntityTypes)BuiltInRegistries.g.a(resourceLocation);
            if (create || this.currentEntityTypes.get(player.getUniqueId()) != entityType) {
                this.currentEntityTypes.put(player.getUniqueId(), entityType);
                serverPlayer.c.b((Packet)new PacketPlayOutSpawnEntity(this.al(), this.az, this.du(), this.dw(), this.dA(), this.dH(), this.dF(), entityType, 0, this.ds(), (double)this.dF()));
            }
            serverPlayer.c.b((Packet)this.getDataPacket());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private PacketPlayOutEntityMetadata getDataPacket() {
        List defaultResetData;
        ArrayList data = this.ap().c();
        if (data == null) {
            data = new ArrayList();
        }
        if ((defaultResetData = this.ap().b()) != null) {
            data.addAll(defaultResetData);
        }
        return new PacketPlayOutEntityMetadata(this.al(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport((Entity)this);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.c.b((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.a_(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.a(yaw, pitch);
            }
        }
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.c.b((Packet)this.getDataPacket());
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{this.al()}));
    }

    protected void a(DataWatcher.a builder) {
    }

    protected void a(NBTTagCompound compoundTag) {
    }

    protected void b(NBTTagCompound compoundTag) {
    }
}

