/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_20_5.object.holo;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.mcv.v1_20_5.object.holo.type.GHoloRowBlockContent;
import dev.geco.gholo.mcv.v1_20_5.object.holo.type.GHoloRowEntityContent;
import dev.geco.gholo.mcv.v1_20_5.object.holo.type.GHoloRowItemContent;
import dev.geco.gholo.mcv.v1_20_5.object.holo.type.GHoloRowItemStackContent;
import dev.geco.gholo.mcv.v1_20_5.object.holo.type.GHoloRowTextContent;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContent;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GHoloRowContent
implements IGHoloRowContent {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private GHoloRowTextContent textContent;
    private GHoloRowEntityContent entityContent;
    private GHoloRowBlockContent blockContent;
    private GHoloRowItemContent itemContent;
    private GHoloRowItemStackContent itemStackContent;
    private final HashMap<UUID, IGHoloRowContentType> currentContentTypes = new HashMap();

    public GHoloRowContent(GHoloRow holoRow) {
        this.holoRow = holoRow;
        this.gHoloMain = GHoloMain.getInstance();
    }

    @Override
    public void loadHoloRow() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            String content = this.holoRow.getContent();
            content = this.gHoloMain.getTextFormatUtil().formatText(content, player);
            this.updateContent(content, player);
        }
    }

    @Override
    public void loadHoloRow(@NotNull Player player) {
        if (!player.getWorld().equals((Object)this.holoRow.getHolo().getRawLocation().getWorld())) {
            return;
        }
        String permission = this.getPermission();
        if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) {
            return;
        }
        String content = this.holoRow.getContent();
        content = this.gHoloMain.getTextFormatUtil().formatText(content, player);
        this.updateContent(content, player);
    }

    private void updateContent(String content, Player player) {
        UUID playerUuid = player.getUniqueId();
        String[] contentSplit = content.split(":", 2);
        IGHoloRowContentType contentType = switch (contentSplit[0].toLowerCase()) {
            case "entity" -> {
                if (this.entityContent == null) {
                    this.entityContent = new GHoloRowEntityContent(this.holoRow, this.gHoloMain);
                }
                yield this.entityContent;
            }
            case "block" -> {
                if (this.blockContent == null) {
                    this.blockContent = new GHoloRowBlockContent(this.holoRow, this.gHoloMain);
                }
                yield this.blockContent;
            }
            case "item" -> {
                if (this.itemContent == null) {
                    this.itemContent = new GHoloRowItemContent(this.holoRow, this.gHoloMain);
                }
                yield this.itemContent;
            }
            case "itemstack" -> {
                if (this.itemStackContent == null) {
                    this.itemStackContent = new GHoloRowItemStackContent(this.holoRow, this.gHoloMain);
                }
                yield this.itemStackContent;
            }
            default -> {
                if (this.textContent == null) {
                    this.textContent = new GHoloRowTextContent(this.holoRow, this.gHoloMain);
                }
                yield this.textContent;
            }
        };
        IGHoloRowContentType currentContentType = this.currentContentTypes.get(playerUuid);
        if (currentContentType != contentType) {
            if (currentContentType != null) {
                currentContentType.unload(player);
            }
            contentType.load(player, contentType instanceof GHoloRowTextContent ? content : contentSplit[1], true);
            this.currentContentTypes.put(playerUuid, contentType);
        } else {
            contentType.load(player, contentType instanceof GHoloRowTextContent ? content : contentSplit[1], false);
        }
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        if (updateType == GHoloUpdateType.CONTENT) {
            this.loadHoloRow();
            return;
        }
        if (updateType == GHoloUpdateType.PERMISSION) {
            this.unloadHoloRow();
            this.loadHoloRow();
            return;
        }
        for (IGHoloRowContentType holoRowContentType : this.currentContentTypes.values()) {
            holoRowContentType.publishUpdate(updateType);
        }
    }

    @Override
    public void unloadHoloRow() {
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            this.unloadHoloRow(player);
        }
    }

    @Override
    public void unloadHoloRow(@NotNull Player player) {
        IGHoloRowContentType holoRowContentType = this.currentContentTypes.get(player.getUniqueId());
        if (holoRowContentType == null) {
            return;
        }
        holoRowContentType.unload(player);
        this.currentContentTypes.remove(player.getUniqueId());
    }

    @Override
    public HashMap<UUID, IGHoloRowContentType> getCurrentContentTypes() {
        return this.currentContentTypes;
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }
}

