/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_20.object.holo.type;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.IGHoloRowContentType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleSize;
import dev.geco.gholo.object.simple.SimpleVector;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class GHoloRowBlockContent
extends Display.BlockDisplay
implements IGHoloRowContentType {
    private final GHoloRow holoRow;
    private final GHoloMain gHoloMain;
    private final DataWatcherObject<IBlockData> holoBlockData;
    private final DataWatcherObject<Vector3f> holoScaleData;

    /*
     * WARNING - void declaration
     */
    public GHoloRowBlockContent(GHoloRow holoRow, GHoloMain gHoloMain) {
        super(EntityTypes.j, (World)((CraftWorld)holoRow.getHolo().getRawLocation().getWorld()).getHandle());
        int n;
        this.holoRow = holoRow;
        this.gHoloMain = gHoloMain;
        this.persist = false;
        DataWatcherObject blockAccessor = null;
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            Field[] fieldArray = Display.BlockDisplay.class.getDeclaredFields();
            int n2 = fieldArray.length;
            for (n = 0; n < n2; ++n) {
                Field field = fieldArray[n];
                if (!field.getType().equals(DataWatcherObject.class)) continue;
                fieldList.add(field);
            }
            Field field = (Field)fieldList.get(0);
            field.setAccessible(true);
            blockAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable e) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", e);
        }
        this.holoBlockData = blockAccessor;
        DataWatcherObject scaleAccessor = null;
        try {
            void var8_18;
            ArrayList<Field> arrayList = new ArrayList<Field>();
            Field[] fieldArray = Display.class.getDeclaredFields();
            n = fieldArray.length;
            boolean bl = false;
            while (var8_18 < n) {
                Field field2 = fieldArray[var8_18];
                if (field2.getType().equals(DataWatcherObject.class)) {
                    arrayList.add(field2);
                }
                ++var8_18;
            }
            Field field = (Field)arrayList.get(4);
            field.setAccessible(true);
            scaleAccessor = (DataWatcherObject)field.get(this);
        }
        catch (Throwable throwable) {
            gHoloMain.getLogger().log(Level.SEVERE, "Could not load field", throwable);
        }
        this.holoScaleData = scaleAccessor;
        for (GHoloUpdateType gHoloUpdateType : GHoloUpdateType.values()) {
            this.handleUpdate(gHoloUpdateType);
        }
    }

    @Override
    public void load(Player player, String content, boolean create) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        if (create) {
            serverPlayer.c.a((Packet)new PacketPlayOutSpawnEntity(this.af(), this.ax, this.dn(), this.dp(), this.dt(), this.dA(), this.dy(), this.ae(), 0, this.dl(), (double)this.dy()));
        }
        serverPlayer.c.a((Packet)this.getDataPacket(content));
    }

    private PacketPlayOutEntityMetadata getDataPacket(String content) {
        MinecraftKey resourceLocation;
        ArrayList<DataWatcher.b> data = this.aj().c();
        if (data == null) {
            data = new ArrayList<DataWatcher.b>();
        } else {
            data.removeIf(dataValue -> dataValue.a() == this.holoBlockData.a());
        }
        List defaultResetData = this.aj().b();
        if (defaultResetData != null) {
            data.addAll(defaultResetData);
        }
        if (content != null && (resourceLocation = MinecraftKey.a((String)content.toLowerCase())) != null) {
            try {
                Block blockData = (Block)BuiltInRegistries.f.a(resourceLocation);
                data.add(new DataWatcher.b(this.holoBlockData.a(), this.holoBlockData.b(), (Object)blockData.n()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new PacketPlayOutEntityMetadata(this.af(), data);
    }

    @Override
    public void publishUpdate(@NotNull GHoloUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GHoloUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport((Entity)this);
            String permission = this.getPermission();
            for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.c.a((Packet)teleportEntityPacket);
            }
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GHoloUpdateType updateType) {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        switch (updateType) {
            case LOCATION: {
                float yaw;
                SimpleLocation location = this.holoRow.getHolo().getLocation();
                SimpleVector offset = this.holoRow.getRawOffset();
                location.add(offset);
                this.e(location.getX(), location.getY(), location.getZ());
                float f = rowData.getRotation().getYaw() != null ? rowData.getRotation().getYaw().floatValue() : (yaw = holoData.getRotation().getYaw() != null ? holoData.getRotation().getYaw().floatValue() : 0.0f);
                float pitch = rowData.getRotation().getPitch() != null ? rowData.getRotation().getPitch().floatValue() : (holoData.getRotation().getPitch() != null ? holoData.getRotation().getPitch().floatValue() : 0.0f);
                this.a(yaw, pitch);
                break;
            }
            case RANGE: {
                double range = rowData.getRange() != 120.0 ? rowData.getRange() : (holoData.getRange() != 120.0 ? holoData.getRange() : 120.0);
                this.s((float)(range / 64.0));
                break;
            }
            case BILLBOARD: {
                String billboard = !Objects.equals(rowData.getBillboard(), "center") ? rowData.getBillboard() : (!Objects.equals(holoData.getBillboard(), "center") ? holoData.getBillboard() : "center");
                this.setBillboard(billboard);
                break;
            }
            case SCALE: {
                SimpleVector scale = !Objects.equals(rowData.getRawScale(), GHoloData.DEFAULT_SCALE) ? rowData.getRawScale() : (!Objects.equals(holoData.getRawScale(), GHoloData.DEFAULT_SCALE) ? holoData.getRawScale() : GHoloData.DEFAULT_SCALE);
                this.am.b(this.holoScaleData, (Object)new Vector3f((float)scale.getX(), (float)scale.getY(), (float)scale.getZ()));
                break;
            }
            case BRIGHTNESS: {
                Byte brightness = rowData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? rowData.getBrightness() : (holoData.getBrightness() != GHoloData.DEFAULT_BRIGHTNESS ? holoData.getBrightness() : GHoloData.DEFAULT_BRIGHTNESS);
                this.a(brightness != null ? new Brightness((int)brightness.byteValue(), Brightness.c.c()) : null);
                break;
            }
            case SIZE: {
                SimpleSize size = !Objects.equals(rowData.getRawSize(), GHoloData.DEFAULT_SIZE) ? rowData.getRawSize() : (!Objects.equals(holoData.getRawSize(), GHoloData.DEFAULT_SIZE) ? holoData.getRawSize() : GHoloData.DEFAULT_SIZE);
                this.v(size.getWidth());
                this.w(size.getHeight());
            }
        }
    }

    private void setBillboard(String billboard) {
        this.a(Display.BillboardConstraints.valueOf((String)billboard.toUpperCase()));
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        for (Player player : this.holoRow.getHolo().getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.c.a((Packet)this.getDataPacket(null));
        }
    }

    private String getPermission() {
        GHoloData rowData = this.holoRow.getRawData();
        GHoloData holoData = this.holoRow.getHolo().getRawData();
        return rowData.getPermission() != null ? rowData.getPermission() : (holoData.getPermission() != null ? holoData.getPermission() : GHoloData.DEFAULT_PERMISSION);
    }

    @Override
    public void unload(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.c.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.af()}));
    }
}

