/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_19_4.object.interaction;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.interaction.GInteraction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.GInteractionUpdateType;
import dev.geco.gholo.object.interaction.IGInteractionEntity;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GInteractionEntity
extends Interaction
implements IGInteractionEntity {
    protected final GInteraction interaction;
    protected final GHoloMain gHoloMain;

    public GInteractionEntity(GInteraction interaction) {
        super(EntityTypes.ab, (World)((CraftWorld)interaction.getRawLocation().getWorld()).getHandle());
        this.interaction = interaction;
        this.gHoloMain = GHoloMain.getInstance();
        this.persist = false;
        for (GInteractionUpdateType updateType : GInteractionUpdateType.values()) {
            this.handleUpdate(updateType);
        }
    }

    @Override
    public void loadInteraction() {
        PacketPlayOutSpawnEntity addEntityPacket = new PacketPlayOutSpawnEntity(this.af(), this.ax, this.dl(), this.dn(), this.dr(), this.dy(), this.dw(), this.ae(), 0, this.dj(), (double)this.dw());
        PacketPlayOutEntityMetadata setEntityDataPacket = this.getDataPacket();
        String permission = this.getPermission();
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.b.a((Packet)addEntityPacket);
            serverPlayer.b.a((Packet)setEntityDataPacket);
        }
    }

    @Override
    public void loadInteraction(@NotNull Player player) {
        if (!player.getWorld().equals((Object)this.interaction.getRawLocation().getWorld())) {
            return;
        }
        String permission = this.getPermission();
        if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) {
            return;
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)new PacketPlayOutSpawnEntity(this.af(), this.ax, this.dl(), this.dn(), this.dr(), this.dy(), this.dw(), this.ae(), 0, this.dj(), (double)this.dw()));
        serverPlayer.b.a((Packet)this.getDataPacket());
    }

    private PacketPlayOutEntityMetadata getDataPacket() {
        List defaultResetData;
        ArrayList data = this.aj().c();
        if (data == null) {
            data = new ArrayList();
        }
        if ((defaultResetData = this.aj().b()) != null) {
            data.addAll(defaultResetData);
        }
        return new PacketPlayOutEntityMetadata(this.af(), data);
    }

    @Override
    public void publishUpdate(@NotNull GInteractionUpdateType updateType) {
        this.handleUpdate(updateType);
        if (updateType == GInteractionUpdateType.LOCATION) {
            PacketPlayOutEntityTeleport teleportEntityPacket = new PacketPlayOutEntityTeleport((Entity)this);
            String permission = this.getPermission();
            for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
                if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
                EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
                serverPlayer.b.a((Packet)teleportEntityPacket);
            }
            return;
        }
        if (updateType == GInteractionUpdateType.PERMISSION) {
            this.unloadInteraction();
            this.loadInteraction();
            return;
        }
        this.finishUpdate();
    }

    private void handleUpdate(GInteractionUpdateType updateType) {
        GInteractionData data = this.interaction.getRawData();
        switch (updateType) {
            case LOCATION: {
                SimpleLocation location = this.interaction.getLocation();
                this.e(location.getX(), location.getY(), location.getZ());
                break;
            }
            case SIZE: {
                this.a(data.getRawSize().getWidth());
                this.b(data.getRawSize().getHeight());
            }
        }
    }

    private void finishUpdate() {
        String permission = this.getPermission();
        PacketPlayOutEntityMetadata setEntityDataPacket = this.getDataPacket();
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            if (permission != null && !this.gHoloMain.getPermissionService().hasPermission((Permissible)player, permission)) continue;
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.b.a((Packet)setEntityDataPacket);
        }
    }

    private String getPermission() {
        GInteractionData interactionData = this.interaction.getRawData();
        return interactionData.getPermission() != null ? interactionData.getPermission() : GInteractionData.DEFAULT_PERMISSION;
    }

    @Override
    public void unloadInteraction() {
        PacketPlayOutEntityDestroy removeEntityPacket = new PacketPlayOutEntityDestroy(new int[]{this.af()});
        for (Player player : this.interaction.getRawLocation().getWorld().getPlayers()) {
            EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            serverPlayer.b.a((Packet)removeEntityPacket);
        }
    }

    @Override
    public void unloadInteraction(@NotNull Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.b.a((Packet)new PacketPlayOutEntityDestroy(new int[]{this.af()}));
    }
}

