/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.mcv.v1_19_4.event;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.event.IPacketHandler;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class PacketHandler
implements IPacketHandler {
    protected final GHoloMain gHoloMain;

    public PacketHandler(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    @Override
    public void setupPlayerPacketHandlers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.setupPlayerPacketHandler(player);
        }
    }

    @Override
    public void setupPlayerPacketHandler(final Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ChannelPipeline channelPipeline = this.getPipeline(serverPlayer);
        if (channelPipeline == null) {
            return;
        }
        if (channelPipeline.get("GHolo") != null) {
            channelPipeline.remove("GHolo");
        }
        channelPipeline.addBefore("packet_handler", "GHolo", (ChannelHandler)new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext channelHandlerContext, Object packet) throws Exception {
                if (PacketHandler.this.handlePacket(packet, player)) {
                    return;
                }
                super.channelRead(channelHandlerContext, packet);
            }
        });
    }

    @Override
    public void removePlayerPacketHandlers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removePlayerPacketHandler(player);
        }
    }

    @Override
    public void removePlayerPacketHandler(Player player) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ChannelPipeline channelPipeline = this.getPipeline(serverPlayer);
        if (channelPipeline != null && channelPipeline.get("GHolo") != null) {
            channelPipeline.remove("GHolo");
        }
    }

    private ChannelPipeline getPipeline(EntityPlayer serverPlayer) {
        return serverPlayer.b.h.m.pipeline();
    }

    private boolean handlePacket(Object packet, Player player) {
        if (!(packet instanceof PacketPlayInUseEntity)) {
            return false;
        }
        PacketPlayInUseEntity serverboundInteractPacket = (PacketPlayInUseEntity)packet;
        int targetId = serverboundInteractPacket.getEntityId();
        boolean mainHand = serverboundInteractPacket.getActionType().ordinal() == 1;
        boolean secondaryAction = serverboundInteractPacket.a();
        return this.gHoloMain.getInteractionService().callInteraction(targetId, player, mainHand, secondaryAction);
    }
}

