/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.event;

import dev.geco.gholo.GHoloMain;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;

public class PlayerEventHandler
implements Listener {
    private final GHoloMain gHoloMain;

    public PlayerEventHandler(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.gHoloMain.getUpdateService().checkForUpdates(player);
        this.gHoloMain.getTaskService().runDelayed(() -> {
            this.gHoloMain.getHoloService().loadHolosForPlayer(player);
            if (!this.gHoloMain.getInteractionService().hasInteractions()) {
                return;
            }
            this.gHoloMain.getPacketHandler().setupPlayerPacketHandler(player);
            this.gHoloMain.getInteractionService().loadInteractionsForPlayer(player);
        }, false, (Entity)player, 1L);
    }

    @EventHandler
    public void playerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.gHoloMain.getHoloService().clearHolosCurrentContentForPlayer(player);
        this.gHoloMain.getInteractionService().clearPlayerInteractions(player);
    }

    @EventHandler
    public void playerChangedWorldEvent(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        this.gHoloMain.getHoloService().clearHolosCurrentContentForPlayer(player);
        this.gHoloMain.getTaskService().runDelayed(() -> {
            this.gHoloMain.getHoloService().loadHolosForPlayer(player);
            this.gHoloMain.getInteractionService().loadInteractionsForPlayer(event.getPlayer());
        }, false, (Entity)player, 4L);
    }

    @EventHandler
    public void playerResourcePackStatusEvent(PlayerResourcePackStatusEvent event) {
        if (event.getStatus() != PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED) {
            return;
        }
        Player player = event.getPlayer();
        this.gHoloMain.getTaskService().runDelayed(() -> {
            this.gHoloMain.getHoloService().unloadHolosForPlayer(player);
            this.gHoloMain.getHoloService().loadHolosForPlayer(player);
        }, false, (Entity)player, 4L);
    }
}

