/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.cmd;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.interaction.GInteraction;
import dev.geco.gholo.object.interaction.GInteractionAction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.GInteractionUpdateType;
import dev.geco.gholo.object.interaction.action.GInteractionActionType;
import dev.geco.gholo.object.interaction.exporter.GInteractionExporter;
import dev.geco.gholo.object.interaction.exporter.GInteractionExporterResult;
import dev.geco.gholo.object.interaction.importer.GInteractionImporter;
import dev.geco.gholo.object.interaction.importer.GInteractionImporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GInteractionCommand
implements CommandExecutor {
    public static List<String> SUBCOMMANDS = List.of("help", "list", "near", "create", "info", "remove", "rename", "move", "tphere", "tp", "align", "addaction", "insertaction", "setaction", "removeaction", "copy", "option", "import", "export");
    private final GHoloMain gHoloMain;

    public GInteractionCommand(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!this.gHoloMain.getPermissionService().hasPermission((Permissible)sender, "Interaction")) {
            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-use-error", new Object[0]);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.gHoloMain.getMessageService().sendMessage(sender, "InteractionHelpCommand.header", new Object[0]);
                for (String helpRow : SUBCOMMANDS) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionHelpCommand." + helpRow.toLowerCase(), new Object[0]);
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "InteractionHelpCommand.footer", new Object[0]);
                break;
            }
            case "list": {
                List<GInteraction> interactionList = this.gHoloMain.getInteractionService().getInteractions();
                if (interactionList.isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-none", new Object[0]);
                    break;
                }
                try {
                    int pageSize = this.gHoloMain.getConfigService().LIST_PAGE_SIZE;
                    int page = args.length > 1 ? Integer.parseInt(args[1]) : 1;
                    int totalInteractionCount = interactionList.size();
                    int maxPage = (int)Math.ceil((double)totalInteractionCount / (double)pageSize);
                    page = Math.max(Math.min(page, maxPage), 1);
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionListCommand.header", "%Page%", page, "%MaxPage%", maxPage);
                    int startIndex = (page - 1) * pageSize;
                    int endIndex = Math.min(startIndex + pageSize, totalInteractionCount);
                    for (int i = startIndex; i < endIndex; ++i) {
                        GInteraction listInteraction = interactionList.get(i);
                        SimpleLocation interactionLocation = listInteraction.getRawLocation();
                        BigDecimal x = BigDecimal.valueOf(interactionLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal y = BigDecimal.valueOf(interactionLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal z = BigDecimal.valueOf(interactionLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                        this.gHoloMain.getMessageService().sendMessage(sender, "InteractionListCommand.interaction", "%Interaction%", listInteraction.getId(), "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", interactionLocation.getWorld().getName());
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionListCommand.footer", "%Page%", page, "%MaxPage%", maxPage);
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-list-page-error", "%Page%", args[1]);
                }
                break;
            }
            case "near": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (this.gHoloMain.getInteractionService().getInteractions().isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-none", new Object[0]);
                    break;
                }
                try {
                    double range = args.length > 1 ? Double.parseDouble(args[1]) : this.gHoloMain.getConfigService().NEAR_RANGE;
                    List<GInteraction> nearInteractionList = this.gHoloMain.getInteractionService().getNearInteractions(player.getLocation(), range);
                    if (nearInteractionList.isEmpty()) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-near-none", new Object[0]);
                        break;
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionNearCommand.header", "%Range%", range);
                    for (GInteraction nearInteraction : nearInteractionList) {
                        SimpleLocation interactionLocation = nearInteraction.getRawLocation();
                        BigDecimal x = BigDecimal.valueOf(interactionLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal y = BigDecimal.valueOf(interactionLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal z = BigDecimal.valueOf(interactionLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                        this.gHoloMain.getMessageService().sendMessage(sender, "InteractionNearCommand.interaction", "%Interaction%", nearInteraction.getId(), "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", interactionLocation.getWorld().getName());
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionNearCommand.footer", "%Range%", range);
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-near-range-error", "%Range%", args[1]);
                }
                break;
            }
            case "create": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-create-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-create-exist-error", "%Interaction%", interaction.getId());
                    break;
                }
                this.gHoloMain.getInteractionService().createInteraction(args[1], SimpleLocation.fromBukkitLocation(player.getLocation()));
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-create", "%Interaction%", args[1]);
                break;
            }
            case "info": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-info-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "InteractionInfoCommand.header", "%Interaction%", interaction.getId());
                SimpleLocation interactionInfoLocation = interaction.getRawLocation();
                BigDecimal x = BigDecimal.valueOf(interactionInfoLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal y = BigDecimal.valueOf(interactionInfoLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal z = BigDecimal.valueOf(interactionInfoLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                this.gHoloMain.getMessageService().sendMessage(sender, "InteractionInfoCommand.location", "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", interactionInfoLocation.getWorld().getName());
                int position = 1;
                for (GInteractionAction interactionAction : interaction.getActions()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "InteractionInfoCommand.action", "%Position%", position, "%Type%", interactionAction.getInteractionActionType().getType(), "%Parameter%", interactionAction.getParameter());
                    ++position;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "InteractionInfoCommand.footer", "%Interaction%", interaction.getId());
                break;
            }
            case "remove": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-remove-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                this.gHoloMain.getInteractionService().removeInteraction(interaction);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-remove", "%Interaction%", interaction.getId());
                break;
            }
            case "rename": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-rename-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                GInteraction newIdInteraction = this.gHoloMain.getInteractionService().getInteraction(args[2]);
                if (newIdInteraction != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-rename-exist-error", "%Interaction%", newIdInteraction.getId());
                    break;
                }
                String oldId = interaction.getId();
                this.gHoloMain.getInteractionService().updateInteractionId(interaction, args[2]);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-rename", "%Interaction%", interaction.getId(), "%OldInteraction%", oldId);
                break;
            }
            case "move": {
                if (args.length <= 4) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-move-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                try {
                    SimpleLocation location = interaction.getLocation();
                    double x = this.gHoloMain.getLocationUtil().parseLocationInput(args[2], location.getX());
                    double y = this.gHoloMain.getLocationUtil().parseLocationInput(args[3], location.getY());
                    double z = this.gHoloMain.getLocationUtil().parseLocationInput(args[4], location.getZ());
                    location.setX(x);
                    location.setY(y);
                    location.setZ(z);
                    this.gHoloMain.getInteractionService().updateInteractionLocation(interaction, location);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-move", "%Interaction%", interaction.getId());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-move-location-error", new Object[0]);
                }
                break;
            }
            case "tphere": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-tphere-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                this.gHoloMain.getInteractionService().updateInteractionLocation(interaction, SimpleLocation.fromBukkitLocation(player.getLocation()));
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-tphere", "%Interaction%", interaction.getId());
                break;
            }
            case "tp": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-tp-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                SimpleLocation location = interaction.getLocation();
                location.setYaw(player.getLocation().getYaw());
                location.setPitch(player.getLocation().getPitch());
                player.teleport((Location)location, PlayerTeleportEvent.TeleportCause.COMMAND);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-tp", "%Interaction%", interaction.getId());
                break;
            }
            case "align": {
                if (args.length <= 3) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-align-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                GInteraction alignOnInteraction = this.gHoloMain.getInteractionService().getInteraction(args[2]);
                if (alignOnInteraction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[2].toLowerCase());
                    break;
                }
                SimpleLocation interactionLocation = interaction.getLocation();
                SimpleLocation alignOnInteractionLocation = alignOnInteraction.getRawLocation();
                Object appliedAxis = "";
                String axis = args[3].toLowerCase();
                if (axis.contains("x")) {
                    interactionLocation.setX(alignOnInteractionLocation.getX());
                    appliedAxis = (String)appliedAxis + "x";
                }
                if (axis.contains("y")) {
                    interactionLocation.setY(alignOnInteractionLocation.getY());
                    appliedAxis = (String)appliedAxis + "y";
                }
                if (axis.contains("z")) {
                    interactionLocation.setZ(alignOnInteractionLocation.getZ());
                    appliedAxis = (String)appliedAxis + "z";
                }
                if (((String)appliedAxis).isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-align-axis-error", "%Axis%", axis);
                    break;
                }
                this.gHoloMain.getInteractionService().updateInteractionLocation(interaction, interactionLocation);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-align", "%Interaction%", interaction.getId(), "%Axis%", appliedAxis, "%AlignOnInteraction%", alignOnInteraction.getId());
                break;
            }
            case "addaction": {
                if (args.length <= 3) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-addaction-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                String addActionType = args[2].toLowerCase();
                GInteractionActionType addInteractionActionType = this.gHoloMain.getInteractionActionService().getInteractionAction(addActionType);
                if (addInteractionActionType == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-type-error", "%Type%", args[2]);
                    break;
                }
                StringBuilder addActionParameter = new StringBuilder();
                for (int arg = 3; arg <= args.length - 1; ++arg) {
                    addActionParameter.append(args[arg]).append(" ");
                }
                addActionParameter.deleteCharAt(addActionParameter.length() - 1);
                if (!addInteractionActionType.validateParameter(this.gHoloMain, addActionParameter.toString())) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-parameter-error", "%Type%", args[2], "%Parameter%", addActionParameter.toString());
                    break;
                }
                this.gHoloMain.getInteractionService().addInteractionAction(interaction, addInteractionActionType, addActionParameter.toString());
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-addaction", "%Interaction%", interaction.getId(), "%Type%", addActionType.toLowerCase(), "%Parameter%", addActionParameter.toString());
                break;
            }
            case "insertaction": {
                if (args.length <= 4) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-insertaction-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                try {
                    GInteractionAction interactionAction = interaction.getAction(Integer.parseInt(args[2]) - 1);
                    if (interactionAction == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                        break;
                    }
                    String insertActionType = args[3].toLowerCase();
                    GInteractionActionType insertInteractionActionType = this.gHoloMain.getInteractionActionService().getInteractionAction(insertActionType);
                    if (insertInteractionActionType == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-type-error", "%Type%", args[2]);
                        break;
                    }
                    StringBuilder insertActionParameter = new StringBuilder();
                    for (int arg = 4; arg <= args.length - 1; ++arg) {
                        insertActionParameter.append(args[arg]).append(" ");
                    }
                    insertActionParameter.deleteCharAt(insertActionParameter.length() - 1);
                    if (!insertInteractionActionType.validateParameter(this.gHoloMain, insertActionParameter.toString())) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-parameter-error", "%Type%", args[3], "%Parameter%", insertActionParameter.toString());
                        break;
                    }
                    this.gHoloMain.getInteractionService().insertInteractionAction(interaction, interactionAction.getPosition(), insertInteractionActionType, insertActionParameter.toString());
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-insertaction", "%Interaction%", interaction.getId(), "%Position%", Integer.parseInt(args[2]), "%Type%", insertActionType.toLowerCase(), "%Parameter%", insertActionParameter.toString());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                }
                break;
            }
            case "setaction": {
                if (args.length <= 4) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-setaction-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                try {
                    GInteractionAction interactionAction = interaction.getAction(Integer.parseInt(args[2]) - 1);
                    if (interactionAction == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                        break;
                    }
                    String setActionType = args[3].toLowerCase();
                    GInteractionActionType setInteractionActionType = this.gHoloMain.getInteractionActionService().getInteractionAction(setActionType);
                    if (setInteractionActionType == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-type-error", "%Type%", args[2]);
                        break;
                    }
                    StringBuilder setActionParameter = new StringBuilder();
                    for (int arg = 4; arg <= args.length - 1; ++arg) {
                        setActionParameter.append(args[arg]).append(" ");
                    }
                    setActionParameter.deleteCharAt(setActionParameter.length() - 1);
                    if (!setInteractionActionType.validateParameter(this.gHoloMain, setActionParameter.toString())) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-parameter-error", "%Type%", args[3], "%Parameter%", setActionParameter.toString());
                        break;
                    }
                    this.gHoloMain.getInteractionService().updateInteractionAction(interactionAction, setInteractionActionType, setActionParameter.toString());
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-setaction", "%Interaction%", interaction.getId(), "%Position%", Integer.parseInt(args[2]), "%Type%", setActionType.toLowerCase(), "%Parameter%", setActionParameter.toString());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                }
                break;
            }
            case "removeaction": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-removeaction-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                try {
                    GInteractionAction interactionAction = interaction.getAction(Integer.parseInt(args[2]) - 1);
                    if (interactionAction == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                        break;
                    }
                    this.gHoloMain.getInteractionService().removeInteractionAction(interactionAction);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-removeaction", "%Interaction%", interaction.getId(), "%Position%", Integer.parseInt(args[2]));
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-action-error", "%Position%", args[2]);
                }
                break;
            }
            case "copy": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-copy-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                if (this.gHoloMain.getInteractionService().getInteraction(args[2]) != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-copy-exist-error", "%Interaction%", args[2].toLowerCase());
                    break;
                }
                this.gHoloMain.getInteractionService().copyInteraction(interaction, args[2]);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-copy", "%Interaction%", interaction.getId(), "%NewInteraction%", args[2]);
                break;
            }
            case "option": {
                GInteractionUpdateType optionUpdateType;
                if (args.length <= 3) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-use-error", new Object[0]);
                    break;
                }
                GInteraction interaction = this.gHoloMain.getInteractionService().getInteraction(args[1]);
                if (interaction == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-exist-error", "%Interaction%", args[1]);
                    break;
                }
                GInteractionData data = interaction.getData();
                int optionArg = 2;
                block54 : switch (args[optionArg].toLowerCase()) {
                    case "permission": {
                        if (args[optionArg + 1].equalsIgnoreCase("*")) {
                            data.setPermission(GInteractionData.DEFAULT_PERMISSION);
                        } else {
                            data.setPermission(args[optionArg + 1]);
                        }
                        optionUpdateType = GInteractionUpdateType.PERMISSION;
                        break;
                    }
                    case "size": {
                        if (args.length == ++optionArg + 1) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-use-error", new Object[0]);
                            return true;
                        }
                        switch (args[optionArg].toLowerCase()) {
                            case "width": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawSize().setWidth(1.0f);
                                    } else {
                                        data.getRawSize().setWidth(Float.parseFloat(args[optionArg + 1]));
                                    }
                                    optionUpdateType = GInteractionUpdateType.SIZE;
                                    break block54;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                            case "height": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawSize().setHeight(1.0f);
                                    } else {
                                        data.getRawSize().setHeight(Float.parseFloat(args[optionArg + 1]));
                                    }
                                    optionUpdateType = GInteractionUpdateType.SIZE;
                                    break block54;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                        }
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-use-error", new Object[0]);
                        return true;
                    }
                    default: {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option-use-error", new Object[0]);
                        return true;
                    }
                }
                this.gHoloMain.getInteractionService().updateInteractionData(interaction, data);
                interaction.getInteractionEntity().publishUpdate(optionUpdateType);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-option", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                break;
            }
            case "import": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-import-use-error", new Object[0]);
                    break;
                }
                GInteractionImporter interactionImporter = this.gHoloMain.getInteractionImporterService().getInteractionImporter(args[1]);
                if (interactionImporter == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-import-exist-error", "%Type%", args[1]);
                    break;
                }
                boolean override = true;
                if (args.length > 2) {
                    override = Boolean.parseBoolean(args[2]);
                }
                GInteractionImporterResult importerResult = interactionImporter.importInteractions(this.gHoloMain, override);
                this.gHoloMain.getInteractionService().unloadInteractions(null);
                this.gHoloMain.getInteractionService().loadInteractions(null);
                if (!importerResult.hasSucceeded()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-import-import-error", "%Type%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-import", "%Type%", args[1], "%Count%", importerResult.getCount());
                break;
            }
            case "export": {
                GInteractionExporterResult exporterResult;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-export-use-error", new Object[0]);
                    break;
                }
                GInteractionExporter interactionExporter = this.gHoloMain.getInteractionExporterService().getInteractionExporter(args[1]);
                if (interactionExporter == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-export-exist-error", "%Type%", args[1]);
                    break;
                }
                boolean override = true;
                if (args.length > 2) {
                    override = Boolean.parseBoolean(args[2]);
                }
                if (!(exporterResult = interactionExporter.exportInteractions(this.gHoloMain, override)).hasSucceeded()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-export-export-error", "%Type%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-export", "%Type%", args[1], "%Count%", exporterResult.getCount());
                break;
            }
            default: {
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-ginteraction-use-error", new Object[0]);
            }
        }
        return true;
    }
}

