/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.cmd;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.holo.GHoloUpdateType;
import dev.geco.gholo.object.holo.exporter.GHoloExporter;
import dev.geco.gholo.object.holo.exporter.GHoloExporterResult;
import dev.geco.gholo.object.holo.importer.GHoloImporter;
import dev.geco.gholo.object.holo.importer.GHoloImporterResult;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import dev.geco.gholo.util.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class GHoloCommand
implements CommandExecutor {
    public static List<String> SUBCOMMANDS = List.of("help", "list", "near", "create", "info", "remove", "rename", "move", "tphere", "tp", "align", "addrow", "insertrow", "setrow", "removerow", "offsetrow", "copy", "option", "image", "import", "export");
    private final GHoloMain gHoloMain;

    public GHoloCommand(GHoloMain gHoloMain) {
        this.gHoloMain = gHoloMain;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!this.gHoloMain.getPermissionService().hasPermission((Permissible)sender, "Holo")) {
            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-permission-error", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-use-error", new Object[0]);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "help": {
                this.gHoloMain.getMessageService().sendMessage(sender, "HoloHelpCommand.header", new Object[0]);
                for (String helpRow : SUBCOMMANDS) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloHelpCommand." + helpRow.toLowerCase(), new Object[0]);
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "HoloHelpCommand.footer", new Object[0]);
                break;
            }
            case "list": {
                List<GHolo> holoList = this.gHoloMain.getHoloService().getHolos();
                if (holoList.isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-none", new Object[0]);
                    break;
                }
                try {
                    int pageSize = this.gHoloMain.getConfigService().LIST_PAGE_SIZE;
                    int page = args.length > 1 ? Integer.parseInt(args[1]) : 1;
                    int totalHoloCount = holoList.size();
                    int maxPage = (int)Math.ceil((double)totalHoloCount / (double)pageSize);
                    page = Math.max(Math.min(page, maxPage), 1);
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloListCommand.header", "%Page%", page, "%MaxPage%", maxPage);
                    int startIndex = (page - 1) * pageSize;
                    int endIndex = Math.min(startIndex + pageSize, totalHoloCount);
                    for (int i = startIndex; i < endIndex; ++i) {
                        GHolo listHolo = holoList.get(i);
                        SimpleLocation holoLocation = listHolo.getRawLocation();
                        BigDecimal x = BigDecimal.valueOf(holoLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal y = BigDecimal.valueOf(holoLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal z = BigDecimal.valueOf(holoLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                        this.gHoloMain.getMessageService().sendMessage(sender, "HoloListCommand.holo", "%Holo%", listHolo.getId(), "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", holoLocation.getWorld().getName());
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloListCommand.footer", "%Page%", page, "%MaxPage%", maxPage);
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-list-page-error", "%Page%", args[1]);
                }
                break;
            }
            case "near": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (this.gHoloMain.getHoloService().getHolos().isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-none", new Object[0]);
                    break;
                }
                try {
                    double range = args.length > 1 ? Double.parseDouble(args[1]) : this.gHoloMain.getConfigService().NEAR_RANGE;
                    List<GHolo> nearHoloList = this.gHoloMain.getHoloService().getNearHolos(player.getLocation(), range);
                    if (nearHoloList.isEmpty()) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-near-none", new Object[0]);
                        break;
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloNearCommand.header", "%Range%", range);
                    for (GHolo nearHolo : nearHoloList) {
                        SimpleLocation holoLocation = nearHolo.getRawLocation();
                        BigDecimal x = BigDecimal.valueOf(holoLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal y = BigDecimal.valueOf(holoLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                        BigDecimal z = BigDecimal.valueOf(holoLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                        this.gHoloMain.getMessageService().sendMessage(sender, "HoloNearCommand.holo", "%Holo%", nearHolo.getId(), "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", holoLocation.getWorld().getName());
                    }
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloNearCommand.footer", "%Range%", range);
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-near-range-error", "%Range%", args[1]);
                }
                break;
            }
            case "create": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-create-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-create-exist-error", "%Holo%", holo.getId());
                    break;
                }
                this.gHoloMain.getHoloService().createHolo(args[1], SimpleLocation.fromBukkitLocation(player.getLocation()));
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-create", "%Holo%", args[1]);
                break;
            }
            case "info": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-info-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "HoloInfoCommand.header", "%Holo%", holo.getId());
                SimpleLocation holoInfoLocation = holo.getRawLocation();
                BigDecimal x = BigDecimal.valueOf(holoInfoLocation.getX()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal y = BigDecimal.valueOf(holoInfoLocation.getY()).setScale(2, RoundingMode.HALF_UP);
                BigDecimal z = BigDecimal.valueOf(holoInfoLocation.getZ()).setScale(2, RoundingMode.HALF_UP);
                this.gHoloMain.getMessageService().sendMessage(sender, "HoloInfoCommand.location", "%X%", x.stripTrailingZeros().toPlainString(), "%Y%", y.stripTrailingZeros().toPlainString(), "%Z%", z.stripTrailingZeros().toPlainString(), "%World%", holoInfoLocation.getWorld().getName());
                int position = 1;
                for (GHoloRow holoRow : holo.getRows()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "HoloInfoCommand.row", "%Position%", position, "%Content%", holoRow.getContent());
                    ++position;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "HoloInfoCommand.footer", "%Holo%", holo.getId());
                break;
            }
            case "remove": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-remove-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                this.gHoloMain.getHoloService().removeHolo(holo);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-remove", "%Holo%", holo.getId());
                break;
            }
            case "rename": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-rename-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                GHolo newIdHolo = this.gHoloMain.getHoloService().getHolo(args[2]);
                if (newIdHolo != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-rename-exist-error", "%Holo%", newIdHolo.getId());
                    break;
                }
                String oldId = holo.getId();
                this.gHoloMain.getHoloService().updateHoloId(holo, args[2]);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-rename", "%Holo%", holo.getId(), "%OldHolo%", oldId);
                break;
            }
            case "move": {
                if (args.length <= 4) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-move-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                try {
                    SimpleLocation location = holo.getLocation();
                    double x = this.gHoloMain.getLocationUtil().parseLocationInput(args[2], location.getX());
                    double y = this.gHoloMain.getLocationUtil().parseLocationInput(args[3], location.getY());
                    double z = this.gHoloMain.getLocationUtil().parseLocationInput(args[4], location.getZ());
                    location.setX(x);
                    location.setY(y);
                    location.setZ(z);
                    this.gHoloMain.getHoloService().updateHoloLocation(holo, location);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-move", "%Holo%", holo.getId());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-move-location-error", new Object[0]);
                }
                break;
            }
            case "tphere": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-tphere-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                this.gHoloMain.getHoloService().updateHoloLocation(holo, SimpleLocation.fromBukkitLocation(player.getLocation()));
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-tphere", "%Holo%", holo.getId());
                break;
            }
            case "tp": {
                if (!(sender instanceof Player)) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-sender-error", new Object[0]);
                    break;
                }
                Player player = (Player)sender;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-tp-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                SimpleLocation location = holo.getLocation();
                location.setYaw(player.getLocation().getYaw());
                location.setPitch(player.getLocation().getPitch());
                player.teleport((Location)location, PlayerTeleportEvent.TeleportCause.COMMAND);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-tp", "%Holo%", holo.getId());
                break;
            }
            case "align": {
                if (args.length <= 3) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-align-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                GHolo alignOnHolo = this.gHoloMain.getHoloService().getHolo(args[2]);
                if (alignOnHolo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[2].toLowerCase());
                    break;
                }
                SimpleLocation holoLocation = holo.getLocation();
                SimpleLocation alignOnHoloLocation = alignOnHolo.getRawLocation();
                Object appliedAxis = "";
                String axis = args[3].toLowerCase();
                if (axis.contains("x")) {
                    holoLocation.setX(alignOnHoloLocation.getX());
                    appliedAxis = (String)appliedAxis + "x";
                }
                if (axis.contains("y")) {
                    holoLocation.setY(alignOnHoloLocation.getY());
                    appliedAxis = (String)appliedAxis + "y";
                }
                if (axis.contains("z")) {
                    holoLocation.setZ(alignOnHoloLocation.getZ());
                    appliedAxis = (String)appliedAxis + "z";
                }
                if (((String)appliedAxis).isEmpty()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-align-axis-error", "%Axis%", axis);
                    break;
                }
                this.gHoloMain.getHoloService().updateHoloLocation(holo, holoLocation);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-align", "%Holo%", holo.getId(), "%Axis%", appliedAxis, "%AlignOnHolo%", alignOnHolo.getId());
                break;
            }
            case "addrow": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-addrow-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                StringBuilder addIdStringBuilder = new StringBuilder();
                if (args.length > 2) {
                    for (int arg = 2; arg <= args.length - 1; ++arg) {
                        addIdStringBuilder.append(args[arg]).append(" ");
                    }
                    addIdStringBuilder.deleteCharAt(addIdStringBuilder.length() - 1);
                }
                this.gHoloMain.getHoloService().addHoloRow(holo, addIdStringBuilder.toString());
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-addrow", "%Holo%", holo.getId(), "%Content%", addIdStringBuilder.toString());
                break;
            }
            case "insertrow": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-insertrow-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                try {
                    GHoloRow holoRow = holo.getRow(Integer.parseInt(args[2]) - 1);
                    if (holoRow == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                        break;
                    }
                    StringBuilder insertIdStringBuilder = new StringBuilder();
                    if (args.length > 3) {
                        for (int arg = 3; arg <= args.length - 1; ++arg) {
                            insertIdStringBuilder.append(args[arg]).append(" ");
                        }
                        insertIdStringBuilder.deleteCharAt(insertIdStringBuilder.length() - 1);
                    }
                    this.gHoloMain.getHoloService().insertHoloRow(holo, holoRow.getPosition(), insertIdStringBuilder.toString(), true);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-insertrow", "%Holo%", holo.getId(), "%Position%", Integer.parseInt(args[2]), "%Content%", insertIdStringBuilder.toString());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                }
                break;
            }
            case "setrow": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-setrow-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                try {
                    GHoloRow holoRow = holo.getRow(Integer.parseInt(args[2]) - 1);
                    if (holoRow == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                        break;
                    }
                    StringBuilder setIdStringBuilder = new StringBuilder();
                    if (args.length > 3) {
                        for (int arg = 3; arg <= args.length - 1; ++arg) {
                            setIdStringBuilder.append(args[arg]).append(" ");
                        }
                        setIdStringBuilder.deleteCharAt(setIdStringBuilder.length() - 1);
                    }
                    this.gHoloMain.getHoloService().updateHoloRowContent(holoRow, setIdStringBuilder.toString());
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-setrow", "%Holo%", holo.getId(), "%Position%", Integer.parseInt(args[2]), "%Content%", setIdStringBuilder.toString());
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                }
                break;
            }
            case "removerow": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-removerow-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                try {
                    GHoloRow holoRow = holo.getRow(Integer.parseInt(args[2]) - 1);
                    if (holoRow == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                        break;
                    }
                    boolean updateOffsets = true;
                    if (args.length > 3) {
                        updateOffsets = Boolean.parseBoolean(args[3]);
                    }
                    this.gHoloMain.getHoloService().removeHoloRow(holoRow, updateOffsets);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-removerow", "%Holo%", holo.getId(), "%Position%", Integer.parseInt(args[2]));
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                }
                break;
            }
            case "offsetrow": {
                if (args.length <= 5) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-offsetrow-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                try {
                    GHoloRow holoRow = holo.getRow(Integer.parseInt(args[2]) - 1);
                    if (holoRow == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                        break;
                    }
                    try {
                        SimpleVector offset = holoRow.getOffset();
                        offset.setX(args[3].equalsIgnoreCase("*") ? 0.0 : this.gHoloMain.getLocationUtil().parseLocationInput(args[3], offset.getX()));
                        if (args[4].equalsIgnoreCase("*")) {
                            double sizeBetweenRows = this.gHoloMain.getConfigService().DEFAULT_SIZE_BETWEEN_ROWS;
                            double rowOffset = sizeBetweenRows * (double)holoRow.getPosition();
                            offset.setY(-rowOffset);
                        } else {
                            offset.setY(this.gHoloMain.getLocationUtil().parseLocationInput(args[4], offset.getY()));
                        }
                        offset.setZ(args[5].equalsIgnoreCase("*") ? 0.0 : this.gHoloMain.getLocationUtil().parseLocationInput(args[5], offset.getZ()));
                        this.gHoloMain.getHoloService().updateHoloRowOffset(holoRow, offset);
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-offsetrow", "%Holo%", holo.getId());
                    }
                    catch (NumberFormatException e) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-offsetrow-offset-error", new Object[0]);
                    }
                }
                catch (NumberFormatException e) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[2]);
                }
                break;
            }
            case "copy": {
                if (args.length <= 2) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-copy-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                if (this.gHoloMain.getHoloService().getHolo(args[2]) != null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-copy-exist-error", "%Holo%", args[2].toLowerCase());
                    break;
                }
                this.gHoloMain.getHoloService().copyHolo(holo, args[2]);
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-copy", "%Holo%", holo.getId(), "%NewHolo%", args[2]);
                break;
            }
            case "option": {
                GHoloUpdateType optionUpdateType;
                if (args.length <= 4) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                GHoloData data = null;
                int optionArg = 3;
                GHoloRow optionHoloRow = null;
                switch (args[2].toLowerCase()) {
                    case "holo": {
                        data = holo.getData();
                        break;
                    }
                    case "row": {
                        try {
                            optionHoloRow = holo.getRow(Integer.parseInt(args[3]) - 1);
                            if (optionHoloRow == null) {
                                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[3]);
                                return true;
                            }
                            data = optionHoloRow.getData();
                            optionArg = 4;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-row-error", "%Position%", args[3]);
                            return true;
                        }
                    }
                }
                if (data == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                    break;
                }
                block89 : switch (args[optionArg].toLowerCase()) {
                    case "range": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setRange(120.0);
                            } else {
                                data.setRange(Double.parseDouble(args[optionArg + 1]));
                            }
                            optionUpdateType = GHoloUpdateType.RANGE;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "background_color": {
                        if (args[optionArg + 1].equalsIgnoreCase("*")) {
                            data.setBackgroundColor("#000000");
                        } else {
                            String backgroundColor = args[optionArg + 1].toLowerCase();
                            if (backgroundColor.matches("^#?[0-9A-Fa-f]{6}([0-9A-Fa-f]{2})?$") || backgroundColor.equalsIgnoreCase("transparent")) {
                                data.setBackgroundColor(backgroundColor);
                            } else {
                                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", backgroundColor);
                                return true;
                            }
                        }
                        optionUpdateType = GHoloUpdateType.BACKGROUND_COLOR;
                        break;
                    }
                    case "text_opacity": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setTextOpacity((byte)0);
                            } else {
                                data.setTextOpacity(Byte.parseByte(args[optionArg + 1]));
                            }
                            optionUpdateType = GHoloUpdateType.TEXT_OPACITY;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "text_shadow": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setTextShadow(false);
                            } else {
                                data.setTextShadow(Boolean.parseBoolean(args[optionArg + 1]));
                            }
                            optionUpdateType = GHoloUpdateType.TEXT_SHADOW;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "text_alignment": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setTextAlignment("center");
                            } else {
                                data.setTextAlignment(TextDisplay.TextAlignment.valueOf((String)args[optionArg + 1].toUpperCase()).name().toLowerCase());
                            }
                            optionUpdateType = GHoloUpdateType.TEXT_ALIGNMENT;
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1].toUpperCase());
                            return true;
                        }
                    }
                    case "billboard": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setBillboard("center");
                            } else {
                                data.setBillboard(Display.Billboard.valueOf((String)args[optionArg + 1].toUpperCase()).name().toLowerCase());
                            }
                            optionUpdateType = GHoloUpdateType.BILLBOARD;
                            break;
                        }
                        catch (IllegalArgumentException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1].toUpperCase());
                            return true;
                        }
                    }
                    case "see_through": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setSeeThrough(false);
                            } else {
                                data.setSeeThrough(Boolean.parseBoolean(args[optionArg + 1]));
                            }
                            optionUpdateType = GHoloUpdateType.SEE_THROUGH;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "scale": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setScale(GHoloData.DEFAULT_SCALE);
                            } else {
                                data.setScale(new SimpleVector(Float.parseFloat(args[optionArg + 1]), Float.parseFloat(args[optionArg + 1]), Float.parseFloat(args[optionArg + 1])));
                            }
                            optionUpdateType = GHoloUpdateType.SCALE;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "rotation": {
                        if (args.length == ++optionArg + 1) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                            return true;
                        }
                        switch (args[optionArg].toLowerCase()) {
                            case "yaw": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawRotation().setYaw(null);
                                    } else {
                                        data.getRawRotation().setYaw(Float.valueOf(Float.parseFloat(args[optionArg + 1])));
                                    }
                                    optionUpdateType = GHoloUpdateType.LOCATION;
                                    break block89;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                            case "pitch": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawRotation().setPitch(null);
                                    } else {
                                        data.getRawRotation().setPitch(Float.valueOf(Float.parseFloat(args[optionArg + 1])));
                                    }
                                    optionUpdateType = GHoloUpdateType.LOCATION;
                                    break block89;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                        }
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                        return true;
                    }
                    case "brightness": {
                        try {
                            if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                data.setBrightness((byte)0);
                            } else {
                                data.setBrightness(Byte.parseByte(args[optionArg + 1]));
                            }
                            optionUpdateType = GHoloUpdateType.BRIGHTNESS;
                            break;
                        }
                        catch (NumberFormatException e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                            return true;
                        }
                    }
                    case "permission": {
                        if (args[optionArg + 1].equalsIgnoreCase("*")) {
                            data.setPermission(GHoloData.DEFAULT_PERMISSION);
                        } else {
                            data.setPermission(args[optionArg + 1]);
                        }
                        optionUpdateType = GHoloUpdateType.PERMISSION;
                        break;
                    }
                    case "size": {
                        if (args.length == ++optionArg + 1) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                            return true;
                        }
                        switch (args[optionArg].toLowerCase()) {
                            case "width": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawSize().setWidth(1.0f);
                                    } else {
                                        data.getRawSize().setWidth(Float.parseFloat(args[optionArg + 1]));
                                    }
                                    optionUpdateType = GHoloUpdateType.SIZE;
                                    break block89;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                            case "height": {
                                try {
                                    if (args[optionArg + 1].equalsIgnoreCase("*")) {
                                        data.getRawSize().setHeight(1.0f);
                                    } else {
                                        data.getRawSize().setHeight(Float.parseFloat(args[optionArg + 1]));
                                    }
                                    optionUpdateType = GHoloUpdateType.SIZE;
                                    break block89;
                                }
                                catch (NumberFormatException e) {
                                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-value-error", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                                    return true;
                                }
                            }
                        }
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                        return true;
                    }
                    default: {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option-use-error", new Object[0]);
                        return true;
                    }
                }
                if (optionHoloRow == null) {
                    this.gHoloMain.getHoloService().updateHoloData(holo, data);
                    for (GHoloRow updateHoloRow : holo.getRows()) {
                        updateHoloRow.getHoloRowContent().publishUpdate(optionUpdateType);
                    }
                } else {
                    this.gHoloMain.getHoloService().updateHoloRowData(optionHoloRow, data);
                    optionHoloRow.getHoloRowContent().publishUpdate(optionUpdateType);
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-option", "%Option%", args[optionArg], "%Value%", args[optionArg + 1]);
                break;
            }
            case "image": {
                if (args.length <= 3) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-image-use-error", new Object[0]);
                    break;
                }
                GHolo holo = this.gHoloMain.getHoloService().getHolo(args[1]);
                if (holo == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-exist-error", "%Holo%", args[1]);
                    break;
                }
                this.gHoloMain.getTaskService().run(() -> {
                    List<String> rows;
                    BufferedImage bufferedImage = null;
                    switch (args[2].toLowerCase()) {
                        case "file": {
                            File imageFile = new File(ImageUtil.IMAGE_FOLDER, args[3]);
                            if (!imageFile.exists()) break;
                            bufferedImage = ImageUtil.getBufferedImage(imageFile);
                            break;
                        }
                        case "url": {
                            bufferedImage = ImageUtil.getBufferedImage(args[3]);
                            break;
                        }
                        case "avatar": 
                        case "helm": {
                            OfflinePlayer target;
                            try {
                                target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[3]));
                            }
                            catch (Throwable e) {
                                target = Bukkit.getOfflinePlayer((String)args[3]);
                            }
                            bufferedImage = ImageUtil.getBufferedImage(target, args[2].equalsIgnoreCase("helm"));
                            break;
                        }
                        default: {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-image-use-error", new Object[0]);
                            return;
                        }
                    }
                    if (bufferedImage == null) {
                        this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-image-image-error", "%Type%", args[2].toLowerCase(), "%Source%", args[3]);
                        return;
                    }
                    if (args.length > 4) {
                        try {
                            if (args[4].contains(":")) {
                                String[] sizes = args[4].split(":");
                                rows = new ImageUtil(bufferedImage, Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1])).getLines();
                            }
                            rows = new ImageUtil(bufferedImage, Integer.parseInt(args[4])).getLines();
                        }
                        catch (Throwable e) {
                            this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-image-size-error", new Object[0]);
                            return;
                        }
                    } else {
                        rows = new ImageUtil(bufferedImage).getLines();
                    }
                    this.gHoloMain.getHoloService().setAllHoloRowContent(holo, rows);
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-image", "%Holo%", holo.getId(), "%Type%", args[2].toLowerCase(), "%Source%", args[3]);
                }, false);
                break;
            }
            case "import": {
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-import-use-error", new Object[0]);
                    break;
                }
                GHoloImporter holoImporter = this.gHoloMain.getHoloImporterService().getHoloImporter(args[1]);
                if (holoImporter == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-import-exist-error", "%Type%", args[1]);
                    break;
                }
                boolean override = true;
                if (args.length > 2) {
                    override = Boolean.parseBoolean(args[2]);
                }
                GHoloImporterResult importerResult = holoImporter.importHolos(this.gHoloMain, override);
                this.gHoloMain.getHoloService().unloadHolos(null);
                this.gHoloMain.getHoloService().loadHolos(null);
                if (!importerResult.hasSucceeded()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-import-import-error", "%Type%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-import", "%Type%", args[1], "%Count%", importerResult.getCount());
                break;
            }
            case "export": {
                GHoloExporterResult exporterResult;
                if (args.length == 1) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-export-use-error", new Object[0]);
                    break;
                }
                GHoloExporter holoExporter = this.gHoloMain.getHoloExporterService().getHoloExporter(args[1]);
                if (holoExporter == null) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-export-exist-error", "%Type%", args[1]);
                    break;
                }
                boolean override = true;
                if (args.length > 2) {
                    override = Boolean.parseBoolean(args[2]);
                }
                if (!(exporterResult = holoExporter.exportHolos(this.gHoloMain, override)).hasSucceeded()) {
                    this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-export-export-error", "%Type%", args[1]);
                    break;
                }
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-export", "%Type%", args[1], "%Count%", exporterResult.getCount());
                break;
            }
            default: {
                this.gHoloMain.getMessageService().sendMessage(sender, "Messages.command-gholo-use-error", new Object[0]);
            }
        }
        return true;
    }
}

