/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo.api;

import dev.geco.gholo.GHoloMain;
import dev.geco.gholo.object.holo.GHolo;
import dev.geco.gholo.object.holo.GHoloData;
import dev.geco.gholo.object.holo.GHoloRow;
import dev.geco.gholo.object.interaction.GInteraction;
import dev.geco.gholo.object.interaction.GInteractionAction;
import dev.geco.gholo.object.interaction.GInteractionData;
import dev.geco.gholo.object.interaction.action.GInteractionActionType;
import dev.geco.gholo.object.simple.SimpleLocation;
import dev.geco.gholo.object.simple.SimpleVector;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GHoloAPI {
    @NotNull
    public static GHoloMain getInstance() {
        return GHoloMain.getInstance();
    }

    @NotNull
    public static Collection<GHolo> getHolos() {
        return GHoloAPI.getInstance().getHoloService().getHolos();
    }

    @NotNull
    public static List<GHolo> getNearHolos(@NotNull Location location, double range) {
        return GHoloAPI.getInstance().getHoloService().getNearHolos(location, range);
    }

    @Nullable
    public static GHolo getHolo(@NotNull String holoId) {
        return GHoloAPI.getInstance().getHoloService().getHolo(holoId);
    }

    @Nullable
    public static GHolo createHolo(@NotNull String holoId, @NotNull SimpleLocation location) {
        return GHoloAPI.getInstance().getHoloService().createHolo(holoId, location);
    }

    @Nullable
    public static GHoloRow addHoloRow(@NotNull GHolo holo, @NotNull String content) {
        return GHoloAPI.getInstance().getHoloService().addHoloRow(holo, content);
    }

    @Nullable
    public static GHoloRow insertHoloRow(@NotNull GHolo holo, int position, @NotNull String content, boolean updateOffset) {
        return GHoloAPI.getInstance().getHoloService().insertHoloRow(holo, position, content, updateOffset);
    }

    public static void updateHoloRowContent(@NotNull GHoloRow holoRow, @NotNull String content) {
        GHoloAPI.getInstance().getHoloService().updateHoloRowContent(holoRow, content);
    }

    public static void updateHoloRowOffset(@NotNull GHoloRow holoRow, @NotNull SimpleVector offset) {
        GHoloAPI.getInstance().getHoloService().updateHoloRowOffset(holoRow, offset);
    }

    public static void updateHoloRowData(@NotNull GHoloRow holoRow, @NotNull GHoloData data) {
        GHoloAPI.getInstance().getHoloService().updateHoloRowData(holoRow, data);
    }

    public static void removeHoloRow(@NotNull GHoloRow holoRow, boolean updateOffset) {
        GHoloAPI.getInstance().getHoloService().removeHoloRow(holoRow, updateOffset);
    }

    public static void updateHoloId(@NotNull GHolo holo, @NotNull String holoId) {
        GHoloAPI.getInstance().getHoloService().updateHoloId(holo, holoId);
    }

    public static void updateHoloLocation(@NotNull GHolo holo, @NotNull SimpleLocation location) {
        GHoloAPI.getInstance().getHoloService().updateHoloLocation(holo, location);
    }

    public static void updateHoloData(@NotNull GHolo holo, @NotNull GHoloData data) {
        GHoloAPI.getInstance().getHoloService().updateHoloData(holo, data);
    }

    public static void setAllHoloRowContent(@NotNull GHolo holo, @NotNull List<String> rows) {
        GHoloAPI.getInstance().getHoloService().setAllHoloRowContent(holo, rows);
    }

    public static void copyHolo(@NotNull GHolo holo, @NotNull String holoId) {
        GHoloAPI.getInstance().getHoloService().copyHolo(holo, holoId);
    }

    public static void removeHolo(@NotNull GHolo holo) {
        GHoloAPI.getInstance().getHoloService().removeHolo(holo);
    }

    public static void loadHolosForPlayer(@NotNull Player player) {
        GHoloAPI.getInstance().getHoloService().loadHolosForPlayer(player);
    }

    public static void loadHolo(@NotNull GHolo holo) {
        GHoloAPI.getInstance().getHoloService().loadHolo(holo);
    }

    public static void loadHoloForPlayer(@NotNull GHolo holo, @NotNull Player player) {
        GHoloAPI.getInstance().getHoloService().unloadHoloForPlayer(holo, player);
    }

    public static void unloadHolosForPlayer(@NotNull Player player) {
        GHoloAPI.getInstance().getHoloService().unloadHolosForPlayer(player);
    }

    public static void unloadHolo(@NotNull GHolo holo) {
        GHoloAPI.getInstance().getHoloService().unloadHolo(holo);
    }

    public static void unloadHoloForPlayer(@NotNull GHolo holo, @NotNull Player player) {
        GHoloAPI.getInstance().getHoloService().unloadHoloForPlayer(holo, player);
    }

    @NotNull
    public static Collection<GInteraction> getInteractions() {
        return GHoloAPI.getInstance().getInteractionService().getInteractions();
    }

    @NotNull
    public static List<GInteraction> getNearInteractions(@NotNull Location location, double range) {
        return GHoloAPI.getInstance().getInteractionService().getNearInteractions(location, range);
    }

    @Nullable
    public static GInteraction getInteraction(@NotNull String interactionId) {
        return GHoloAPI.getInstance().getInteractionService().getInteraction(interactionId);
    }

    @Nullable
    public static GInteraction createInteraction(@NotNull String interactionId, @NotNull SimpleLocation location) {
        return GHoloAPI.getInstance().getInteractionService().createInteraction(interactionId, location);
    }

    @Nullable
    public static GInteractionAction addInteractionAction(@NotNull GInteraction interaction, @NotNull GInteractionActionType interactionActionType, @NotNull String parameter) {
        return GHoloAPI.getInstance().getInteractionService().addInteractionAction(interaction, interactionActionType, parameter);
    }

    @Nullable
    public static GInteractionAction insertInteractionAction(@NotNull GInteraction interaction, int position, @NotNull GInteractionActionType interactionActionType, @NotNull String parameter) {
        return GHoloAPI.getInstance().getInteractionService().insertInteractionAction(interaction, position, interactionActionType, parameter);
    }

    public static void updateInteractionAction(@NotNull GInteractionAction interactionAction, @NotNull GInteractionActionType interactionActionType, @NotNull String parameter) {
        GHoloAPI.getInstance().getInteractionService().updateInteractionAction(interactionAction, interactionActionType, parameter);
    }

    public static void removeInteractionAction(@NotNull GInteractionAction interactionAction) {
        GHoloAPI.getInstance().getInteractionService().removeInteractionAction(interactionAction);
    }

    public static void updateInteractionId(@NotNull GInteraction interaction, @NotNull String interactionId) {
        GHoloAPI.getInstance().getInteractionService().updateInteractionId(interaction, interactionId);
    }

    public static void updateInteractionLocation(@NotNull GInteraction interaction, @NotNull SimpleLocation location) {
        GHoloAPI.getInstance().getInteractionService().updateInteractionLocation(interaction, location);
    }

    public static void updateInteractionData(@NotNull GInteraction interaction, @NotNull GInteractionData data) {
        GHoloAPI.getInstance().getInteractionService().updateInteractionData(interaction, data);
    }

    public static void copyInteraction(@NotNull GInteraction interaction, @NotNull String interactionId) {
        GHoloAPI.getInstance().getInteractionService().copyInteraction(interaction, interactionId);
    }

    public static void removeInteraction(@NotNull GInteraction interaction) {
        GHoloAPI.getInstance().getInteractionService().removeInteraction(interaction);
    }

    public static void loadInteractionsForPlayer(@NotNull Player player) {
        GHoloAPI.getInstance().getInteractionService().loadInteractionsForPlayer(player);
    }

    public static void loadInteraction(@NotNull GInteraction interaction) {
        GHoloAPI.getInstance().getInteractionService().loadInteraction(interaction);
    }

    public static void loadInteractionForPlayer(@NotNull GInteraction interaction, @NotNull Player player) {
        GHoloAPI.getInstance().getInteractionService().unloadInteractionForPlayer(interaction, player);
    }

    public static void unloadInteractionsForPlayer(@NotNull Player player) {
        GHoloAPI.getInstance().getInteractionService().unloadInteractionsForPlayer(player);
    }

    public static void unloadInteraction(@NotNull GInteraction interaction) {
        GHoloAPI.getInstance().getInteractionService().unloadInteraction(interaction);
    }

    public static void unloadInteractionForPlayer(@NotNull GInteraction interaction, @NotNull Player player) {
        GHoloAPI.getInstance().getInteractionService().unloadInteractionForPlayer(interaction, player);
    }
}

