/*
 * Decompiled with CFR 0.152.
 */
package dev.geco.gholo;

import dev.geco.gholo.api.event.GHoloLoadedEvent;
import dev.geco.gholo.api.event.GHoloReloadEvent;
import dev.geco.gholo.cmd.GHoloCommand;
import dev.geco.gholo.cmd.GHoloReloadCommand;
import dev.geco.gholo.cmd.GInteractionCommand;
import dev.geco.gholo.cmd.tab.EmptyTabComplete;
import dev.geco.gholo.cmd.tab.GHoloTabComplete;
import dev.geco.gholo.cmd.tab.GInteractionTabComplete;
import dev.geco.gholo.event.IPacketHandler;
import dev.geco.gholo.event.InteractionEventHandler;
import dev.geco.gholo.event.PlayerEventHandler;
import dev.geco.gholo.event.WorldEventHandler;
import dev.geco.gholo.metric.BStatsMetric;
import dev.geco.gholo.service.ConfigService;
import dev.geco.gholo.service.DataService;
import dev.geco.gholo.service.HoloAnimationService;
import dev.geco.gholo.service.HoloExporterService;
import dev.geco.gholo.service.HoloImporterService;
import dev.geco.gholo.service.HoloService;
import dev.geco.gholo.service.InteractionActionService;
import dev.geco.gholo.service.InteractionExporterService;
import dev.geco.gholo.service.InteractionImporterService;
import dev.geco.gholo.service.InteractionService;
import dev.geco.gholo.service.MessageService;
import dev.geco.gholo.service.PermissionService;
import dev.geco.gholo.service.TaskService;
import dev.geco.gholo.service.UpdateService;
import dev.geco.gholo.service.VersionService;
import dev.geco.gholo.service.message.PaperMessageService;
import dev.geco.gholo.service.message.SpigotMessageService;
import dev.geco.gholo.util.IEntityUtil;
import dev.geco.gholo.util.ImageUtil;
import dev.geco.gholo.util.LocationUtil;
import dev.geco.gholo.util.ServerConnectUtil;
import dev.geco.gholo.util.TextFormatUtil;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GHoloMain
extends JavaPlugin {
    public static final String NAME = "GHolo";
    public static final String RESOURCE_ID = "121144";
    private final int BSTATS_RESOURCE_ID = 24075;
    private static GHoloMain gHoloMain;
    private ConfigService configService;
    private MessageService messageService;
    private UpdateService updateService;
    private PermissionService permissionService;
    private TaskService taskService;
    private DataService dataService;
    private VersionService versionService;
    private HoloService holoService;
    private HoloAnimationService holoAnimationService;
    private HoloImporterService holoImporterService;
    private HoloExporterService holoExporterService;
    private InteractionService interactionService;
    private InteractionActionService interactionActionService;
    private InteractionImporterService interactionImporterService;
    private InteractionExporterService interactionExporterService;
    private IPacketHandler packetHandler;
    private TextFormatUtil textFormatUtil;
    private IEntityUtil entityUtil;
    private LocationUtil locationUtil;
    private ServerConnectUtil serverConnectUtil;
    private boolean placeholderAPILink = false;
    private boolean supportsPaperFeature = false;
    private boolean supportsTaskFeature = false;

    public static GHoloMain getInstance() {
        return gHoloMain;
    }

    public VersionService getVersionService() {
        return this.versionService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public UpdateService getUpdateService() {
        return this.updateService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public HoloService getHoloService() {
        return this.holoService;
    }

    public HoloAnimationService getHoloAnimationService() {
        return this.holoAnimationService;
    }

    public HoloImporterService getHoloImporterService() {
        return this.holoImporterService;
    }

    public HoloExporterService getHoloExporterService() {
        return this.holoExporterService;
    }

    public InteractionService getInteractionService() {
        return this.interactionService;
    }

    public InteractionActionService getInteractionActionService() {
        return this.interactionActionService;
    }

    public InteractionImporterService getInteractionImporterService() {
        return this.interactionImporterService;
    }

    public InteractionExporterService getInteractionExporterService() {
        return this.interactionExporterService;
    }

    public IPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public TextFormatUtil getTextFormatUtil() {
        return this.textFormatUtil;
    }

    public IEntityUtil getEntityUtil() {
        return this.entityUtil;
    }

    public LocationUtil getLocationUtil() {
        return this.locationUtil;
    }

    public ServerConnectUtil getServerConnectUtil() {
        return this.serverConnectUtil;
    }

    public boolean hasPlaceholderAPILink() {
        return this.placeholderAPILink;
    }

    public boolean supportsPaperFeature() {
        return this.supportsPaperFeature;
    }

    public boolean supportsTaskFeature() {
        return this.supportsTaskFeature;
    }

    public void onLoad() {
        gHoloMain = this;
        this.versionService = new VersionService(this);
        this.configService = new ConfigService(this);
        this.updateService = new UpdateService(this);
        this.permissionService = new PermissionService();
        this.taskService = new TaskService(this);
        this.dataService = new DataService(this);
        this.holoService = new HoloService(this);
        this.holoAnimationService = new HoloAnimationService(this);
        this.holoImporterService = new HoloImporterService(this);
        this.holoExporterService = new HoloExporterService();
        this.interactionService = new InteractionService(this);
        this.interactionActionService = new InteractionActionService();
        this.interactionImporterService = new InteractionImporterService(this);
        this.interactionExporterService = new InteractionExporterService();
        this.textFormatUtil = new TextFormatUtil(this);
        this.locationUtil = new LocationUtil();
        this.serverConnectUtil = new ServerConnectUtil(this);
        this.loadFeatures();
        this.messageService = this.supportsPaperFeature ? new PaperMessageService(this) : new SpigotMessageService(this);
    }

    public void onEnable() {
        if (!this.versionCheck()) {
            return;
        }
        this.packetHandler = (IPacketHandler)this.versionService.getPackageObjectInstance("event.PacketHandler", new Object[]{this});
        this.entityUtil = (IEntityUtil)this.versionService.getPackageObjectInstance("util.EntityUtil", new Object[0]);
        this.loadPluginDependencies();
        this.loadSettings((CommandSender)Bukkit.getConsoleSender());
        this.setupCommands();
        this.setupEvents();
        this.setupBStatsMetric();
        Bukkit.getPluginManager().callEvent((Event)new GHoloLoadedEvent(this));
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-enabled", new Object[0]);
        this.printPluginLinks((CommandSender)Bukkit.getConsoleSender());
        this.updateService.checkForUpdates();
    }

    public void onDisable() {
        this.unload();
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-disabled", new Object[0]);
    }

    private void loadSettings(CommandSender sender) {
        if (!this.connectDatabase(sender)) {
            return;
        }
        this.holoImporterService.registerDefaultHoloImporters();
        this.holoExporterService.registerDefaultHoloExporters();
        this.interactionActionService.registerDefaultInteractionActions();
        this.interactionImporterService.registerDefaultInteractionImporters();
        this.interactionExporterService.registerDefaultInteractionExporters();
        this.serverConnectUtil.setupChannel();
        this.holoAnimationService.loadHoloAnimations();
        this.holoService.createTables();
        this.holoService.loadHolos(null);
        this.interactionService.createTables();
        this.interactionService.loadInteractions(null);
        if (this.interactionService.hasInteractions()) {
            this.packetHandler.setupPlayerPacketHandlers();
        }
        ImageUtil.generateFolder();
    }

    public void reload(CommandSender sender) {
        GHoloReloadEvent reloadEvent = new GHoloReloadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)reloadEvent);
        if (reloadEvent.isCancelled()) {
            return;
        }
        this.unload();
        this.configService.reload();
        this.messageService.loadMessages();
        this.loadPluginDependencies();
        this.loadSettings(sender);
        this.printPluginLinks(sender);
        this.updateService.checkForUpdates();
        Bukkit.getPluginManager().callEvent((Event)new GHoloLoadedEvent(this));
    }

    private void unload() {
        this.dataService.close();
        this.serverConnectUtil.teardownChannel();
        if (this.interactionService.hasInteractions()) {
            this.packetHandler.removePlayerPacketHandlers();
        }
        this.holoService.unloadHolos(null);
        this.interactionService.unloadInteractions(null);
        this.holoAnimationService.stopHoloAnimations();
        this.interactionService.clearInteractions();
        this.holoImporterService.unregisterHoloImporters();
        this.holoExporterService.unregisterHoloExporters();
        this.interactionActionService.unregisterInteractionActions();
        this.interactionImporterService.unregisterInteractionImporters();
        this.interactionExporterService.unregisterInteractionExporters();
    }

    private void setupCommands() {
        this.getCommand("gholo").setExecutor((CommandExecutor)new GHoloCommand(this));
        this.getCommand("gholo").setTabCompleter((TabCompleter)new GHoloTabComplete(this));
        this.getCommand("gholo").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("ginteraction").setExecutor((CommandExecutor)new GInteractionCommand(this));
        this.getCommand("ginteraction").setTabCompleter((TabCompleter)new GInteractionTabComplete(this));
        this.getCommand("ginteraction").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
        this.getCommand("gholoreload").setExecutor((CommandExecutor)new GHoloReloadCommand(this));
        this.getCommand("gholoreload").setTabCompleter((TabCompleter)new EmptyTabComplete());
        this.getCommand("gholoreload").setPermissionMessage(this.messageService.getMessage("Messages.command-permission-error", new Object[0]));
    }

    private void setupEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractionEventHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEventHandler(this), (Plugin)this);
    }

    private boolean versionCheck() {
        if (this.versionService.isNewerOrVersion(new int[]{1, 19, 4}) && this.versionService.isAvailable()) {
            return true;
        }
        this.messageService.sendMessage((CommandSender)Bukkit.getConsoleSender(), "Plugin.plugin-version", "%Version%", this.versionService.getServerVersion());
        this.updateService.checkForUpdates();
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private boolean connectDatabase(CommandSender sender) {
        boolean connected = this.dataService.connect();
        if (connected) {
            return true;
        }
        this.messageService.sendMessage(sender, "Plugin.plugin-data", new Object[0]);
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private void loadFeatures() {
        try {
            Class.forName("io.papermc.paper.event.entity.EntityMoveEvent");
            this.supportsPaperFeature = true;
        }
        catch (ClassNotFoundException e) {
            this.supportsPaperFeature = false;
        }
        try {
            Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            this.supportsTaskFeature = true;
        }
        catch (ClassNotFoundException e) {
            this.supportsTaskFeature = false;
        }
    }

    private void loadPluginDependencies() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("PlaceholderAPI");
        this.placeholderAPILink = plugin != null && plugin.isEnabled();
    }

    private void printPluginLinks(CommandSender sender) {
        if (this.placeholderAPILink) {
            this.messageService.sendMessage(sender, "Plugin.plugin-link", "%Link%", Bukkit.getPluginManager().getPlugin("PlaceholderAPI").getName());
        }
    }

    private void setupBStatsMetric() {
        BStatsMetric bStatsMetric = new BStatsMetric((Plugin)this, 24075);
        bStatsMetric.addCustomChart(new BStatsMetric.SimplePie("plugin_language", () -> this.configService.L_LANG));
        bStatsMetric.addCustomChart(new BStatsMetric.AdvancedPie("minecraft_version_player_amount", () -> Map.of(this.versionService.getServerVersion(), Bukkit.getOnlinePlayers().size())));
        bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("holo_count", () -> this.holoService.getHoloCount()));
        bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("holo_row_count", () -> this.holoService.getHoloRowCount()));
        bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("interaction_count", () -> this.interactionService.getInteractionCount()));
        bStatsMetric.addCustomChart(new BStatsMetric.SingleLineChart("interaction_action_count", () -> this.interactionService.getInteractionActionCount()));
    }
}

