/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.autosellchests.scheduler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.gypopo.autosellchests.AutoSellChests;
import me.gypopo.autosellchests.files.Config;
import me.gypopo.autosellchests.files.Lang;
import me.gypopo.autosellchests.managers.UpgradeManager;
import me.gypopo.autosellchests.objects.Chest;
import me.gypopo.autosellchests.objects.ChestLocation;
import me.gypopo.autosellchests.objects.IntervalLogger;
import me.gypopo.autosellchests.scheduler.SchedulerQueue;
import me.gypopo.autosellchests.util.Logger;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.api.events.PreTransactionEvent;
import me.gypopo.economyshopgui.api.objects.SellPrices;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import me.gypopo.economyshopgui.util.Transaction;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class MainScheduler {
    private final AutoSellChests plugin;
    private final ScheduledExecutorService SCHEDULER_THREAD = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("ASC_SCHEDULER_THREAD").build());
    private final SchedulerQueue queue;
    private final IntervalLogger logger;
    private boolean running = true;
    private long currentTick;
    private long start = System.currentTimeMillis();
    private final boolean onlineOwner;
    private final boolean intervalLogging;
    private final boolean afkDetection;

    public MainScheduler(AutoSellChests plugin) {
        this.plugin = plugin;
        this.queue = new SchedulerQueue();
        this.onlineOwner = Config.get().getBoolean("online-chest-owner", true);
        this.intervalLogging = Config.get().getBoolean("interval-logs.enable");
        this.afkDetection = plugin.getAFKManager() != null;
        this.logger = Config.get().getString("interval-logs.interval", "").isEmpty() ? null : new IntervalLogger(this.SCHEDULER_THREAD);
        Logger.info("Starting sell interval...");
        this.SCHEDULER_THREAD.scheduleAtFixedRate(this::processChests, 50L, 50L, TimeUnit.MILLISECONDS);
    }

    private void processChests() {
        Chest nextChest = this.queue.peek();
        if (nextChest == null) {
            return;
        }
        while (this.running && nextChest.getNextInterval() - System.currentTimeMillis() <= 50L) {
            Chest chest = this.queue.getNextAndUpdate();
            this.plugin.runTask(chest, () -> this.sellContents(chest));
            nextChest = this.queue.peek();
        }
    }

    private void sellContents(Chest chest) {
        block10: {
            try {
                if (!chest.isLoaded()) {
                    Logger.debug("Tried to process chest " + chest.getId() + " but is in unloaded chunk, skipping...");
                    return;
                }
                OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)chest.getOwner());
                if (this.onlineOwner && !owner.isOnline()) {
                    Logger.debug("Owner from chest " + chest.getId() + " is not online, skipping...");
                    return;
                }
                if (this.afkDetection && this.plugin.getAFKManager().isAFK(owner.getUniqueId())) {
                    Logger.debug("Owner from chest " + chest.getId() + " is afk, skipping...");
                    return;
                }
                org.bukkit.block.Chest block = (org.bukkit.block.Chest)chest.getLocation().getLeftLocation().toLoc().getBlock().getState();
                if (block.getInventory().isEmpty()) {
                    return;
                }
                ItemStack[] items = block.getInventory().getContents();
                SellPrices transaction = EconomyShopGUIHook.getCutSellPrices((OfflinePlayer)owner, (ItemStack[])items, (boolean)true);
                if (!transaction.isEmpty()) {
                    Map<EcoType, Double> prices;
                    int total = transaction.getItems().values().stream().mapToInt(Integer::intValue).sum();
                    Map<EcoType, Double> map = prices = owner.isOnline() ? this.callPreTransactionEvent(transaction, total) : transaction.getPrices();
                    if (prices == null) {
                        return;
                    }
                    block.getInventory().setContents(items);
                    if (UpgradeManager.multiplierUpgrades) {
                        prices = prices.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Double)e.getValue() * chest.getMultiplier()));
                    }
                    chest.addItemsSold(total);
                    chest.addIncome(prices);
                    transaction.updateLimits();
                    prices.forEach((type, price) -> {
                        if (!this.isClaimableCurrency((EcoType)type)) {
                            EconomyShopGUIHook.getEcon((EcoType)type).depositBalance(owner, price.doubleValue());
                        } else {
                            chest.addClaimAble((EcoType)type, (Double)price);
                        }
                    });
                    this.handleLogs(chest, owner, prices, total);
                }
            }
            catch (Exception e2) {
                Logger.warn("Exception occurred while processing chest: ID: " + chest.getId() + " | Location: World '" + chest.getLocation().getLeftLocation().world + "', x" + chest.getLocation().getLeftLocation().x + ", y" + chest.getLocation().getLeftLocation().y + ", z" + chest.getLocation().getLeftLocation().z + " | TotalProfit: $" + chest.getIncome(null) + " | TotalItemsSold: " + chest.getItemsSold());
                if (e2 instanceof ClassCastException) {
                    Logger.warn("The chest at this location does not longer exist, removing chest from database...");
                    this.plugin.getManager().removeChest(new ChestLocation(chest.getLocation().getLeftLocation().toLoc()));
                }
                if (!this.plugin.debug) break block10;
                e2.printStackTrace();
            }
        }
    }

    private void handleLogs(Chest chest, OfflinePlayer owner, Map<EcoType, Double> prices, int items) {
        if (chest.isLogging() && this.plugin.getManager().soldItemsLoggingPlayer && owner.isOnline()) {
            Logger.sendPlayerMessage((Player)owner, Lang.ITEMS_SOLD_PLAYER_LOG.get().replace("%profit%", this.plugin.formatPrices(prices, Lang.ITEMS_SOLD_PLAYER_LOG.get())).replace("%chest-name%", chest.getName()).replace("%amount%", String.valueOf(items)).replace("%id%", String.valueOf(chest.getId())));
        }
        if (this.intervalLogging) {
            if (this.logger == null) {
                Logger.info(Lang.ITEMS_SOLD_CONSOLE_LOG.get().replace("%profit%", this.plugin.formatPrices(prices, Lang.ITEMS_SOLD_CONSOLE_LOG.get())).replace("%chest-name%", ChatColor.stripColor((String)chest.getName()).replace("%player%", owner.getName())).replace("%location%", "world '" + chest.getLocation().getLeftLocation().world + "', x" + chest.getLocation().getLeftLocation().x + ", y" + chest.getLocation().getLeftLocation().y + ", z" + chest.getLocation().getLeftLocation().z).replace("%amount%", String.valueOf(items)).replace("%id%", String.valueOf(chest.getId())));
            } else {
                this.logger.addContents(items, chest.getId());
            }
        }
    }

    private Map<EcoType, Double> callPreTransactionEvent(SellPrices prices, int amount) {
        PreTransactionEvent preTransactionEvent = new PreTransactionEvent(prices.getItems(), prices.getPrices(), (Player)prices.getPlayer(), amount, Transaction.Type.AUTO_SELL_CHEST);
        Bukkit.getPluginManager().callEvent((Event)preTransactionEvent);
        return preTransactionEvent.isCancelled() ? null : preTransactionEvent.getPrices();
    }

    private boolean isClaimableCurrency(EcoType ecoType) {
        return switch (ecoType.getType()) {
            case EconomyType.ITEM, EconomyType.LEVELS, EconomyType.EXP -> true;
            default -> false;
        };
    }

    public void stop() {
        this.running = false;
        this.SCHEDULER_THREAD.shutdownNow();
    }

    public void reload() {
        this.running = false;
        this.queue.reload();
        this.running = true;
    }

    public void queueChest(Chest chest) {
        this.queue.addChest(chest);
    }

    public void updateChest(Chest chest, int newIntervalID) {
        this.queue.updateChestInterval(chest, newIntervalID);
    }

    public void removeFromQueue(Chest chest) {
        this.queue.removeChest(chest);
    }

    private long getCurrentTick() {
        return System.currentTimeMillis() / 1000L * 20L;
    }
}

