/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.autosellchests.objects;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.gypopo.autosellchests.AutoSellChests;
import me.gypopo.autosellchests.files.Config;
import me.gypopo.autosellchests.files.Lang;
import me.gypopo.autosellchests.util.Logger;
import me.gypopo.autosellchests.util.TimeUtils;
import me.gypopo.economyshopgui.objects.ShopItem;
import me.gypopo.economyshopgui.util.EcoType;

public class ChestLogger {
    private final AtomicInteger count = new AtomicInteger(0);
    private final Map<ShopItem, Integer> items = new HashMap<ShopItem, Integer>();
    private final Map<EcoType, Double> prices = new HashMap<EcoType, Double>();

    public ChestLogger(AutoSellChests plugin) {
        long delay;
        try {
            String time = Config.get().getString("console-sold-items-logging.interval");
            delay = TimeUtils.getTime(time);
        }
        catch (NullPointerException | NumberFormatException | ParseException e) {
            Logger.warn("Failed to load sell logging interval from config.yml, got '" + Config.get().getString("console-sold-items-logging.interval") + "', using default of 10 minutes");
            delay = 600000L;
        }
        this.startTask(plugin, delay);
    }

    private void startTask(final AutoSellChests plugin, final long delay) {
        plugin.runTaskAsyncTimer(new Runnable(){

            @Override
            public void run() {
                Logger.info(Lang.ITEMS_SOLD_CONSOLE_INTERVAL.get().replace("%profit%", plugin.formatPrices(ChestLogger.this.prices, Lang.ITEMS_SOLD_CONSOLE_INTERVAL.get())).replace("%count%", String.valueOf(ChestLogger.this.count.get())).replace("%amount%", String.valueOf(ChestLogger.this.items.values().stream().mapToInt(Integer::intValue).sum())).replace("%interval%", TimeUtils.getReadableTime(delay)));
                if (!ChestLogger.this.items.isEmpty()) {
                    ChestLogger.this.items.clear();
                }
                if (!ChestLogger.this.prices.isEmpty()) {
                    ChestLogger.this.prices.clear();
                }
            }
        }, delay / 1000L * 20L, delay / 1000L * 20L);
    }

    public void addContents(Map<ShopItem, Integer> items, Map<EcoType, Double> prices) {
        this.count.incrementAndGet();
        items.forEach((key, value) -> this.items.put((ShopItem)key, this.items.getOrDefault(key, 0) + value));
        prices.forEach((key, value) -> this.prices.put((EcoType)key, this.prices.getOrDefault(key, 0.0) + value));
    }
}

