/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.autosellchests.objects;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.gypopo.autosellchests.AutoSellChests;
import me.gypopo.autosellchests.files.Config;
import me.gypopo.autosellchests.files.Lang;
import me.gypopo.autosellchests.managers.UpgradeManager;
import me.gypopo.autosellchests.objects.ChestLocation;
import me.gypopo.autosellchests.objects.ChestSettings;
import me.gypopo.autosellchests.util.Logger;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.util.EcoType;
import me.gypopo.economyshopgui.util.EconomyType;
import org.bukkit.entity.Player;

public class Chest {
    private final int id;
    private String displayname;
    private final ChestLocation location;
    private final UUID owner;
    private boolean logging;
    private int itemsSold;
    private final Map<EcoType, Double> income;
    private final Map<EcoType, Double> claimAble;
    private int intervalUpgrade;
    private int multiplierUpgrade;
    private boolean enableHologram;
    private long interval;
    private long nextInterval;
    private double multiplier;
    private boolean loaded;

    public Chest(int id, String location, String owner, int itemsSold, String income, String claimAble, String settings, String displayname) {
        this.id = id;
        this.location = new ChestLocation(location);
        this.owner = UUID.fromString(owner);
        this.itemsSold = itemsSold;
        this.income = this.loadPrices(income);
        this.claimAble = this.loadPrices(claimAble);
        this.logging = settings == null || settings.split("\\|")[0].equals("1");
        this.displayname = displayname == null ? Lang.formatColors(Config.get().getString("default-chest-name").replace("%id%", String.valueOf(id)), null) : displayname.replace("%id%", String.valueOf(id));
        this.intervalUpgrade = settings == null ? 0 : this.getIntervalLevel(settings);
        this.multiplierUpgrade = settings == null ? 0 : this.getMultiplierLevel(settings);
        this.enableHologram = settings == null || settings.split("\\|")[0].equals("1");
        this.interval = UpgradeManager.getIntervals()[UpgradeManager.intervalUpgrades ? this.intervalUpgrade : 0];
        this.multiplier = UpgradeManager.getMultipliers()[UpgradeManager.multiplierUpgrades ? this.multiplierUpgrade : 0];
    }

    public Chest(int id, ChestLocation location, Player owner, int itemsSold, Map<EcoType, Double> income, Map<EcoType, Double> claimAble, boolean logging, int intervalUpgrade, int multiplierUpgrade, String displayname) {
        this.id = id;
        this.location = location;
        this.owner = owner.getUniqueId();
        this.itemsSold = itemsSold;
        this.income = income;
        this.claimAble = claimAble;
        this.logging = logging;
        this.displayname = displayname.replace("%id%", String.valueOf(id));
        this.intervalUpgrade = intervalUpgrade;
        this.multiplierUpgrade = multiplierUpgrade;
        this.interval = UpgradeManager.getIntervals()[UpgradeManager.intervalUpgrades ? this.intervalUpgrade : 0];
        this.multiplier = UpgradeManager.getMultipliers()[UpgradeManager.multiplierUpgrades ? this.multiplierUpgrade : 0];
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    private int getIntervalLevel(String settings) {
        try {
            return Integer.min(Integer.parseInt(settings.split("\\|")[1]), UpgradeManager.getIntervals().length - 1);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            Logger.warn("Failed to load interval level for '" + settings + "' for chest " + this.id + ", using default...");
            return 0;
        }
    }

    private int getMultiplierLevel(String settings) {
        try {
            return Integer.min(Integer.parseInt(settings.split("\\|")[2]), UpgradeManager.getMultipliers().length - 1);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            Logger.warn("Failed to load multiplier level for '" + settings + "' for chest " + this.id + ", using default...");
            return 0;
        }
    }

    public void addItemsSold(int itemsSold) {
        this.itemsSold += itemsSold;
    }

    public void addIncome(Map<EcoType, Double> income) {
        income.forEach((key, value) -> this.income.put((EcoType)key, this.income.getOrDefault(key, 0.0) + value));
    }

    public void addClaimAble(EcoType type, Double price) {
        this.claimAble.put(type, this.claimAble.getOrDefault(type, 0.0) + price);
    }

    public void claim(EcoType claimed) {
        this.claimAble.remove(claimed);
    }

    public Map<EcoType, Double> getClaimAble() {
        return this.claimAble;
    }

    public String getClaimAble(String message) {
        return AutoSellChests.getInstance().formatPrices(this.claimAble, message);
    }

    public String getClaimAbleRaw() {
        if (this.claimAble.isEmpty()) {
            return "null";
        }
        return this.income.keySet().stream().map(econ -> (String)(econ.getCurrency() == null ? econ.getType().name() : econ.getType().name() + ":" + econ.getCurrency()) + ";;" + String.valueOf(this.income.get(econ))).collect(Collectors.joining(",,"));
    }

    public void setNextInterval(long nextInterval) {
        this.nextInterval = nextInterval;
    }

    public int getId() {
        return this.id;
    }

    public ChestLocation getLocation() {
        return this.location;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public int getItemsSold() {
        return this.itemsSold;
    }

    public ChestSettings getSettings() {
        return new ChestSettings(this.logging, this.intervalUpgrade, this.multiplierUpgrade, this.enableHologram);
    }

    public String getIncomeRaw() {
        if (this.income.isEmpty()) {
            return "null";
        }
        return this.income.keySet().stream().map(econ -> (String)(econ.getCurrency() == null ? econ.getType().name() : econ.getType().name() + ":" + econ.getCurrency()) + ";;" + String.valueOf(this.income.get(econ))).collect(Collectors.joining(",,"));
    }

    public String getIncome(String message) {
        if (this.income.isEmpty()) {
            return AutoSellChests.getInstance().formatPrices(null, 0.0, message);
        }
        return AutoSellChests.getInstance().formatPrices(this.income, message);
    }

    public long getNextInterval() {
        return this.nextInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public boolean isHologram() {
        return this.enableHologram;
    }

    public void setHologram(boolean enabled) {
        this.enableHologram = enabled;
    }

    public int getIntervalUpgrade() {
        return this.intervalUpgrade;
    }

    public void setIntervalUpgrade(int upgrade) {
        this.intervalUpgrade = upgrade;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public int getMultiplierUpgrade() {
        return this.multiplierUpgrade;
    }

    public void setMultiplierUpgrade(int upgrade) {
        this.multiplierUpgrade = upgrade;
    }

    public boolean isDoubleChest() {
        return this.location.isDoubleChest();
    }

    public String getName() {
        return this.displayname;
    }

    public void setName(String displayname) {
        this.displayname = displayname;
    }

    public String toString() {
        return "{Id: " + this.id + ", Location: " + String.valueOf(this.location) + ", Owner: " + String.valueOf(this.owner) + ", ItemsSold: " + this.itemsSold + ", Income: " + this.getIncome(null) + ", Logging: " + this.logging + ", Interval upgrade: " + this.intervalUpgrade + ", Multiplier upgrade: " + this.multiplierUpgrade + "}";
    }

    private Map<EcoType, Double> loadPrices(String income) {
        HashMap<EcoType, Double> prices = new HashMap<EcoType, Double>();
        if (income == null || income.isEmpty() || income.equals("null")) {
            return prices;
        }
        String SEPARATOR = AutoSellChests.getInstance().newPriceFormat ? ",," : ",";
        String PART_SEPARATOR = AutoSellChests.getInstance().newPriceFormat ? ";;" : ";";
        Arrays.stream(income.split(SEPARATOR)).forEach(s -> {
            try {
                EcoType econ = EconomyType.getFromString((String)s.split(PART_SEPARATOR)[0]);
                if (EconomyShopGUIHook.getEcon((EcoType)econ) == null) {
                    Logger.warn("Economy type such as " + s.split(PART_SEPARATOR)[0] + " is not enabled in EconomyShopGUI, skipping...");
                    return;
                }
                if (econ == null) {
                    Logger.warn("Failed to find economy type such as '" + s + "' for input string '" + income + "' for chest " + this.id);
                } else {
                    prices.put(econ, Double.parseDouble(s.split(PART_SEPARATOR)[1]));
                }
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
                Logger.warn("Failed to load price amount for '" + s + "' and input string '" + income + "' for chest " + this.id);
            }
        });
        return prices;
    }
}

