/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.autosellchests.events;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import libs.net.wesjd.anvilgui.AnvilGUI;
import me.gypopo.autosellchests.AutoSellChests;
import me.gypopo.autosellchests.files.Config;
import me.gypopo.autosellchests.files.Lang;
import me.gypopo.autosellchests.managers.ChestManager;
import me.gypopo.autosellchests.managers.UpgradeManager;
import me.gypopo.autosellchests.objects.ChestInventory;
import me.gypopo.autosellchests.objects.ChestLocation;
import me.gypopo.autosellchests.objects.ChestSettings;
import me.gypopo.autosellchests.objects.ChestUpgrade;
import me.gypopo.autosellchests.objects.ClaimProfitsScreen;
import me.gypopo.autosellchests.objects.InformationScreen;
import me.gypopo.autosellchests.objects.SettingsScreen;
import me.gypopo.autosellchests.objects.UpgradeScreen;
import me.gypopo.autosellchests.util.ChestConfirmation;
import me.gypopo.autosellchests.util.Logger;
import me.gypopo.autosellchests.util.SimpleParticle;
import me.gypopo.autosellchests.util.TimeUtils;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.util.EcoType;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final AutoSellChests plugin;
    private ChestConfirmation chestConfirmation;
    private final boolean compatibilityMode;
    private final Sound placeSound;
    private final Sound breakSound;
    private final Sound upgradeSound;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public PlayerListener(AutoSellChests plugin) {
        this.plugin = plugin;
        try {
            this.soundVolume = Float.parseFloat(Config.get().getString("sound-effects.volume", "1"));
            this.soundPitch = Float.parseFloat(Config.get().getString("sound-effects.pitch", "1"));
        }
        catch (NumberFormatException e) {
            Logger.warn("Failed to load sound volume settings in config.yml, should be a number");
        }
        this.placeSound = this.getSound("sound-effects.place-chest");
        this.breakSound = this.getSound("sound-effects.pickup-chest");
        this.upgradeSound = this.getSound("sound-effects.upgrade-chest");
        try {
            this.chestConfirmation = ChestConfirmation.valueOf(Config.get().getString("chest-confirmation-effect"));
        }
        catch (IllegalArgumentException e) {
            this.chestConfirmation = ChestConfirmation.BOSS_BAR;
            Logger.warn("Could not find a valid confirmation effect with name '" + Config.get().getString("chest-confirmation-effect") + "'");
        }
        this.compatibilityMode = Config.get().getBoolean("compatibility-mode");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            return;
        }
        Block clicked = e.getClickedBlock();
        if (clicked == null || clicked.getType() != Material.CHEST) {
            return;
        }
        me.gypopo.autosellchests.objects.Chest chest = this.plugin.getManager().getChestByLocation(clicked.getLocation());
        if (chest == null) {
            return;
        }
        if (!chest.getOwner().equals(e.getPlayer().getUniqueId()) && !e.getPlayer().hasPermission("autosellchests.show.all")) {
            e.getPlayer().sendMessage(Lang.NO_PERMISSIONS.get());
            return;
        }
        new InformationScreen(chest, clicked.getLocation()).open(e.getPlayer());
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent e) {
        if (!e.getBlockPlaced().getType().equals((Object)Material.CHEST)) {
            return;
        }
        if (!this.isChest(e.getItemInHand())) {
            this.checkPlacement(e.getPlayer(), e.getBlockPlaced());
            return;
        }
        if (!e.getPlayer().hasPermission("autosellchests.place")) {
            Logger.sendPlayerMessage(e.getPlayer(), Lang.NO_PERMISSIONS.get());
            e.setCancelled(true);
            return;
        }
        ChestSettings settings = this.getSettings(e.getItemInHand());
        int max = this.plugin.getManager().getMaxSell(e.getPlayer());
        if (!e.getPlayer().hasPermission("autosellchests.maxchests.override") && this.plugin.getManager().getOwnedChests(e.getPlayer()) >= max) {
            Logger.sendPlayerMessage(e.getPlayer(), Lang.MAX_SELLCHESTS_REACHED.get().replace("%maxSellChests%", String.valueOf(max)));
            e.setCancelled(true);
            return;
        }
        Location loc = e.getBlockPlaced().getLocation();
        this.plugin.runTaskLater(() -> {
            Inventory patt0$temp = ((Chest)e.getBlockPlaced().getState()).getInventory();
            if (patt0$temp instanceof DoubleChestInventory) {
                DoubleChestInventory inv = (DoubleChestInventory)patt0$temp;
                Location original = inv.getLeftSide().getLocation().equals((Object)loc) ? inv.getRightSide().getLocation() : inv.getLeftSide().getLocation();
                me.gypopo.autosellchests.objects.Chest left = this.plugin.getManager().getChestByLocation(original);
                if (left == null || !left.getOwner().equals(e.getPlayer().getUniqueId())) {
                    if (left == null) {
                        Logger.sendPlayerMessage(e.getPlayer(), Lang.CANNOT_FORM_DOUBLE_CHEST.get());
                    } else {
                        Logger.sendPlayerMessage(e.getPlayer(), Lang.CANNOT_PLACE_SELL_CHEST_HERE.get());
                    }
                    loc.add(0.5, 0.5, 0.5);
                    loc.getWorld().dropItemNaturally(loc, this.plugin.getManager().getChest(settings, 1));
                    loc.getBlock().setType(Material.AIR);
                    return;
                }
                if (!left.getSettings().equals(settings)) {
                    Logger.sendPlayerMessage(e.getPlayer(), Lang.CANNOT_FORM_DOUBLE_CHEST_MISMATCH.get());
                    loc.add(0.5, 0.5, 0.5);
                    loc.getWorld().dropItemNaturally(loc, this.plugin.getManager().getChest(settings, 1));
                    loc.getBlock().setType(Material.AIR);
                    return;
                }
                this.plugin.getManager().addChest(loc, left, settings, e.getPlayer());
            } else {
                this.plugin.getManager().addChest(loc, null, settings, e.getPlayer());
            }
            loc.add(0.5, 0.5, 0.5);
            loc.getWorld().spawnParticle(SimpleParticle.WITCH.get(), loc, 10);
            loc.getWorld().spawnParticle(SimpleParticle.DUST.get(), loc, 10, (Object)new Particle.DustOptions(Color.RED, 2.0f));
            if (this.placeSound != null) {
                loc.getWorld().playSound(loc, this.placeSound, this.soundVolume, this.soundPitch);
            }
            Logger.sendPlayerMessage(e.getPlayer(), Lang.SELLCHEST_PLACED.get().replace("%chest-name%", this.plugin.getManager().getDefaultChestName()));
            this.chestConfirmation.playEffect(e.getPlayer());
            loc.subtract(0.5, 0.5, 0.5);
        }, loc, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (e.getBlock().getType() != Material.CHEST) {
            return;
        }
        me.gypopo.autosellchests.objects.Chest chest = this.plugin.getManager().getChestByLocation(e.getBlock().getLocation());
        if (chest == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void onMenuClick(InventoryClickEvent e) {
        if (e.getClickedInventory() == null) {
            return;
        }
        InventoryHolder inventoryHolder = e.getClickedInventory().getHolder();
        if (inventoryHolder instanceof InformationScreen) {
            InformationScreen inv = (InformationScreen)inventoryHolder;
            chest = inv.getChest();
            Location loc = inv.getSelectedChest();
            if (e.getSlot() == this.plugin.getInventoryManager().getMainInv().getSlot("destroy-item")) {
                if (!e.getWhoClicked().hasPermission("autosellchests.pickup")) {
                    Logger.sendPlayerMessage((Player)e.getWhoClicked(), Lang.NO_PERMISSIONS.get());
                    e.setCancelled(true);
                    return;
                }
                if (((me.gypopo.autosellchests.objects.Chest)chest).getOwner().equals(e.getWhoClicked().getUniqueId()) || e.getWhoClicked().hasPermission("autosellchests.break")) {
                    e.getWhoClicked().closeInventory();
                    this.plugin.getManager().removeChest(new ChestLocation(loc));
                    Arrays.stream(((Chest)loc.getBlock().getState()).getBlockInventory().getContents()).forEach(item -> {
                        if (item != null && item.getType() != Material.AIR) {
                            loc.getWorld().dropItemNaturally(loc, item);
                        }
                    });
                    loc.add(0.5, 0.5, 0.5);
                    loc.getWorld().dropItemNaturally(loc, this.plugin.getManager().getChest((me.gypopo.autosellchests.objects.Chest)chest, 1));
                    if (this.plugin.version == 116) {
                        ((Chest)loc.getBlock().getState()).getBlockInventory().clear();
                    }
                    loc.getBlock().setType(Material.AIR);
                    loc.getWorld().spawnParticle(SimpleParticle.CLOUD.get(), loc, 15);
                    if (this.breakSound != null) {
                        loc.getWorld().playSound(loc, this.breakSound, this.soundVolume, this.soundPitch);
                    }
                    Logger.sendPlayerMessage((Player)e.getWhoClicked(), Lang.SELLCHEST_BROKEN.get().replace("%chest-name%", this.plugin.getManager().getDefaultChestName()));
                } else {
                    Logger.sendPlayerMessage((Player)e.getWhoClicked(), Lang.CANNOT_REMOVE_SELL_CHEST.get());
                }
            } else if (e.getSlot() == this.plugin.getInventoryManager().getMainInv().getSlot("settings-item")) {
                if (((me.gypopo.autosellchests.objects.Chest)chest).getOwner().equals(e.getWhoClicked().getUniqueId())) {
                    new SettingsScreen((me.gypopo.autosellchests.objects.Chest)chest, loc).open((Player)e.getWhoClicked());
                } else {
                    e.getWhoClicked().sendMessage(Lang.NO_PERMISSIONS.get());
                }
            } else if (e.getSlot() == this.plugin.getInventoryManager().getMainInv().getSlot("upgrade-item")) {
                if (((me.gypopo.autosellchests.objects.Chest)chest).getOwner().equals(e.getWhoClicked().getUniqueId())) {
                    new UpgradeScreen((me.gypopo.autosellchests.objects.Chest)chest, loc).open((Player)e.getWhoClicked());
                } else {
                    e.getWhoClicked().sendMessage(Lang.NO_PERMISSIONS.get());
                }
            } else if (e.getSlot() == this.plugin.getInventoryManager().getMainInv().getSlot("claimable-item")) {
                if (((me.gypopo.autosellchests.objects.Chest)chest).getOwner().equals(e.getWhoClicked().getUniqueId())) {
                    if (!((me.gypopo.autosellchests.objects.Chest)chest).getClaimAble().isEmpty()) {
                        new ClaimProfitsScreen((me.gypopo.autosellchests.objects.Chest)chest, loc).open((Player)e.getWhoClicked());
                    }
                } else {
                    e.getWhoClicked().sendMessage(Lang.NO_PERMISSIONS.get());
                }
            }
            e.setCancelled(true);
        } else {
            chest = e.getClickedInventory().getHolder();
            if (chest instanceof SettingsScreen) {
                SettingsScreen inv = (SettingsScreen)chest;
                chest = inv.getChest();
                if (e.getSlot() == this.plugin.getInventoryManager().getSettingsInv().getSlot("logging-item")) {
                    ((me.gypopo.autosellchests.objects.Chest)chest).setLogging(!((me.gypopo.autosellchests.objects.Chest)chest).isLogging());
                    inv.updateInventory((Player)e.getWhoClicked());
                } else if (e.getSlot() == this.plugin.getInventoryManager().getSettingsInv().getSlot("rename-item")) {
                    inv.update();
                    new AnvilGUI.Builder().onClick((arg_0, arg_1) -> this.lambda$onMenuClick$2((me.gypopo.autosellchests.objects.Chest)chest, inv, e, arg_0, arg_1)).text(((me.gypopo.autosellchests.objects.Chest)chest).getName()).itemLeft(new ItemStack(Material.PAPER)).title(Lang.ENTER_NAME_MENU_TITLE.get()).plugin((Plugin)this.plugin).open((Player)e.getWhoClicked());
                } else if (e.getSlot() == this.plugin.getInventoryManager().getSettingsInv().getSlot("hologram-item")) {
                    this.plugin.getHologramManager().removeHologram((me.gypopo.autosellchests.objects.Chest)chest);
                    ((me.gypopo.autosellchests.objects.Chest)chest).setHologram(!((me.gypopo.autosellchests.objects.Chest)chest).isHologram());
                    inv.updateInventory((Player)e.getWhoClicked());
                }
                e.setCancelled(true);
            } else {
                chest = e.getClickedInventory().getHolder();
                if (chest instanceof UpgradeScreen) {
                    int nextMultiplier;
                    ChestUpgrade nextUpgrade;
                    UpgradeScreen inv = (UpgradeScreen)chest;
                    p = (Player)e.getWhoClicked();
                    me.gypopo.autosellchests.objects.Chest chest = inv.getChest();
                    if (e.getSlot() == this.plugin.getInventoryManager().getUpgradeInv().getSlot("interval-upgrade-item")) {
                        int nextInterval = chest.getIntervalUpgrade() + 1;
                        ChestUpgrade nextUpgrade2 = UpgradeManager.getIntervalUpgrade(nextInterval);
                        if (nextUpgrade2 != null && nextUpgrade2.buy((Player)p, chest.isDoubleChest())) {
                            this.plugin.getManager().updateChestInterval(chest, nextInterval);
                            if (this.plugin.getHologramManager().isEnabled() && chest.isHologram()) {
                                this.plugin.getHologramManager().updateHologram(chest);
                            }
                            inv.updateInventory((Player)p);
                            Logger.sendPlayerMessage((Player)p, Lang.CHEST_INTERVAL_UPGRADED.get().replace("%upgrade-name%", nextUpgrade2.getName()).replace("%upgrade-cost%", nextUpgrade2.getPrice(chest.isDoubleChest())).replace("%interval%", TimeUtils.getReadableTime(UpgradeManager.getIntervals()[nextInterval])));
                            inv.getSelectedChest().getWorld().spawnParticle(SimpleParticle.WITCH.get(), inv.getSelectedChest(), 15);
                            if (this.upgradeSound != null) {
                                inv.getSelectedChest().getWorld().playSound(inv.getSelectedChest(), this.upgradeSound, this.soundVolume, this.soundPitch);
                            }
                        }
                    } else if (e.getSlot() == this.plugin.getInventoryManager().getUpgradeInv().getSlot("multiplier-upgrade-item") && (nextUpgrade = UpgradeManager.getMultiplierUpgrade(nextMultiplier = chest.getMultiplierUpgrade() + 1)) != null && nextUpgrade.buy((Player)p, chest.isDoubleChest())) {
                        chest.setMultiplierUpgrade(nextMultiplier);
                        chest.setMultiplier(UpgradeManager.getMultipliers()[nextMultiplier]);
                        if (this.plugin.getHologramManager().isEnabled() && chest.isHologram()) {
                            this.plugin.getHologramManager().updateHologram(chest);
                        }
                        inv.updateInventory((Player)p);
                        Logger.sendPlayerMessage((Player)p, Lang.CHEST_MULTIPLIER_UPGRADED.get().replace("%upgrade-name%", nextUpgrade.getName()).replace("%upgrade-cost%", nextUpgrade.getPrice(chest.isDoubleChest())).replace("%multiplier%", String.valueOf(UpgradeManager.getMultipliers()[nextMultiplier])));
                        inv.getSelectedChest().getWorld().spawnParticle(SimpleParticle.WITCH.get(), inv.getSelectedChest(), 15);
                        if (this.upgradeSound != null) {
                            inv.getSelectedChest().getWorld().playSound(inv.getSelectedChest(), this.upgradeSound, this.soundVolume, this.soundPitch);
                        }
                    }
                    e.setCancelled(true);
                } else {
                    p = e.getClickedInventory().getHolder();
                    if (p instanceof ClaimProfitsScreen) {
                        ClaimProfitsScreen inv = (ClaimProfitsScreen)p;
                        chest = inv.getChest();
                        if (((me.gypopo.autosellchests.objects.Chest)chest).getClaimAble().size() >= e.getRawSlot() + 1) {
                            EcoType type = new ArrayList<EcoType>(((me.gypopo.autosellchests.objects.Chest)chest).getClaimAble().keySet()).get(e.getRawSlot());
                            if (EconomyShopGUIHook.getEcon((EcoType)type).getType().equals((Object)type)) {
                                EconomyShopGUIHook.getEcon((EcoType)type).depositBalance((OfflinePlayer)((Player)e.getWhoClicked()), ((me.gypopo.autosellchests.objects.Chest)chest).getClaimAble().get(type).doubleValue());
                                ((me.gypopo.autosellchests.objects.Chest)chest).claim(type);
                                if (((me.gypopo.autosellchests.objects.Chest)chest).getClaimAble().isEmpty()) {
                                    inv.update();
                                    new InformationScreen((me.gypopo.autosellchests.objects.Chest)chest, inv.getSelectedChest()).open((Player)e.getWhoClicked());
                                } else {
                                    inv.updateInventory((Player)e.getWhoClicked());
                                }
                            } else {
                                Logger.sendPlayerMessage((Player)e.getWhoClicked(), Lang.CANNOT_CLAIM_PROFIT.get());
                            }
                        }
                        e.setCancelled(true);
                    }
                }
            }
        }
    }

    @EventHandler
    public void onMenuClose(InventoryCloseEvent e) {
        InventoryHolder inventoryHolder = e.getInventory().getHolder();
        if (!(inventoryHolder instanceof ChestInventory)) {
            return;
        }
        ChestInventory inv = (ChestInventory)inventoryHolder;
        if (inv.isUpdatingInventory()) {
            return;
        }
        this.plugin.runTaskLater(() -> {
            new InformationScreen(inv.getChest(), inv.getSelectedChest()).open((Player)e.getPlayer());
            ((Player)e.getPlayer()).updateInventory();
        }, 1L);
    }

    private Sound getSound(String sound) {
        if (!Config.get().getString(sound).isEmpty()) {
            try {
                return this.getSoundByName(Config.get().getString(sound));
            }
            catch (IllegalArgumentException | NullPointerException e) {
                Logger.warn("Failed to find a sound effect with name '" + Config.get().getString(sound) + "'");
                return this.getSoundByName(Config.get().getDefaults().getString(sound));
            }
        }
        return null;
    }

    private Sound getSoundByName(String sound) throws IllegalArgumentException {
        try {
            Class<?> clazz = Class.forName("org.bukkit.Sound");
            Method c = clazz.getDeclaredMethod("valueOf", String.class);
            c.setAccessible(true);
            return (Sound)c.invoke(null, sound);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            Logger.warn("Failed to load sound effect for " + sound);
            return null;
        }
    }

    private SoundCategory getSoundCategory(Sound sound) {
        if (sound != null) {
            try {
                SoundCategory.valueOf((String)sound.getKey().getKey().split("\\.")[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return SoundCategory.AMBIENT;
    }

    private ChestSettings getSettings(ItemStack stack) {
        if (stack.hasItemMeta()) {
            String data = (String)stack.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)AutoSellChests.getInstance(), "autosell-data"), PersistentDataType.STRING);
            if (data == null) {
                return new ChestSettings();
            }
            return new ChestSettings(data);
        }
        return new ChestSettings();
    }

    private boolean isChest(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        if (this.compatibilityMode) {
            return item.getItemMeta().getDisplayName().equals(ChestManager.chestName);
        }
        try {
            return (Integer)item.getItemMeta().getPersistentDataContainer().get(this.plugin.getKey(), PersistentDataType.INTEGER) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkPlacement(Player player, Block block) {
        Location loc = block.getLocation();
        this.plugin.runTaskLater(() -> {
            if (((Chest)block.getState()).getInventory() instanceof DoubleChestInventory) {
                Location original;
                DoubleChestInventory inv = (DoubleChestInventory)((Chest)block.getState()).getInventory();
                Location location = original = inv.getLeftSide().getLocation().equals((Object)loc) ? inv.getRightSide().getLocation() : inv.getLeftSide().getLocation();
                if (this.plugin.getManager().getChestByLocation(original) != null) {
                    Logger.sendPlayerMessage(player, Lang.CANNOT_PLACE_CHEST_AGAINST_SELL_CHEST.get());
                    block.breakNaturally();
                }
            }
        }, loc, 1L);
    }

    private /* synthetic */ List lambda$onMenuClick$2(me.gypopo.autosellchests.objects.Chest chest, SettingsScreen inv, InventoryClickEvent e, Integer i, AnvilGUI.StateSnapshot state) {
        if (!state.getText().isEmpty()) {
            chest.setName(Lang.formatColors(state.getText(), null));
        }
        this.plugin.getHologramManager().updateHologram(chest);
        inv.updateInventory((Player)e.getWhoClicked());
        return Collections.singletonList(AnvilGUI.ResponseAction.close());
    }
}

