/*
 * Decompiled with CFR 0.152.
 */
package me.gypopo.autosellchests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.gypopo.autosellchests.commands.SellChestCommand;
import me.gypopo.autosellchests.database.SQLite;
import me.gypopo.autosellchests.events.BlockListener;
import me.gypopo.autosellchests.events.ChunkListener;
import me.gypopo.autosellchests.events.PlayerListener;
import me.gypopo.autosellchests.files.Config;
import me.gypopo.autosellchests.files.Lang;
import me.gypopo.autosellchests.managers.AFKDetection.AFKDetectionCMI;
import me.gypopo.autosellchests.managers.AFKDetection.AFKDetectionEssentials;
import me.gypopo.autosellchests.managers.AFKManager;
import me.gypopo.autosellchests.managers.ChestManager;
import me.gypopo.autosellchests.managers.HologramManager;
import me.gypopo.autosellchests.managers.InventoryManager;
import me.gypopo.autosellchests.managers.UpgradeManager;
import me.gypopo.autosellchests.metrics.Metrics;
import me.gypopo.autosellchests.objects.Chest;
import me.gypopo.autosellchests.util.ConfigUtil;
import me.gypopo.autosellchests.util.Logger;
import me.gypopo.autosellchests.util.TimeUtils;
import me.gypopo.autosellchests.util.Version;
import me.gypopo.autosellchests.util.scheduler.ServerScheduler;
import me.gypopo.autosellchests.util.scheduler.Task;
import me.gypopo.autosellchests.util.scheduler.schedulers.BukkitScheduler;
import me.gypopo.autosellchests.util.scheduler.schedulers.FoliaScheduler;
import me.gypopo.economyshopgui.api.EconomyShopGUIHook;
import me.gypopo.economyshopgui.api.events.ShopItemsLoadEvent;
import me.gypopo.economyshopgui.util.EcoType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public final class AutoSellChests
extends JavaPlugin
implements Listener {
    public final int version = this.getVersion();
    private static AutoSellChests instance;
    private final SQLite database = new SQLite(this);
    private final TimeUtils timeUtils = new TimeUtils();
    private final NamespacedKey key = new NamespacedKey((Plugin)this, "autosell");
    private final ServerScheduler scheduler = this.getScheduler();
    private ChestManager manager = new ChestManager(this);
    private InventoryManager inventoryManager;
    private HologramManager hologramManager;
    private UpgradeManager upgradeManager;
    private AFKManager afkManager;
    private boolean premium;
    private boolean ready;
    public boolean newPriceFormat = true;
    public boolean supportsNewAPI;
    public boolean debug;

    public static AutoSellChests getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (Bukkit.getServer().getPluginManager().getPlugin("EconomyShopGUI") != null) {
            this.getLogger().info("Found EconomyShopGUI, enabling...");
            if (!this.validateAPI()) {
                return;
            }
            this.premium = false;
            Version version = new Version(Bukkit.getServer().getPluginManager().getPlugin("EconomyShopGUI").getDescription().getVersion());
            this.supportsNewAPI = version.isGreater(new Version("6.2.5"));
            if (version.isSmaller(new Version("5.5.1"))) {
                this.getLogger().warning("This plugin requires a newer version of EconomyShopGUI, please download version v5.5.1 or later, found v" + version.getVer() + ", disabling...");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else if (Bukkit.getServer().getPluginManager().getPlugin("EconomyShopGUI-Premium") != null) {
            this.getLogger().info("Found EconomyShopGUI Premium, enabling...");
            if (!this.validateAPI()) {
                return;
            }
            this.premium = true;
            Version version = new Version(Bukkit.getServer().getPluginManager().getPlugin("EconomyShopGUI-Premium").getDescription().getVersion());
            this.supportsNewAPI = version.isGreater(new Version("5.5.3"));
            if (version.isSmaller(new Version("4.10.2"))) {
                this.getLogger().warning("This plugin requires a newer version of EconomyShopGUI Premium, please download version v4.10.2 or later, found v" + version.getVer() + ", disabling...");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else {
            this.getLogger().warning("Could not find EconomyShopGUI(Premium), disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.isSpigotServer()) {
            this.getLogger().warning("It seems like you are using a server type which does not support spigot, please install a supported server type like Paper which can be downloaded from here: https://papermc.io/");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        Metrics metrics = new Metrics(this, 15605);
        metrics.addCustomChart(new Metrics.SimplePie("esgui_ver", () -> this.premium ? "EconomyShopGUI-Premium" : "EconomyShopGUI"));
        if (this.supportsNewAPI) {
            this.getLogger().info("Using new API methods for improved performance...");
        }
        Config.setup();
        Lang.reload();
        new Logger(this);
        ConfigUtil.updateConfig(this);
        if (!this.database.connect()) {
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.debug = Config.get().getBoolean("debug");
        this.runTaskLater(() -> {
            if (!this.ready) {
                if (!this.isPluginEnabled()) {
                    this.getLogger().warning("Found EconomyShopGUI in a disabled state, please make sure it is enabled and up to date, disabling the plugin...");
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
                this.onShopItemsLoadEvent(new ShopItemsLoadEvent());
            }
        }, 120L);
    }

    public void onDisable() {
        if (this.manager != null) {
            this.manager.disable();
        }
        if (this.database != null) {
            this.database.closeConnection();
        }
    }

    private void registerCommands() {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            commandMap.register("autosellchests", (Command)new SellChestCommand(this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.warn("Exception occurred registering commands.");
            e.printStackTrace();
        }
    }

    public TimeUtils getTimeUtils() {
        return this.timeUtils;
    }

    public SQLite getDatabase() {
        return this.database;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public ChestManager getManager() {
        return this.manager;
    }

    public AFKManager getAFKManager() {
        return this.afkManager;
    }

    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public void reloadManager() {
        this.manager.disable();
        if (Config.get().getBoolean("afk-prevention", false)) {
            this.afkManager = this.getAfkManager();
        }
        this.upgradeManager.reload();
        this.inventoryManager.reload();
        this.manager.load();
    }

    public Task runTaskTimer(Runnable runnable, long delay, long period) {
        return this.scheduler.runTaskTimer(this, runnable, delay, period);
    }

    public void runTaskLater(Runnable runnable, long delay) {
        this.scheduler.runTaskLater(this, runnable, delay);
    }

    public void runTaskLater(Runnable runnable, Location loc, long delay) {
        this.scheduler.runTaskLater(this, loc, runnable, delay);
    }

    public void runTask(Runnable runnable) {
        this.scheduler.runTask(this, runnable);
    }

    public void runTask(Chest chest, Runnable runnable) {
        this.scheduler.runTask(this, chest, runnable);
    }

    public void runTaskAsync(Runnable runnable) {
        this.scheduler.runTaskAsync(this, runnable);
    }

    public Task runTaskAsyncTimer(Runnable runnable, long delay, long period) {
        return this.scheduler.runTaskAsyncTimer(this, runnable, delay, period);
    }

    public void callEvent(Event event) {
        this.getServer().getPluginManager().callEvent(event);
    }

    private Integer getVersion() {
        String version = Bukkit.getBukkitVersion().split("-")[0];
        if (StringUtils.countMatches((String)version, (String)".") == 2) {
            return Integer.valueOf(version.substring(0, version.length() - 2).replace(".", ""));
        }
        return Integer.valueOf(version.replace(".", ""));
    }

    public YamlConfiguration loadConfiguration(File file, String fileName) {
        Validate.notNull((Object)file, (String)("Cannot load " + fileName + " config file."));
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            return config;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            this.getLogger().warning("Cannot read " + fileName + " config because it is mis-configured, use a online Yaml parser with the error underneath here to find out the cause of the problem and to solve it.");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isPluginEnabled() {
        return this.getServer().getPluginManager().getPlugin("EconomyShopGUI" + (this.premium ? "-Premium" : "")).isEnabled();
    }

    @EventHandler
    public void onShopItemsLoadEvent(ShopItemsLoadEvent e) {
        this.runTaskLater(() -> {
            this.ready = true;
            if (Config.get().getBoolean("afk-prevention", false)) {
                this.afkManager = this.getAfkManager();
            }
            this.inventoryManager = new InventoryManager();
            this.hologramManager = new HologramManager(this);
            this.upgradeManager = new UpgradeManager(this);
            this.manager.load();
            ShopItemsLoadEvent.getHandlerList().unregister((Listener)this);
        }, 5L);
    }

    private boolean validateAPI() {
        try {
            Class.forName("me.gypopo.economyshopgui.api.EconomyShopGUIHook");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().warning("Failed to integrate with EconomyShopGUI, disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return false;
        }
    }

    private boolean isSpigotServer() {
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String formatPrice(EcoType econ, double price) {
        if (econ != null && (econ.getType().name().equalsIgnoreCase("ITEM") || econ.getType().name().equalsIgnoreCase("LEVELS") || econ.getType().name().equalsIgnoreCase("PLAYER_POINTS"))) {
            price = Math.round(price);
        }
        if (price == Math.floor(price)) {
            return (price == 1.0 ? EconomyShopGUIHook.getEcon((EcoType)econ).getSingular() : EconomyShopGUIHook.getEcon((EcoType)econ).getPlural()).replace("%price%", String.format("%,.0f", price).replace("\u202f", ".").replace("\u00a0", "."));
        }
        return (price == 1.0 ? EconomyShopGUIHook.getEcon((EcoType)econ).getSingular() : EconomyShopGUIHook.getEcon((EcoType)econ).getPlural()).replace("%price%", String.format("%,.2f", price).replace("\u202f", ".").replace("\u00a0", "."));
    }

    public String formatPrices(EcoType type, Double price, String message) {
        String color = message != null && message.contains("%profit%") ? ChatColor.getLastColors((String)message.split("%profit%")[0]) : null;
        return this.formatPrice(type, price) + "\u00a7r" + (color == null ? "" : color);
    }

    public String replaceColoredPlaceholder(String message, String placeholder, String replacement) {
        String c = ChatColor.getLastColors((String)message.split(placeholder)[0]);
        return message.replace(placeholder, replacement + "\u00a7r" + c);
    }

    public String formatPrices(Map<EcoType, Double> prices, String message) {
        StringBuilder builder = new StringBuilder();
        String color = message != null && message.contains("%profit%") ? ChatColor.getLastColors((String)message.split("%profit%")[0]) : null;
        int i = 0;
        for (Map.Entry<EcoType, Double> entry : prices.entrySet()) {
            builder.append(this.formatPrice(entry.getKey(), entry.getValue()));
            if (color != null) {
                builder.append("\u00a7r").append(color);
            }
            if (i != prices.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }

    public static List<String> splitLongString(String string) {
        ArrayList<String> list = new ArrayList<String>();
        String[] words = string.split(" ");
        int e = 0;
        StringBuilder line = new StringBuilder();
        for (String word : words) {
            if ((e += ChatColor.stripColor((String)word).length() + 1) >= 42) {
                list.add(line.toString());
                e = word.length();
                line = new StringBuilder();
                line.append(ChatColor.getLastColors((String)((String)list.get(list.size() - 1))));
                line.append(word);
                continue;
            }
            if (line.length() != 0) {
                line.append(" ");
            }
            line.append(word);
        }
        list.addAll(Arrays.asList(line.toString().split("\n")));
        return list;
    }

    private AFKManager getAfkManager() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("Essentials") != null) {
            return new AFKDetectionEssentials(this);
        }
        if (pm.getPlugin("CMI") != null) {
            return new AFKDetectionCMI(this);
        }
        return null;
    }

    private ServerScheduler getScheduler() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return new FoliaScheduler(this);
        }
        catch (ClassNotFoundException e) {
            return new BukkitScheduler(this);
        }
    }
}

