/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.Paxel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.Tag;

public class ToolMapper {
    public static final int AXE_INDEX = 0;
    public static final int PICKAXE_INDEX = 1;
    public static final int SHOVEL_INDEX = 2;
    private final Paxel plugin;
    private final HashMap<String, Material[]> toolsMap;
    private final HashMap<Material, String> tierMap;
    private final HashMap<String, Double> speedMap;
    private final HashMap<String, String> incorrectTagMap;

    public ToolMapper(Paxel plugin) {
        this.plugin = plugin;
        this.toolsMap = new HashMap();
        this.tierMap = new HashMap();
        this.speedMap = new HashMap();
        this.incorrectTagMap = new HashMap();
        this.initializeToolCategory((Tag<Material>)Tag.ITEMS_AXES, 0);
        this.initializeToolCategory((Tag<Material>)Tag.ITEMS_PICKAXES, 1);
        this.initializeToolCategory((Tag<Material>)Tag.ITEMS_SHOVELS, 2);
        this.deleteMarkedTiers(this.initializeSpeedMap(), "Base Mining Speed");
        this.deleteMarkedTiers(this.initializeIncorrectTagMap(), "Incorrect Tag");
    }

    public Material[] getToolSet(String tier) {
        return this.toolsMap.containsKey(tier) ? this.toolsMap.get(tier) : null;
    }

    public Material[] getToolSet(Material material) {
        String toolTier = this.getToolTier(material);
        return toolTier != null ? this.getToolSet(toolTier) : null;
    }

    public Double getSpeed(String tier) {
        return this.speedMap.getOrDefault(tier, null);
    }

    public String getIncorrectTag(String tier) {
        return this.incorrectTagMap.getOrDefault(tier, null);
    }

    public String getToolTier(Material material) {
        return this.tierMap.containsKey(material) ? this.tierMap.get(material) : null;
    }

    public Collection<String> getAllTiers() {
        return this.toolsMap.keySet();
    }

    public boolean isTier(String tier) {
        return this.toolsMap.containsKey(tier);
    }

    public boolean isTool(Material material) {
        return this.tierMap.containsKey(material);
    }

    private void initializeToolCategory(Tag<Material> toolCategory, int toolSetIndex) {
        for (Material type : toolCategory.getValues()) {
            String[] typeNameSplitted = type.name().split("_");
            if (typeNameSplitted == null || typeNameSplitted.length == 0) {
                this.plugin.getLogger().warning("ToolMapper received unexpected value from item " + type.name());
                continue;
            }
            String tierName = typeNameSplitted[0];
            if (!this.toolsMap.containsKey(tierName)) {
                this.toolsMap.put(tierName, new Material[3]);
            }
            this.toolsMap.get((Object)tierName)[toolSetIndex] = type;
            this.tierMap.put(type, tierName);
        }
    }

    private ArrayList<String> initializeSpeedMap() {
        ArrayList<String> markedForDeletion = new ArrayList<String>();
        for (String tier : this.toolsMap.keySet()) {
            String configPath = "base_mining_speeds." + tier.toLowerCase();
            if (!this.plugin.getConfig().contains(configPath)) {
                markedForDeletion.add(tier);
                continue;
            }
            double speed = this.plugin.getConfig().getDouble(configPath);
            this.speedMap.put(tier, speed);
        }
        return markedForDeletion;
    }

    private ArrayList<String> initializeIncorrectTagMap() {
        ArrayList<String> markedForDeletion = new ArrayList<String>();
        for (String tier : this.toolsMap.keySet()) {
            String configPath = "incorrect_tag." + tier.toLowerCase();
            if (!this.plugin.getConfig().contains(configPath)) {
                markedForDeletion.add(tier);
                continue;
            }
            this.incorrectTagMap.put(tier, this.plugin.getConfig().getString(configPath));
        }
        return markedForDeletion;
    }

    private void deleteMarkedTiers(ArrayList<String> markedForDeletion, String setting) {
        for (String tier : markedForDeletion) {
            this.plugin.getLogger().severe("Setting \"" + setting + "\" for tier \"" + tier.toLowerCase() + "\" is not defined in the config! Crafting and obtaining paxels of this tier are disabled.");
            this.toolsMap.remove(tier);
            this.tierMap.entrySet().removeIf(entry -> tier.equals(entry.getValue()));
        }
    }
}

