/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.Paxel;
import io.github.poorgrammerdev.paxel.ToolMapper;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class RepairingManager
implements Listener {
    private final Paxel plugin;
    private final ToolMapper toolMapper;

    public RepairingManager(Paxel plugin, ToolMapper toolMapper) {
        this.plugin = plugin;
        this.toolMapper = toolMapper;
    }

    @EventHandler
    public void craftRepairing(PrepareItemCraftEvent event) {
        if (!event.isRepair()) {
            return;
        }
        ArrayList<ItemStack> tools = new ArrayList<ItemStack>();
        for (ItemStack ingredient : event.getInventory().getMatrix()) {
            if (ingredient == null) continue;
            tools.add(ingredient);
        }
        if (tools.size() != 2) {
            return;
        }
        boolean isPaxel1 = this.plugin.isPaxel((ItemStack)tools.get(0));
        boolean isPaxel2 = this.plugin.isPaxel((ItemStack)tools.get(1));
        if (isPaxel1 && isPaxel2) {
            ItemStack newPaxel = this.paxelize(event.getInventory().getResult());
            event.getInventory().setResult(newPaxel);
        } else if (isPaxel1 ^ isPaxel2) {
            event.getInventory().setResult(null);
        }
    }

    @EventHandler
    public void grindstoneRepairing(PrepareGrindstoneEvent event) {
        ItemStack[] ingredients = event.getInventory().getStorageContents();
        if (ingredients.length != 2) {
            return;
        }
        if (ingredients[0] == null ^ ingredients[1] == null) {
            return;
        }
        boolean isPaxel1 = this.plugin.isPaxel(ingredients[0]);
        boolean isPaxel2 = this.plugin.isPaxel(ingredients[1]);
        if (isPaxel1 && isPaxel2) {
            ItemStack newPaxel = this.paxelize(event.getResult());
            event.setResult(newPaxel);
        } else if (isPaxel1 ^ isPaxel2) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void anvilRepairing(PrepareAnvilEvent event) {
        ItemStack[] items = event.getInventory().getStorageContents();
        if (items.length != 2) {
            return;
        }
        if (items[0] == null || items[1] == null) {
            return;
        }
        if (!this.toolMapper.isTool(items[0].getType()) || !this.toolMapper.isTool(items[1].getType())) {
            return;
        }
        if (this.plugin.isPaxel(items[0]) ^ this.plugin.isPaxel(items[1])) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void smithingTable(PrepareSmithingEvent event) {
        ItemStack result = event.getResult();
        if (result == null || result.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = result.getItemMeta();
        if (meta == null || !this.plugin.isPaxel(result)) {
            return;
        }
        String resultTier = this.toolMapper.getToolTier(result.getType());
        ItemStack temp = this.plugin.createPaxel(resultTier);
        ItemMeta tempMeta = temp.getItemMeta();
        if (tempMeta == null || !tempMeta.hasTool() || tempMeta.getTool() == null) {
            throw new IllegalStateException("ToolComponent is missing from temp item!");
        }
        meta.setTool(tempMeta.getTool());
        String newName = this.plugin.getPaxelName(resultTier);
        meta.setItemName(newName);
        if (this.plugin.getConfig().getBoolean("write_description", true)) {
            meta.setLore(Arrays.asList(ChatColor.GRAY + newName));
        }
        result.setItemMeta(meta);
        event.setResult(result);
    }

    private ItemStack paxelize(ItemStack result) {
        if (result != null && result.getItemMeta() instanceof Damageable) {
            ItemStack newPaxel;
            Damageable meta = (Damageable)result.getItemMeta();
            String tier = this.toolMapper.getToolTier(result.getType());
            if (tier != null && (newPaxel = this.plugin.createPaxel(tier)) != null && newPaxel.getItemMeta() instanceof Damageable) {
                Damageable paxelMeta = (Damageable)newPaxel.getItemMeta();
                paxelMeta.setDamage(meta.getDamage());
                newPaxel.setItemMeta((ItemMeta)paxelMeta);
                return newPaxel;
            }
        }
        return null;
    }
}

