/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.ToolMapper;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;

public class RecipeManager
implements Listener {
    private final ToolMapper toolMapper;
    private final HashMap<String, NamespacedKey> paxelRecipeMap;
    private final HashMap<NamespacedKey, Material> toolKeys;

    public RecipeManager(ToolMapper toolMapper, HashMap<String, NamespacedKey> paxelRecipeMap) {
        this.toolMapper = toolMapper;
        this.paxelRecipeMap = paxelRecipeMap;
        this.toolKeys = new HashMap();
        Tag.ITEMS_AXES.getValues().forEach(tool -> this.toolKeys.put(tool.getKey(), (Material)tool));
        Tag.ITEMS_PICKAXES.getValues().forEach(tool -> this.toolKeys.put(tool.getKey(), (Material)tool));
        Tag.ITEMS_SHOVELS.getValues().forEach(tool -> this.toolKeys.put(tool.getKey(), (Material)tool));
    }

    @EventHandler
    public void unlockToolRecipe(PlayerRecipeDiscoverEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.toolKeys.containsKey(event.getRecipe())) {
            return;
        }
        String tier = this.toolMapper.getToolTier(this.toolKeys.get(event.getRecipe()));
        if (tier == null || !this.paxelRecipeMap.containsKey(tier)) {
            return;
        }
        event.getPlayer().discoverRecipe(this.paxelRecipeMap.get(tier));
    }
}

