/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.Paxel;
import io.github.poorgrammerdev.paxel.ToolMapper;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PaxelSpecialActions
implements Listener {
    private final Paxel plugin;
    private final ToolMapper toolMapper;

    public PaxelSpecialActions(Paxel plugin, ToolMapper toolMapper) {
        this.plugin = plugin;
        this.toolMapper = toolMapper;
    }

    @EventHandler(ignoreCancelled=true)
    public void paxelInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        final ItemStack tool = event.getItem();
        if (!this.plugin.isPaxel(tool)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (Tag.LOGS.isTagged((Keyed)block.getType()) && !Tag.ITEMS_AXES.isTagged((Keyed)tool.getType())) {
            this.swapPaxelType(tool, 0);
        } else if (Tag.DIRT.isTagged((Keyed)block.getType()) && !Tag.ITEMS_SHOVELS.isTagged((Keyed)tool.getType())) {
            this.swapPaxelType(tool, 2);
        } else {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                PaxelSpecialActions.this.swapPaxelType(tool, 1);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }

    private void swapPaxelType(ItemStack tool, int toolSwapIndex) {
        String tier = this.toolMapper.getToolTier(tool.getType());
        if (tier == null) {
            return;
        }
        Material[] toolSet = this.toolMapper.getToolSet(tier);
        if (toolSet == null || toolSet.length <= toolSwapIndex) {
            return;
        }
        tool.setType(toolSet[toolSwapIndex]);
    }
}

