/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.CraftingManager;
import io.github.poorgrammerdev.paxel.ExternalItemManager;
import io.github.poorgrammerdev.paxel.GiveCommand;
import io.github.poorgrammerdev.paxel.PaxelSpecialActions;
import io.github.poorgrammerdev.paxel.RecipeManager;
import io.github.poorgrammerdev.paxel.RepairingManager;
import io.github.poorgrammerdev.paxel.ToolMapper;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.ToolComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Paxel
extends JavaPlugin {
    private final NamespacedKey paxelKey = new NamespacedKey((Plugin)this, "is_paxel");
    private final ToolMapper toolMapper = new ToolMapper(this);

    public void onEnable() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        ExternalItemManager externalItemManager = new ExternalItemManager(this);
        CraftingManager craftingManager = new CraftingManager(this, this.toolMapper, externalItemManager);
        HashMap<String, NamespacedKey> paxelRecipeMap = craftingManager.registerAllRecipes();
        this.getServer().getPluginManager().registerEvents((Listener)craftingManager, (Plugin)this);
        RepairingManager repairingManager = new RepairingManager(this, this.toolMapper);
        this.getServer().getPluginManager().registerEvents((Listener)repairingManager, (Plugin)this);
        PaxelSpecialActions paxelSpecialActions = new PaxelSpecialActions(this, this.toolMapper);
        this.getServer().getPluginManager().registerEvents((Listener)paxelSpecialActions, (Plugin)this);
        RecipeManager recipeManager = new RecipeManager(this.toolMapper, paxelRecipeMap);
        this.getServer().getPluginManager().registerEvents((Listener)recipeManager, (Plugin)this);
        GiveCommand giveCommand = new GiveCommand(this, this.toolMapper);
        this.getCommand("givepaxel").setExecutor((CommandExecutor)giveCommand);
        this.getCommand("givepaxel").setTabCompleter((TabCompleter)giveCommand);
    }

    public NamespacedKey getPaxelKey() {
        return this.paxelKey;
    }

    public boolean isPaxel(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.getPaxelKey(), PersistentDataType.BOOLEAN) && (Boolean)meta.getPersistentDataContainer().get(this.getPaxelKey(), PersistentDataType.BOOLEAN) != false;
    }

    public ItemStack createPaxel(String tier) {
        Material[] toolSet = this.toolMapper.getToolSet(tier);
        if (toolSet == null) {
            return null;
        }
        Double speedObj = this.toolMapper.getSpeed(tier);
        if (speedObj == null) {
            return null;
        }
        String incorrectTagStr = this.toolMapper.getIncorrectTag(tier);
        if (incorrectTagStr == null) {
            return null;
        }
        Tag incorrectTag = this.getServer().getTag("blocks", NamespacedKey.minecraft((String)incorrectTagStr), Material.class);
        if (incorrectTag == null) {
            this.getLogger().warning("Invalid tag \"" + incorrectTagStr + "\" for tier \"" + tier + "\"!");
            return null;
        }
        Float speed = Float.valueOf((float)speedObj.doubleValue());
        String name = this.getPaxelName(tier);
        ItemStack paxel = new ItemStack(toolSet[1]);
        ItemMeta meta = paxel.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("ItemMeta cannot be null!");
        }
        meta.setCustomModelData(Integer.valueOf(this.getConfig().getInt("custom_model_data", 100)));
        meta.setItemName(name);
        meta.getPersistentDataContainer().set(this.getPaxelKey(), PersistentDataType.BOOLEAN, (Object)true);
        ToolComponent tool = meta.getTool();
        tool.addRule(incorrectTag, speed, Boolean.valueOf(false));
        tool.addRule(Tag.MINEABLE_AXE, speed, Boolean.valueOf(true));
        tool.addRule(Tag.MINEABLE_PICKAXE, speed, Boolean.valueOf(true));
        tool.addRule(Tag.MINEABLE_SHOVEL, speed, Boolean.valueOf(true));
        tool.setDamagePerBlock(1);
        meta.setTool(tool);
        if (this.getConfig().getBoolean("write_description", true)) {
            meta.setLore(Arrays.asList(ChatColor.GRAY + name));
        }
        paxel.setItemMeta(meta);
        return paxel;
    }

    public String getPaxelName(String tier) {
        return tier.charAt(0) + tier.substring(1).toLowerCase() + " Paxel";
    }
}

