/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.Paxel;
import io.github.poorgrammerdev.paxel.ToolMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permission;

public class GiveCommand
implements CommandExecutor,
TabCompleter {
    private final Paxel plugin;
    private final ToolMapper toolMapper;

    public GiveCommand(Paxel plugin, ToolMapper toolMapper) {
        this.plugin = plugin;
        this.toolMapper = toolMapper;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List entities;
        if (!command.getName().equalsIgnoreCase("givepaxel")) {
            return false;
        }
        if (!sender.hasPermission(new Permission("paxel.givepaxel"))) {
            return false;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Too few arguments.");
            return false;
        }
        String paxelType = args[1].toUpperCase();
        if (!this.toolMapper.isTier(paxelType)) {
            sender.sendMessage(ChatColor.RED + "Invalid paxel type.");
            return false;
        }
        try {
            entities = this.plugin.getServer().selectEntities(sender, args[0]);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Invalid selector.");
            return false;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            players.add((Player)entity);
        }
        if (players.size() == 0) {
            sender.sendMessage(ChatColor.RED + "Selector returned no players.");
            return false;
        }
        ItemStack paxel = this.plugin.createPaxel(paxelType);
        if (args.length >= 3) {
            int count;
            try {
                count = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid quantity, expected a number.");
                return false;
            }
            if (count <= 0 || count > 64) {
                sender.sendMessage(ChatColor.RED + "Invalid quantity, expected a number between 1 and 64.");
                return false;
            }
            paxel.setAmount(count);
        }
        if (args.length >= 4) {
            int damage;
            if (!(paxel.getItemMeta() instanceof Damageable)) {
                sender.sendMessage(ChatColor.RED + "Internal Plugin Error.");
                return false;
            }
            Damageable meta = (Damageable)paxel.getItemMeta();
            try {
                damage = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(ChatColor.RED + "Invalid damage, expected a number.");
                return false;
            }
            meta.setDamage(damage);
            paxel.setItemMeta((ItemMeta)meta);
        }
        for (Player player : players) {
            player.getInventory().addItem(new ItemStack[]{paxel});
            sender.sendMessage("Gave " + paxel.getAmount() + " [" + this.plugin.getPaxelName(paxelType) + "] to " + player.getDisplayName());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("givepaxel")) {
            return null;
        }
        if (!sender.hasPermission(new Permission("paxel.givepaxel"))) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                ret.addAll(this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toUpperCase().startsWith(args[0].toUpperCase())).collect(Collectors.toList()));
                ret.addAll(Arrays.asList("@a", "@p", "@r", "@s").stream().filter(selector -> selector.toUpperCase().startsWith(args[0].toUpperCase())).collect(Collectors.toList()));
                break;
            }
            case 2: {
                ret.addAll(this.toolMapper.getAllTiers().stream().filter(tier -> tier.toUpperCase().startsWith(args[1].toUpperCase())).map(String::toLowerCase).collect(Collectors.toList()));
                break;
            }
        }
        return ret;
    }
}

