/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.Paxel;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ExternalItemManager {
    private final List<NamespacedKey> externalKeys;

    public ExternalItemManager(Paxel plugin) {
        this.externalKeys = plugin.getConfig().getStringList("external_tool_keys").stream().map(str -> NamespacedKey.fromString((String)str)).collect(Collectors.toList());
    }

    public boolean isExternalItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        for (NamespacedKey key : this.externalKeys) {
            if (!meta.getPersistentDataContainer().has(key)) continue;
            return true;
        }
        return false;
    }
}

