/*
 * Decompiled with CFR 0.152.
 */
package io.github.poorgrammerdev.paxel;

import io.github.poorgrammerdev.paxel.ExternalItemManager;
import io.github.poorgrammerdev.paxel.Paxel;
import io.github.poorgrammerdev.paxel.ToolMapper;
import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.recipe.CraftingBookCategory;
import org.bukkit.plugin.Plugin;

public class CraftingManager
implements Listener {
    private final Paxel plugin;
    private final ToolMapper toolMapper;
    private final ExternalItemManager externalItemManager;

    public CraftingManager(Paxel plugin, ToolMapper toolMapper, ExternalItemManager externalItemManager) {
        this.plugin = plugin;
        this.toolMapper = toolMapper;
        this.externalItemManager = externalItemManager;
    }

    public HashMap<String, NamespacedKey> registerAllRecipes() {
        HashMap<String, NamespacedKey> ret = new HashMap<String, NamespacedKey>();
        for (String tier : this.toolMapper.getAllTiers()) {
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, tier.toLowerCase() + "_paxel");
            Material[] toolSet = this.toolMapper.getToolSet(tier);
            if (toolSet == null || toolSet.length == 0) {
                this.plugin.getLogger().warning("Crafting Manager received invalid tool set for mineral type " + tier);
                continue;
            }
            ItemStack paxel = this.plugin.createPaxel(tier);
            ShapedRecipe recipe = new ShapedRecipe(key, paxel);
            recipe.shape(new String[]{"@#*", " | ", " | "});
            recipe.setIngredient('|', Material.STICK);
            recipe.setIngredient('@', toolSet[0]);
            recipe.setIngredient('#', toolSet[1]);
            recipe.setIngredient('*', toolSet[2]);
            recipe.setCategory(CraftingBookCategory.EQUIPMENT);
            this.plugin.getServer().addRecipe((Recipe)recipe);
            ret.put(tier, key);
        }
        return ret;
    }

    @EventHandler
    public void handleDurability(PrepareItemCraftEvent event) {
        if (event.isRepair()) {
            return;
        }
        ItemStack result = event.getInventory().getResult();
        if (!this.plugin.isPaxel(result)) {
            return;
        }
        if (!(result.getItemMeta() instanceof Damageable)) {
            return;
        }
        Damageable meta = (Damageable)result.getItemMeta();
        int[] damages = new int[3];
        ItemStack[] matrix = event.getInventory().getMatrix();
        for (int i = 0; i < 3 && i < matrix.length; ++i) {
            if (matrix[i] == null || !(matrix[i].getItemMeta() instanceof Damageable)) continue;
            Damageable damageable = (Damageable)matrix[i].getItemMeta();
            damages[i] = damageable.getDamage();
        }
        int averageDamage = (damages[0] + damages[1] + damages[2]) / 3;
        meta.setDamage(averageDamage);
        result.setItemMeta((ItemMeta)meta);
    }

    @EventHandler
    public void preventPaxelRecrafting(PrepareItemCraftEvent event) {
        if (event.isRepair()) {
            return;
        }
        ItemStack result = event.getInventory().getResult();
        if (!this.plugin.isPaxel(result)) {
            return;
        }
        ItemStack[] matrix = event.getInventory().getMatrix();
        for (int i = 0; i < matrix.length; ++i) {
            if (!this.plugin.isPaxel(matrix[i]) && !this.externalItemManager.isExternalItem(matrix[i])) continue;
            event.getInventory().setResult(null);
            return;
        }
    }
}

