/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.files;

import de.tofastforyou.logcaptcha.utils.ErrorSaver;
import de.tofastforyou.logcaptcha.utils.ErrorTypes;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TemporaryFile {
    private static final String FAILS_SUFFIX = ".Fails";
    private static final String ACTION_SUFFIX = ".Action";
    private static final String NUMBER_SUFFIX = ".Number";
    private static final String FINISH_NUMBER_SUFFIX = ".FinishNumber";
    private static final String PROGRESS_SUFFIX = ".Progress";
    private static final String PROGRESS_FINISH_SUFFIX = ".ProgressFinish";
    private static final TemporaryFile INSTANCE = new TemporaryFile();
    private File dbFile = new File("plugins//logCaptcha//Data//data.db");
    private String dbUrl = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();

    private TemporaryFile() {
        this.initializeDatabase();
    }

    public static TemporaryFile getTemporaryFile() {
        return INSTANCE;
    }

    private void initializeDatabase() {
        if (!this.dbFile.getParentFile().exists()) {
            this.dbFile.getParentFile().mkdirs();
        }
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            String createPlayerDataTable = "CREATE TABLE IF NOT EXISTS player_data (id INTEGER PRIMARY KEY AUTOINCREMENT,player_name TEXT NOT NULL,data_key TEXT NOT NULL,data_value TEXT,UNIQUE(player_name, data_key))";
            stmt.execute(createPlayerDataTable);
            String createPlayerListTable = "CREATE TABLE IF NOT EXISTS player_list (id INTEGER PRIMARY KEY AUTOINCREMENT,player_name TEXT UNIQUE NOT NULL)";
            stmt.execute(createPlayerListTable);
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_CREATION_FAIL, this.getClass().getName(), "Could not initialize database.");
        }
    }

    private void setPlayerData(String playerName, String suffix, String value) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement("INSERT INTO player_data (player_name, data_key, data_value) VALUES (?, ?, ?) ON CONFLICT(player_name, data_key) DO UPDATE SET data_value = ?");){
            String key = playerName + suffix;
            pstmt.setString(1, playerName);
            pstmt.setString(2, key);
            pstmt.setString(3, value);
            pstmt.setString(4, value);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not save player data.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getPlayerData(String playerName, String suffix) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);){
            String string;
            block18: {
                PreparedStatement pstmt;
                block16: {
                    String string2;
                    block17: {
                        pstmt = conn.prepareStatement("SELECT data_value FROM player_data WHERE player_name = ? AND data_key = ?");
                        try {
                            String key = playerName + suffix;
                            pstmt.setString(1, playerName);
                            pstmt.setString(2, key);
                            ResultSet rs = pstmt.executeQuery();
                            if (!rs.next()) break block16;
                            string2 = rs.getString("data_value");
                            if (pstmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pstmt.close();
                    }
                    return string2;
                }
                string = null;
                if (pstmt == null) break block18;
                pstmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not read player data.");
            return null;
        }
    }

    private int getPlayerDataInt(String playerName, String suffix) {
        String value = this.getPlayerData(playerName, suffix);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void addFail(String playerName) {
        int currentFails = this.getPlayerDataInt(playerName, FAILS_SUFFIX);
        this.setPlayerData(playerName, FAILS_SUFFIX, String.valueOf(currentFails + 1));
    }

    public int getFails(String playerName) {
        return this.getPlayerDataInt(playerName, FAILS_SUFFIX);
    }

    public void setAction(String playerName, String action) {
        this.setPlayerData(playerName, ACTION_SUFFIX, action);
    }

    public String getAction(String playerName) {
        return this.getPlayerData(playerName, ACTION_SUFFIX);
    }

    public void loadPlayerList() {
    }

    public void addPlayerToList(String playerName) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement("INSERT OR IGNORE INTO player_list (player_name) VALUES (?)");){
            pstmt.setString(1, playerName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not add player to list.");
        }
    }

    public ArrayList<String> getPlayerList() {
        ArrayList<String> players = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT player_name FROM player_list");){
            while (rs.next()) {
                players.add(rs.getString("player_name"));
            }
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not read player list.");
        }
        return players;
    }

    public void setNumber(String playerName, int number) {
        this.setPlayerData(playerName, NUMBER_SUFFIX, String.valueOf(number));
    }

    public int getNumber(String playerName) {
        return this.getPlayerDataInt(playerName, NUMBER_SUFFIX);
    }

    public void setFinishNumber(String playerName, int number) {
        this.setPlayerData(playerName, FINISH_NUMBER_SUFFIX, String.valueOf(number));
    }

    public int getFinishNumber(String playerName) {
        return this.getPlayerDataInt(playerName, FINISH_NUMBER_SUFFIX);
    }

    public void addProgress(String playerName) {
        int currentProgress = this.getPlayerDataInt(playerName, PROGRESS_SUFFIX);
        this.setPlayerData(playerName, PROGRESS_SUFFIX, String.valueOf(currentProgress + 1));
    }

    public void setProgress(String playerName, int number) {
        this.setPlayerData(playerName, PROGRESS_SUFFIX, String.valueOf(number));
    }

    public int getProgress(String playerName) {
        return this.getPlayerDataInt(playerName, PROGRESS_SUFFIX);
    }

    public void addProgressFinish(String playerName) {
        int currentProgressFinish = this.getPlayerDataInt(playerName, PROGRESS_FINISH_SUFFIX);
        this.setPlayerData(playerName, PROGRESS_FINISH_SUFFIX, String.valueOf(currentProgressFinish + 1));
    }

    public void setProgressFinish(String playerName, int number) {
        this.setPlayerData(playerName, PROGRESS_FINISH_SUFFIX, String.valueOf(number));
    }

    public int getProgressFinish(String playerName) {
        return this.getPlayerDataInt(playerName, PROGRESS_FINISH_SUFFIX);
    }

    public void saveFile() {
    }
}

