/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.files;

import de.tofastforyou.logcaptcha.utils.ErrorSaver;
import de.tofastforyou.logcaptcha.utils.ErrorTypes;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class CaptchaFile {
    private static CaptchaFile Captcha_File = new CaptchaFile();
    private File dbFile = new File("plugins//logCaptcha//Data//data.db");
    private String dbUrl = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();

    public CaptchaFile() {
        this.initializeDatabase();
    }

    public static CaptchaFile getCaptchaFile() {
        return Captcha_File;
    }

    private void initializeDatabase() {
        if (!this.dbFile.getParentFile().exists()) {
            this.dbFile.getParentFile().mkdirs();
        }
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            String createTable = "CREATE TABLE IF NOT EXISTS temporary_no_captcha (id INTEGER PRIMARY KEY AUTOINCREMENT,player_name TEXT UNIQUE NOT NULL)";
            stmt.execute(createTable);
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_CREATION_FAIL, this.getClass().getName(), "Could not initialize database.");
        }
    }

    public List<String> getList() {
        ArrayList<String> names = new ArrayList<String>();
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT player_name FROM temporary_no_captcha");){
            while (rs.next()) {
                names.add(rs.getString("player_name"));
            }
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not get list.");
        }
        return names;
    }

    public void addNameToList(String playerName) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement("INSERT OR IGNORE INTO temporary_no_captcha (player_name) VALUES (?)");){
            pstmt.setString(1, playerName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not add name to list.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isInList(String playerName) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);){
            boolean bl;
            block18: {
                PreparedStatement pstmt;
                block16: {
                    boolean bl2;
                    block17: {
                        pstmt = conn.prepareStatement("SELECT COUNT(*) FROM temporary_no_captcha WHERE player_name = ?");
                        try {
                            pstmt.setString(1, playerName);
                            ResultSet rs = pstmt.executeQuery();
                            if (!rs.next()) break block16;
                            boolean bl3 = bl2 = rs.getInt(1) > 0;
                            if (pstmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pstmt.close();
                    }
                    return bl2;
                }
                bl = false;
                if (pstmt == null) break block18;
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not check if name is in list.");
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public int getListSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteList() {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            stmt.execute("DELETE FROM temporary_no_captcha");
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not delete list.");
        }
    }
}

