/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha;

import de.tofastforyou.logcaptcha.commands.ApproveCommand;
import de.tofastforyou.logcaptcha.commands.CaptchaCommand;
import de.tofastforyou.logcaptcha.commands.LogBanCommand;
import de.tofastforyou.logcaptcha.commands.LogCaptchaAdminCommand;
import de.tofastforyou.logcaptcha.commands.LogCaptchaCommand;
import de.tofastforyou.logcaptcha.events.ChatEvent;
import de.tofastforyou.logcaptcha.events.EntityDamageEvent;
import de.tofastforyou.logcaptcha.events.FoodLevelChangeEventListener;
import de.tofastforyou.logcaptcha.events.InventoryClickEventListener;
import de.tofastforyou.logcaptcha.events.InventoryCloseEventListener;
import de.tofastforyou.logcaptcha.events.JoinEvent;
import de.tofastforyou.logcaptcha.events.MoveEvent;
import de.tofastforyou.logcaptcha.events.QuitEvent;
import de.tofastforyou.logcaptcha.events.RightClickEvent;
import de.tofastforyou.logcaptcha.files.CustomCaptchaFile;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Countdown;
import de.tofastforyou.logcaptcha.utils.Vars;
import de.tofastforyou.logcaptcha.utils.VersionCheck;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LogCaptcha
extends JavaPlugin {
    private static LogCaptcha instance;
    private final String configVersion = "1.2.3";
    private final String languageVersion = "1.1";

    public void onEnable() {
        instance = this;
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        console.sendMessage("Loading logCaptcha...");
        this.loadPlugin(console);
        this.initialize();
    }

    private void initialize() {
        if (this.getConfig().getBoolean("logCaptcha.Options.ResetAlreadyDoneList")) {
            Countdown.getCountdown().startCountdown();
        }
    }

    public static LogCaptcha getInstance() {
        return instance;
    }

    private void loadPlugin(ConsoleCommandSender console) {
        console.sendMessage("Loading config...");
        this.saveDefaultConfig();
        this.checkAndUpdateConfig();
        console.sendMessage("Loading captchas...");
        if (this.getConfig().getBoolean("logCaptcha.UseCustomCaptchas")) {
            CustomCaptchaFile customFile = CustomCaptchaFile.getCustomCaptchaFile();
            customFile.saveFile();
            customFile.loadDefault();
        }
        console.sendMessage("Loading languages...");
        LanguageFile.getLanguageFile().loadDefaultLanguages();
        console.sendMessage("Checking files...");
        this.checkAndUpdateLanguageFile();
        LanguageFile.getLanguageFile().saveFile();
        if (this.getConfig().getBoolean("logCaptcha.Options.UseStatistics")) {
            StatisticsFile.getStatisticsFile().saveFile();
        }
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        tempFile.saveFile();
        tempFile.loadPlayerList();
        if (this.getConfig().getBoolean("logCaptcha.UseCustomCaptchas")) {
            CustomCaptchaFile.getCustomCaptchaFile().saveFile();
        }
        console.sendMessage("Checking version...");
        this.checkVersionCompatibility();
        console.sendMessage("Checking options...");
        if (this.getConfig().getBoolean("logCaptcha.Options.UseBWaves")) {
            console.sendMessage(Vars.getVars().pr + "\u00a7cThe auto-ban system was provided by \u00a7ebWaves\u00a7c!");
        }
        console.sendMessage("Registering listeners...");
        this.registerEvents();
        console.sendMessage("Registering commands...");
        this.registerCommands();
        console.sendMessage("logCaptcha is fully loaded!");
    }

    private void checkVersionCompatibility() {
        if (!VersionCheck.getVersionCheck().isVersionCompatible(Bukkit.getBukkitVersion())) {
            String prefix = Vars.getVars().pr;
            Bukkit.getConsoleSender().sendMessage(new String[]{prefix + "\u00a74Your server version is incompatible with some plugin functions!", prefix + "\u00a74Only chat captchas will work.", prefix + "\u00a74To use all features, switch to one of: \u00a7e1.20.x, 1.21.x"});
            if (!this.getConfig().getBoolean("logCaptcha.Options.UseChatCaptcha")) {
                this.getConfig().set("logCaptcha.Options.UseChatCaptcha", (Object)true);
                this.getConfig().set("logCaptcha.Options.UseSquareCaptcha", (Object)false);
                this.saveConfig();
            }
        }
    }

    private void checkAndUpdateConfig() {
        String currentVersion = this.getConfig().getString("logCaptcha.Version");
        if (!"1.2.3".equals(currentVersion)) {
            File configFile = new File(this.getDataFolder(), "config.yml");
            configFile.delete();
            this.saveDefaultConfig();
            this.reloadConfig();
            Bukkit.getConsoleSender().sendMessage(Vars.getVars().pr + "\u00a74WARNING: Config file reset to defaults!");
        }
    }

    private void checkAndUpdateLanguageFile() {
        LanguageFile langFile = LanguageFile.getLanguageFile();
        if (!"1.1".equals(langFile.getVersion())) {
            langFile.langFile.delete();
            langFile.loadDefaultLanguages();
            Bukkit.getConsoleSender().sendMessage(Vars.getVars().pr + "\u00a74WARNING: Language file reset to defaults!");
        }
    }

    private void registerEvents() {
        PluginManager pm = Bukkit.getPluginManager();
        LogCaptcha plugin = LogCaptcha.getInstance();
        pm.registerEvents((Listener)new JoinEvent(), (Plugin)plugin);
        pm.registerEvents((Listener)new InventoryClickEventListener(), (Plugin)plugin);
        pm.registerEvents((Listener)new ChatEvent(), (Plugin)plugin);
        pm.registerEvents((Listener)new EntityDamageEvent(), (Plugin)plugin);
        pm.registerEvents((Listener)new FoodLevelChangeEventListener(), (Plugin)plugin);
        pm.registerEvents((Listener)new MoveEvent(), (Plugin)plugin);
        pm.registerEvents((Listener)new QuitEvent(), (Plugin)plugin);
        pm.registerEvents((Listener)new InventoryCloseEventListener(this), (Plugin)plugin);
        pm.registerEvents((Listener)new RightClickEvent(), (Plugin)plugin);
    }

    private void registerCommands() {
        this.getCommand("captcha").setExecutor((CommandExecutor)new CaptchaCommand());
        this.getCommand("logcaptcha").setExecutor((CommandExecutor)new LogCaptchaCommand());
        this.getCommand("captchaprove").setExecutor((CommandExecutor)new ApproveCommand());
        this.getCommand("logcaptchaadmin").setExecutor((CommandExecutor)new LogCaptchaAdminCommand());
        this.getCommand("logban").setExecutor((CommandExecutor)new LogBanCommand());
    }
}

