/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.utils.inventories;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ManagementMenuInventory {
    private static final ManagementMenuInventory INSTANCE = new ManagementMenuInventory();
    private static final int INVENTORY_SIZE = 27;
    private static final String ENGLISH = "en-EN";
    private static final String GERMAN = "de-DE";

    public static ManagementMenuInventory getManagementMenuInventory() {
        return INSTANCE;
    }

    public void openInventory(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        String language = LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language");
        boolean saveAlreadyDone = LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.Options.SaveAlreadyDone");
        if (ENGLISH.equals(language)) {
            this.createEnglishMenu(player, saveAlreadyDone);
        } else if (GERMAN.equals(language)) {
            this.createGermanMenu(player, saveAlreadyDone);
        }
        player.openInventory(Vars.getVars().menu);
    }

    private void createEnglishMenu(Player player, boolean saveAlreadyDone) {
        Vars.getVars().menu = player.getServer().createInventory(null, 27, "\u00a7aMenu");
        ItemStack filler = this.createFillerItem();
        ItemStack listAllUser = this.createListAllUserItem(true);
        ItemStack resetConfig = this.createResetConfigItem(true);
        ItemStack checkForUpdate = this.createCheckForUpdateItem(true);
        if (saveAlreadyDone) {
            ItemStack resetAlreadyDone = this.createResetAlreadyDoneItem(true);
            this.setupInventoryWithResetOption(filler, resetAlreadyDone, listAllUser, resetConfig, checkForUpdate);
        } else {
            this.setupInventoryWithoutResetOption(filler, listAllUser, resetConfig, checkForUpdate);
        }
    }

    private void createGermanMenu(Player player, boolean saveAlreadyDone) {
        Vars.getVars().menu = player.getServer().createInventory(null, 27, "\u00a7aMen\u00fc");
        ItemStack filler = this.createFillerItem();
        ItemStack listAllUser = this.createListAllUserItem(false);
        ItemStack resetConfig = this.createResetConfigItem(false);
        ItemStack checkForUpdate = this.createCheckForUpdateItem(false);
        if (saveAlreadyDone) {
            ItemStack resetAlreadyDone = this.createResetAlreadyDoneItem(false);
            this.setupInventoryWithResetOption(filler, resetAlreadyDone, listAllUser, resetConfig, checkForUpdate);
        } else {
            this.setupInventoryWithoutResetOption(filler, listAllUser, resetConfig, checkForUpdate);
        }
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem("\u00a70", 1, Material.BLACK_STAINED_GLASS_PANE, (short)7);
    }

    private ItemStack createResetAlreadyDoneItem(boolean isEnglish) {
        if (isEnglish) {
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77If you click this,", "\u00a77you will \u00a7creset \u00a77the", "\u00a7eAlreadyDoneList \u00a77and create a new one."));
            return ItemCreator.getItemCreator().createItem("\u00a7cReset AlradyDoneList", 1, Material.BARRIER, lore);
        }
        ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77Setzt die \u00a7eAlreadyDoneList\u00a77 \u00a7czur\u00fcck\u00a77,", "\u00a77sodass alle \u00a7eSpieler \u00a77erneut ein", "\u00a7eCaptcha \u00a77machen \u00a7cm\u00fcssen\u00a77."));
        return ItemCreator.getItemCreator().createItem("\u00a7cSetze die AlreadyDoneList zur\u00fcck", 1, Material.BARRIER, lore);
    }

    private ItemStack createListAllUserItem(boolean isEnglish) {
        if (isEnglish) {
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77If you click this,", "\u00a77you will get a message", "\u00a77with all registered \u00a7eusers\u00a77."));
            return ItemCreator.getItemCreator().createItem("\u00a77List all \u00a7euser", 1, Material.PAPER, lore);
        }
        ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77Listet alle registrierten \u00a7eSpieler \u00a77auf", "\u00a77und sendet dir eine \u00a7eNachricht \u00a77mit der \u00a7eListe\u00a77.", "\u00a77In der \u00a7eListe \u00a77gibt es weitere \u00a7eOptionen\u00a77."));
        return ItemCreator.getItemCreator().createItem("\u00a77Liste alle \u00a7eSpieler \u00a77auf", 1, Material.PAPER, lore);
    }

    private ItemStack createResetConfigItem(boolean isEnglish) {
        if (isEnglish) {
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77If you click this,", "\u00a77you will \u00a7creset \u00a77the", "\u00a7econfig.yml \u00a77file."));
            return ItemCreator.getItemCreator().createItem("\u00a74Reset config file", 1, Material.BARRIER, lore);
        }
        ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77Setzt die \u00a7eConfig Datei\u00a77 \u00a7czur\u00fcck\u00a77,", "\u00a77sodass alle \u00a7eEinstellungen \u00a77auf den", "\u00a7eStandard \u00a77gesetzt werden."));
        return ItemCreator.getItemCreator().createItem("\u00a74Setze die Config Datei zur\u00fcck", 1, Material.BARRIER, lore);
    }

    private ItemStack createCheckForUpdateItem(boolean isEnglish) {
        if (isEnglish) {
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77If you click this,", "\u00a77you will \u00a7echeck \u00a77for new", "\u00a7eupdates \u00a77for \u00a7elogCaptcha\u00a77."));
            return ItemCreator.getItemCreator().createItem("\u00a77Check for \u00a7eUpdates", 1, Material.PAPER, lore);
        }
        ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77\u00dcberpr\u00fcft, ob ein \u00a7eUpdate \u00a77f\u00fcr", "\u00a7elogCaptcha \u00a77vorhanden ist."));
        return ItemCreator.getItemCreator().createItem("\u00a77\u00dcberpr\u00fcfe auf \u00a7eUpdates", 1, Material.PAPER, lore);
    }

    private void setupInventoryWithResetOption(ItemStack filler, ItemStack resetAlreadyDone, ItemStack listAllUser, ItemStack resetConfig, ItemStack checkForUpdate) {
        this.fillInventoryWithFiller(filler);
        Vars.getVars().menu.setItem(10, resetAlreadyDone);
        Vars.getVars().menu.setItem(12, listAllUser);
        Vars.getVars().menu.setItem(14, resetConfig);
        Vars.getVars().menu.setItem(16, checkForUpdate);
    }

    private void setupInventoryWithoutResetOption(ItemStack filler, ItemStack listAllUser, ItemStack resetConfig, ItemStack checkForUpdate) {
        this.fillInventoryWithFiller(filler);
        Vars.getVars().menu.setItem(11, listAllUser);
        Vars.getVars().menu.setItem(13, resetConfig);
        Vars.getVars().menu.setItem(15, checkForUpdate);
    }

    private void fillInventoryWithFiller(ItemStack filler) {
        for (int i = 0; i < 27; ++i) {
            Vars.getVars().menu.setItem(i, filler);
        }
    }
}

