/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.utils.inventories;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.utils.Vars;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConfirmationInventory {
    private static final ConfirmationInventory INSTANCE = new ConfirmationInventory();
    private static final int INVENTORY_SIZE = 27;
    private static final int YES_SLOT = 12;
    private static final int NO_SLOT = 14;
    private static final String LANG_ENGLISH = "en-EN";
    private static final String LANG_GERMAN = "de-DE";
    private static final String TITLE_EN = "\u00a7aAre you sure?";
    private static final String TITLE_DE = "\u00a7aBist du dir sicher?";
    private static final String YES_EN = "\u00a7aYes";
    private static final String YES_DE = "\u00a7aJa";
    private static final String NO_EN = "\u00a7cNo";
    private static final String NO_DE = "\u00a7cNein";
    private static final String FILLER_NAME = "\u00a70";

    public static ConfirmationInventory getConfirmationInventory() {
        return INSTANCE;
    }

    public void openInventory(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        String language = LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language");
        if (this.isEnglish(language)) {
            this.createAndOpenInventory(player, TITLE_EN, YES_EN, NO_EN);
        } else if (this.isGerman(language)) {
            this.createAndOpenInventory(player, TITLE_DE, YES_DE, NO_DE);
        }
    }

    private boolean isEnglish(String language) {
        return LANG_ENGLISH.equals(language);
    }

    private boolean isGerman(String language) {
        return LANG_GERMAN.equals(language);
    }

    private void createAndOpenInventory(Player player, String title, String yesText, String noText) {
        Vars.getVars().menu = player.getServer().createInventory(null, 27, title);
        ItemStack filler = this.createFillerItem();
        ItemStack yesItem = this.createYesItem(yesText);
        ItemStack noItem = this.createNoItem(noText);
        this.fillInventory(filler, yesItem, noItem);
        player.openInventory(Vars.getVars().menu);
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem(FILLER_NAME, 1, Material.BLACK_STAINED_GLASS_PANE, (short)7);
    }

    private ItemStack createYesItem(String displayName) {
        return ItemCreator.getItemCreator().createItem(displayName, 1, Material.GREEN_TERRACOTTA);
    }

    private ItemStack createNoItem(String displayName) {
        return ItemCreator.getItemCreator().createItem(displayName, 1, Material.RED_TERRACOTTA);
    }

    private void fillInventory(ItemStack filler, ItemStack yesItem, ItemStack noItem) {
        for (int i = 0; i < 27; ++i) {
            Vars.getVars().menu.setItem(i, filler);
        }
        Vars.getVars().menu.setItem(12, yesItem);
        Vars.getVars().menu.setItem(14, noItem);
    }
}

