/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.files;

import de.tofastforyou.logcaptcha.utils.ErrorSaver;
import de.tofastforyou.logcaptcha.utils.ErrorTypes;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class StatisticsFile {
    private static StatisticsFile Statistics_File = new StatisticsFile();
    private File dbFile = new File("plugins//logCaptcha//Data//data.db");
    private String dbUrl = "jdbc:sqlite:" + this.dbFile.getAbsolutePath();

    public StatisticsFile() {
        this.initializeDatabase();
    }

    public static StatisticsFile getStatisticsFile() {
        return Statistics_File;
    }

    private void initializeDatabase() {
        if (!this.dbFile.getParentFile().exists()) {
            this.dbFile.getParentFile().mkdirs();
        }
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             Statement stmt = conn.createStatement();){
            String createTable = "CREATE TABLE IF NOT EXISTS statistics (id INTEGER PRIMARY KEY AUTOINCREMENT,stat_name TEXT UNIQUE NOT NULL,stat_value INTEGER DEFAULT 0)";
            stmt.execute(createTable);
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_CREATION_FAIL, this.getClass().getName(), "Could not initialize database.");
        }
    }

    private void incrementStat(String statName) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);
             PreparedStatement pstmt = conn.prepareStatement("INSERT INTO statistics (stat_name, stat_value) VALUES (?, 1) ON CONFLICT(stat_name) DO UPDATE SET stat_value = stat_value + 1");){
            pstmt.setString(1, statName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not save statistic: " + statName);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int getStat(String statName) {
        try (Connection conn = DriverManager.getConnection(this.dbUrl);){
            int n;
            block18: {
                PreparedStatement pstmt;
                block16: {
                    int n2;
                    block17: {
                        pstmt = conn.prepareStatement("SELECT stat_value FROM statistics WHERE stat_name = ?");
                        try {
                            pstmt.setString(1, statName);
                            ResultSet rs = pstmt.executeQuery();
                            if (!rs.next()) break block16;
                            n2 = rs.getInt("stat_value");
                            if (pstmt == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (pstmt != null) {
                                try {
                                    pstmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        pstmt.close();
                    }
                    return n2;
                }
                n = 0;
                if (pstmt == null) break block18;
                pstmt.close();
            }
            return n;
        }
        catch (SQLException e) {
            ErrorSaver.getSaveError().saveError(ErrorTypes.FILE_SAVE_FAIL, this.getClass().getName(), "Could not read statistic: " + statName);
            return 0;
        }
    }

    public void saveFile() {
    }

    public void addApprovedPlayer() {
        this.incrementStat("ApprovedPlayer");
    }

    public void addPlayerClosedInventory() {
        this.incrementStat("PlayerClosedInventory");
    }

    public void addFailedPlayer() {
        this.incrementStat("FailedPlayer");
    }

    public void doneChatCaptcha() {
        this.incrementStat("ChatCaptcha");
    }

    public void doneInventoryCaptcha() {
        this.incrementStat("InventoryCaptcha");
    }

    public void addLogEntry() {
        this.incrementStat("LogEntrys");
    }

    public void addPlayerJoined() {
        this.incrementStat("PlayerJoined");
    }

    public void addPlayerTriedCommand() {
        this.incrementStat("PlayerTriedCommand");
    }

    public void addPlayerTriedMove() {
        this.incrementStat("PlayerTriedMove");
    }

    public int getPlayerClosedInventory() {
        return this.getStat("PlayerClosedInventory");
    }

    public int getPlayerTriedMove() {
        return this.getStat("PlayerTriedMove");
    }

    public int getPlayerTriedCommand() {
        return this.getStat("PlayerTriedCommand");
    }

    public int getPlayerJoined() {
        return this.getStat("PlayerJoined");
    }

    public int getLogEntrys() {
        return this.getStat("LogEntrys");
    }

    public int getDoneChatCaptcha() {
        return this.getStat("ChatCaptcha");
    }

    public int getDoneInventoryCaptcha() {
        return this.getStat("InventoryCaptcha");
    }

    public int getFailedPlayer() {
        return this.getStat("FailedPlayer");
    }

    public int getApprovedPlayer() {
        return this.getStat("ApprovedPlayer");
    }
}

