/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.events;

import de.tofastforyou.bwaves.files.BanFile;
import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.captcha.ChatCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.ClickChatCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.InventoryCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SquareCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SteeringCaptcha;
import de.tofastforyou.logcaptcha.files.CaptchaFile;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Log;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class JoinEvent
implements Listener {
    private final Random random = new Random();
    private final LogCaptcha plugin = LogCaptcha.getInstance();

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        if (CaptchaFile.getCaptchaFile().isInList(player.getName())) {
            return;
        }
        this.updateStatistics();
        this.addPlayerToTemporaryList(player.getName());
        if (this.handleBannedPlayer(player)) {
            return;
        }
        this.handleCaptchaLogic(player);
    }

    private void updateStatistics() {
        if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseStatistics")) {
            StatisticsFile.getStatisticsFile().addPlayerJoined();
        }
    }

    private void addPlayerToTemporaryList(String playerName) {
        if (!TemporaryFile.getTemporaryFile().getPlayerList().contains(playerName)) {
            TemporaryFile.getTemporaryFile().addPlayerToList(playerName);
        }
    }

    private boolean handleBannedPlayer(Player player) {
        if (BanFile.getBanFile().isBanned(player.getName())) {
            String banMessage = this.getLocalizedMessage("Messages.BannedByBWaves");
            player.kickPlayer(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)banMessage));
            return true;
        }
        return false;
    }

    private void handleCaptchaLogic(Player player) {
        int captchaId = this.random.nextInt(21) + 1;
        int randomNumber = this.random.nextInt(4) + 1;
        int randomFinishNumber = this.random.nextInt(28) + 2;
        long checkCooldown = (long)this.plugin.getConfig().getInt("logCaptcha.Options.CheckCooldown") * 20L;
        int waitingTime = this.plugin.getConfig().getInt("logCaptcha.Options.WaitingTime");
        int timeoutSeconds = waitingTime * 20;
        if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseChatCaptcha")) {
            this.scheduleChatCaptcha(player, checkCooldown, waitingTime);
        } else if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseInventoryCaptcha")) {
            this.scheduleInventoryCaptcha(player, captchaId, checkCooldown, waitingTime);
        } else if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseRaisingCaptcha")) {
            this.scheduleSteeringCaptcha(player, randomNumber, randomFinishNumber, checkCooldown, waitingTime);
        } else if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseClickChatCaptcha")) {
            this.scheduleClickChatCaptcha(player, checkCooldown, waitingTime);
        } else if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseSquareCaptcha")) {
            this.scheduleSquareCaptcha(player, checkCooldown, waitingTime);
        }
        this.scheduleTimeoutHandler(player, checkCooldown + (long)timeoutSeconds);
    }

    private void scheduleChatCaptcha(Player player, long checkCooldown, int waitingTime) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.sendJoinMessages(player, waitingTime);
            ChatCaptcha.getChatCaptcha().sendCaptcha(player, ChatCaptcha.getChatCaptcha().getCaptchaWord());
            Captcha.getCaptcha().playerInChatCaptcha.add(player);
        }, checkCooldown);
    }

    private void scheduleInventoryCaptcha(Player player, int captchaId, long checkCooldown, int waitingTime) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            InventoryCaptcha.getInventoryCaptcha().openCaptcha(captchaId, player);
            Captcha.getCaptcha().playerInCaptcha.add(player);
            this.sendJoinMessages(player, waitingTime);
        }, checkCooldown);
    }

    private void scheduleSteeringCaptcha(Player player, int randomNumber, int randomFinishNumber, long checkCooldown, int waitingTime) {
        TemporaryFile.getTemporaryFile().setNumber(player.getName(), randomNumber);
        TemporaryFile.getTemporaryFile().setFinishNumber(player.getName(), randomFinishNumber);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            SteeringCaptcha.getSteeringCaptcha().openCaptcha(player);
            Captcha.getCaptcha().playerInCaptcha.add(player);
            this.sendJoinMessages(player, waitingTime);
        }, checkCooldown);
    }

    private void scheduleClickChatCaptcha(Player player, long checkCooldown, int waitingTime) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            ClickChatCaptcha.getClickChatCaptcha().sendCaptcha(player, ClickChatCaptcha.getClickChatCaptcha().getCaptchaWord());
            Captcha.getCaptcha().playerInCaptcha.add(player);
            this.sendJoinMessages(player, waitingTime);
        }, checkCooldown);
    }

    private void scheduleSquareCaptcha(Player player, long checkCooldown, int waitingTime) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            SquareCaptcha.getSquareCaptcha().openCaptcha(player);
            Captcha.getCaptcha().playerInCaptcha.add(player);
            this.sendJoinMessages(player, waitingTime);
        }, checkCooldown);
    }

    private void scheduleTimeoutHandler(Player player, long totalDelay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (Captcha.getCaptcha().playerInCaptcha.contains(player) || Captcha.getCaptcha().playerInChatCaptcha.contains(player)) {
                Log.getLog().log(player.getName() + " failed to solve the captcha in time!");
                String timeoutMessage = this.getLocalizedMessage("Messages.FailedCaptchaInTime");
                player.kickPlayer(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)timeoutMessage));
            }
        }, totalDelay);
    }

    private void sendJoinMessages(Player player, int waitingTime) {
        String joinMessage = this.getLocalizedMessage("Messages.JoinMessage");
        String timeMessage = this.getLocalizedTimeMessage(waitingTime);
        player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)joinMessage));
        player.sendMessage(Vars.getVars().pr + timeMessage);
    }

    private String getLocalizedMessage(String messageKey) {
        String language = this.plugin.getConfig().getString("logCaptcha.Language");
        return LanguageFile.getLanguageFile().langCfg.getString(language + "." + messageKey);
    }

    private String getLocalizedTimeMessage(int waitingTime) {
        String language = this.plugin.getConfig().getString("logCaptcha.Language");
        if ("en-EN".equals(language)) {
            return "\u00a7cYou have to do this in \u00a7e" + waitingTime + "\u00a7c seconds!";
        }
        if ("de-DE".equals(language)) {
            return "\u00a7cDu hast daf\u00fcr \u00a7e" + waitingTime + "\u00a7c Sekunden Zeit!";
        }
        return "\u00a7cYou have to do this in \u00a7e" + waitingTime + "\u00a7c seconds!";
    }
}

