/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.events;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.captcha.InventoryCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SquareCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SteeringCaptcha;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;

public class InventoryCloseEventListener
implements Listener {
    private static final long CAPTCHA_REOPEN_DELAY = 5L;
    private static final int MIN_CAPTCHA_ID = 1;
    private static final int MAX_CAPTCHA_ID = 21;
    private final LogCaptcha plugin;
    private final Random random;

    public InventoryCloseEventListener(LogCaptcha plugin) {
        this.plugin = plugin;
        this.random = ThreadLocalRandom.current();
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        if (!this.isPlayerInCaptcha(player)) {
            return;
        }
        this.updateStatisticsIfEnabled();
        this.handleCaptchaReopening(event, player);
    }

    private boolean isPlayerInCaptcha(Player player) {
        return Captcha.getCaptcha().playerInCaptcha.contains(player);
    }

    private void updateStatisticsIfEnabled() {
        if (this.plugin.getConfig().getBoolean("logCaptcha.Options.UseStatistics")) {
            StatisticsFile.getStatisticsFile().addPlayerClosedInventory();
        }
    }

    private void handleCaptchaReopening(InventoryCloseEvent event, Player player) {
        String inventoryTitle = event.getView().getTitle();
        if (inventoryTitle.contains("Captcha")) {
            this.reopenInventoryCaptcha(player);
        } else if (inventoryTitle.contains("Square")) {
            this.reopenSquareCaptcha(player);
        } else if (inventoryTitle.contains("Raise Number")) {
            this.reopenSteeringCaptcha(player);
        }
    }

    private void reopenInventoryCaptcha(Player player) {
        int captchaId = this.generateRandomCaptchaId();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> InventoryCaptcha.getInventoryCaptcha().openCaptcha(captchaId, player), 5L);
    }

    private void reopenSquareCaptcha(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            TemporaryFile.getTemporaryFile().setProgressFinish(player.getName(), 0);
            SquareCaptcha.getSquareCaptcha().openCaptcha(player);
        }, 5L);
    }

    private void reopenSteeringCaptcha(Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> SteeringCaptcha.getSteeringCaptcha().openCaptcha(player), 5L);
    }

    private int generateRandomCaptchaId() {
        return this.random.nextInt(21) + 1;
    }
}

