/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.events;

import de.tofastforyou.bwaves.files.BanFile;
import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.captcha.ChatCaptcha;
import de.tofastforyou.logcaptcha.files.CaptchaFile;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Log;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatEvent
implements Listener {
    private static final String LANGUAGE_ENGLISH = "en-EN";
    private static final String LANGUAGE_GERMAN = "de-DE";
    private static final int MAX_CAPTCHA_FAILS = 5;
    private final LogCaptcha plugin = LogCaptcha.getInstance();

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerInChatCaptcha(player)) {
            this.handleChatCaptcha(event, player);
        } else if (this.isPlayerInRegularCaptcha(player)) {
            event.setCancelled(true);
        }
    }

    private boolean isPlayerInChatCaptcha(Player player) {
        return this.isChatCaptchaEnabled() && Captcha.getCaptcha().playerInChatCaptcha.contains(player);
    }

    private boolean isPlayerInRegularCaptcha(Player player) {
        return Captcha.getCaptcha().playerInCaptcha.contains(player);
    }

    private boolean isChatCaptchaEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseChatCaptcha");
    }

    private void handleChatCaptcha(AsyncPlayerChatEvent event, Player player) {
        event.setCancelled(true);
        String message = event.getMessage();
        if (this.isCaptchaAnswerCorrect(message)) {
            this.handleCorrectCaptcha(player, message);
        } else {
            this.handleIncorrectCaptcha(player);
        }
    }

    private boolean isCaptchaAnswerCorrect(String message) {
        ChatCaptcha chatCaptcha = ChatCaptcha.getChatCaptcha();
        return chatCaptcha.temporaryWordList.contains(message) || chatCaptcha.randomWordList.contains(message) || Arrays.asList(chatCaptcha.customWordList).contains(message);
    }

    private void handleCorrectCaptcha(Player player, String message) {
        this.sendSuccessMessage(player);
        if (this.shouldSaveCompletedCaptcha()) {
            CaptchaFile.getCaptchaFile().addNameToList(player.getName());
        }
        this.removePlayerFromCaptcha(player);
        this.playSuccessSound(player);
        this.removeCaptchaWord(message);
        this.updateStatisticsForSuccess();
    }

    private void sendSuccessMessage(Player player) {
        String messageKey = this.getCurrentLanguage() + ".Messages.SuccessCaptcha";
        String message = this.getLocalizedMessage(messageKey);
        player.sendMessage(Vars.getVars().pr + message);
    }

    private void handleIncorrectCaptcha(Player player) {
        this.updateStatisticsForFailure();
        if (this.isBWavesEnabled()) {
            this.handleBWavesPunishment(player);
        } else {
            this.handleRegularPunishment(player);
        }
    }

    private void handleBWavesPunishment(Player player) {
        String playerName = player.getName();
        int currentFails = TemporaryFile.getTemporaryFile().getFails(playerName);
        if (currentFails > 5) {
            BanFile.getBanFile().banPlayer(playerName);
        } else {
            TemporaryFile.getTemporaryFile().addFail(playerName);
        }
        this.kickPlayerWithFailureMessage(player);
    }

    private void handleRegularPunishment(Player player) {
        Log.getLog().log(player.getName() + " failed the captcha!");
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.kickPlayerWithFailureMessage(player));
    }

    private void kickPlayerWithFailureMessage(Player player) {
        String messageKey = this.getCurrentLanguage() + ".Messages.FailedCaptcha";
        String message = this.getLocalizedMessage(messageKey);
        player.kickPlayer(Vars.getVars().pr + message);
    }

    private String getCurrentLanguage() {
        return this.plugin.getConfig().getString("logCaptcha.Language");
    }

    private String getLocalizedMessage(String key) {
        String message = LanguageFile.getLanguageFile().langCfg.getString(key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private boolean shouldSaveCompletedCaptcha() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.SaveAlreadyDone");
    }

    private boolean isBWavesEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseBWaves");
    }

    private boolean isStatisticsEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseStatistics");
    }

    private void removePlayerFromCaptcha(Player player) {
        Captcha.getCaptcha().playerInChatCaptcha.remove(player);
    }

    private void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private void removeCaptchaWord(String message) {
        ChatCaptcha chatCaptcha = ChatCaptcha.getChatCaptcha();
        chatCaptcha.randomWordList.remove(message);
        chatCaptcha.temporaryWordList.remove(message);
    }

    private void updateStatisticsForSuccess() {
        if (this.isStatisticsEnabled()) {
            StatisticsFile statisticsFile = StatisticsFile.getStatisticsFile();
            statisticsFile.addApprovedPlayer();
            statisticsFile.doneChatCaptcha();
        }
    }

    private void updateStatisticsForFailure() {
        if (this.isStatisticsEnabled()) {
            StatisticsFile.getStatisticsFile().addFailedPlayer();
        }
    }
}

