/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.commands;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.files.CaptchaFile;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.utils.Countdown;
import de.tofastforyou.logcaptcha.utils.Statistics;
import de.tofastforyou.logcaptcha.utils.Vars;
import de.tofastforyou.logcaptcha.utils.VersionCheck;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LogCaptchaCommand
implements CommandExecutor {
    private static final String COMMAND_NAME = "logcaptcha";
    private static final String STATS_ARG = "stats";
    private static final String UPDATE_ARG = "update";
    private final LogCaptcha plugin = LogCaptcha.getInstance();
    private final StatisticsFile statisticsFile = StatisticsFile.getStatisticsFile();

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase(COMMAND_NAME) || !(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showPluginInfo(player);
            return true;
        }
        if (args.length == 1) {
            String arg;
            switch (arg = args[0].toLowerCase()) {
                case "stats": {
                    this.showStatistics(player);
                    return true;
                }
                case "update": {
                    this.checkForUpdates(player);
                    return true;
                }
            }
            this.showPluginInfo(player);
            return true;
        }
        this.showPluginInfo(player);
        return true;
    }

    private void showPluginInfo(Player player) {
        String language = this.getLanguage();
        String prefix = Vars.getVars().pr;
        if (this.isEnglish(language)) {
            this.sendEnglishPluginInfo(player, prefix);
        } else if (this.isGerman(language)) {
            this.sendGermanPluginInfo(player, prefix);
        }
    }

    private void sendEnglishPluginInfo(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77\u00a7lInformation:");
        player.sendMessage(prefix + "\u00a77Plugin version: \u00a7e" + this.plugin.getDescription().getVersion());
        player.sendMessage(prefix + "\u00a77Build Number: \u00a7e" + this.getBuildNumber());
        player.sendMessage(prefix + "\u00a77Plugin language: \u00a7e" + this.getLanguage());
        player.sendMessage(prefix + "\u00a77Server version: \u00a7e" + Bukkit.getServer().getBukkitVersion());
        player.sendMessage(prefix + "\u00a77Is version compatible: \u00a7e" + this.isVersionCompatible());
        if (this.isResetListEnabled()) {
            player.sendMessage(prefix + "\u00a77Current reset list countdown: \u00a7e" + this.getCountdownSeconds());
        }
        player.sendMessage(prefix + "\u00a77Thanks for downloading!");
    }

    private void sendGermanPluginInfo(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77\u00a7lInformation:");
        player.sendMessage(prefix + "\u00a77Plugin Version: \u00a7e" + this.plugin.getDescription().getVersion());
        player.sendMessage(prefix + "\u00a77Buildnummer: \u00a7e" + this.getBuildNumber());
        player.sendMessage(prefix + "\u00a77Plugin Sprache: \u00a7e" + this.getLanguage());
        player.sendMessage(prefix + "\u00a77Server Version: \u00a7e" + Bukkit.getServer().getBukkitVersion());
        player.sendMessage(prefix + "\u00a77Ist die Version kompatibel: \u00a7e" + this.isVersionCompatible());
        if (this.isResetListEnabled()) {
            player.sendMessage(prefix + "\u00a77Momentaner reset list Countdown: \u00a7e" + this.getCountdownSeconds());
        }
        player.sendMessage(prefix + "\u00a77Vielen Dank f\u00fcr das downloaden!");
    }

    private void showStatistics(Player player) {
        if (!this.isStatisticsEnabled()) {
            this.sendMessage(player, "\u00a7cThe stats are \u00a74disabled \u00a7cin the \u00a7econfig\u00a7c!", "\u00a7cDie Statistiken sind in der \u00a7eConfig \u00a74deaktiviert\u00a7c!");
            return;
        }
        String language = this.getLanguage();
        String prefix = Vars.getVars().pr;
        if (this.isEnglish(language)) {
            this.sendEnglishStatistics(player, prefix);
        } else if (this.isGerman(language)) {
            this.sendGermanStatistics(player, prefix);
        }
    }

    private void sendEnglishStatistics(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77\u00a7lStats:");
        if (this.isShowPercentageEnabled()) {
            this.sendPercentageWarning(player, "\u00a7c\u00a7lAttention:", "\u00a7cAll percentages are rounded and may vary by approximately 1.");
            this.sendEnglishPercentageStats(player, prefix);
        } else {
            this.sendEnglishRawStats(player, prefix);
        }
        this.sendCommonStats(player, prefix);
    }

    private void sendGermanStatistics(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77\u00a7lStats:");
        if (this.isShowPercentageEnabled()) {
            this.sendPercentageWarning(player, "\u00a7c\u00a7lAchtung:", "\u00a7cAlle Prozentangaben sind gerundet und k\u00f6nnen um 1 abweichen.");
            this.sendGermanPercentageStats(player, prefix);
        } else {
            this.sendGermanRawStats(player, prefix);
        }
        this.sendCommonStats(player, prefix);
    }

    private void sendPercentageWarning(Player player, String title, String message) {
        player.sendMessage(title);
        player.sendMessage(message);
    }

    private void sendEnglishPercentageStats(Player player, String prefix) {
        Statistics stats = Statistics.getStats();
        player.sendMessage(prefix + "\u00a77Players in AlreadyDoneList: \u00a7e" + this.getAlreadyDoneListSize());
        player.sendMessage(prefix + "\u00a77Solved captcha percentage: \u00a7e" + stats.getSolvedCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Failed captcha percentage: \u00a7e" + stats.getFailedCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Used chat captcha percentage: \u00a7e" + stats.getDoneChatCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Used inventory captcha percentage: \u00a7e" + stats.getDoneInvCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Tried command percentage: \u00a7e" + stats.getTriedCommandPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Tried to move percentage: \u00a7e" + stats.getTriedMovePercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Closed inventory in captcha percentage: \u00a7e" + stats.getClosedInventoryPercentage() + "% ");
    }

    private void sendGermanPercentageStats(Player player, String prefix) {
        Statistics stats = Statistics.getStats();
        player.sendMessage(prefix + "\u00a77Spieler in AlreadyDoneList: \u00a7e" + this.getAlreadyDoneListSize());
        player.sendMessage(prefix + "\u00a77Spieler, die das Captcha bestanden haben: \u00a7e" + stats.getSolvedCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die das Captcha nicht bestanden haben: \u00a7e" + stats.getFailedCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die das Chat Captcha benutzt haben: \u00a7e" + stats.getDoneChatCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die das Inventory Captcha benutzt haben: \u00a7e" + stats.getDoneInvCaptchaPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die versucht haben einen Command zu nutzen: \u00a7e" + stats.getTriedCommandPercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die versucht haben sich zu bewegen: \u00a7e" + stats.getTriedMovePercentage() + "% ");
        player.sendMessage(prefix + "\u00a77Spieler, die das Inventar im Captcha geschlossen haben: \u00a7e" + stats.getClosedInventoryPercentage() + "% ");
    }

    private void sendEnglishRawStats(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77Players in AlreadyDoneList: \u00a7e" + this.getAlreadyDoneListSize());
        player.sendMessage(prefix + "\u00a77Solved captcha: \u00a7e" + this.statisticsFile.getApprovedPlayer());
        player.sendMessage(prefix + "\u00a77Failed captcha: \u00a7e" + this.statisticsFile.getFailedPlayer());
        player.sendMessage(prefix + "\u00a77Used chat captcha: \u00a7e" + this.statisticsFile.getDoneChatCaptcha());
        player.sendMessage(prefix + "\u00a77Used inventory captcha: \u00a7e" + this.statisticsFile.getDoneInventoryCaptcha());
        player.sendMessage(prefix + "\u00a77Closed inventory in captcha: \u00a7e" + this.statisticsFile.getPlayerClosedInventory());
        player.sendMessage(prefix + "\u00a77Tried command: \u00a7e" + this.statisticsFile.getPlayerTriedCommand());
        player.sendMessage(prefix + "\u00a77Tried to move: \u00a7e" + this.statisticsFile.getPlayerTriedMove());
    }

    private void sendGermanRawStats(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77Spieler in AlreadyDoneList: \u00a7e" + this.getAlreadyDoneListSize());
        player.sendMessage(prefix + "\u00a77Spieler, die das Captcha bestanden haben: \u00a7e" + this.statisticsFile.getApprovedPlayer());
        player.sendMessage(prefix + "\u00a77Spieler, die das Captcha nicht bestanden haben: \u00a7e" + this.statisticsFile.getFailedPlayer());
        player.sendMessage(prefix + "\u00a77Spieler, die das Chat Captcha benutzt haben: \u00a7e" + this.statisticsFile.getDoneChatCaptcha());
        player.sendMessage(prefix + "\u00a77Spieler, die das Inventory Captcha benutzt haben: \u00a7e" + this.statisticsFile.getDoneInventoryCaptcha());
        player.sendMessage(prefix + "\u00a77Spieler, die versucht haben einen Command zu nutzen: \u00a7e" + this.statisticsFile.getPlayerTriedCommand());
        player.sendMessage(prefix + "\u00a77Spieler, die versucht haben sich zu bewegen: \u00a7e" + this.statisticsFile.getPlayerTriedMove());
        player.sendMessage(prefix + "\u00a77Spieler, die das Inventar im Captcha geschlossen haben: \u00a7e" + this.statisticsFile.getPlayerClosedInventory());
    }

    private void sendCommonStats(Player player, String prefix) {
        player.sendMessage(prefix + "\u00a77Log entrys: \u00a7e" + this.statisticsFile.getLogEntrys());
        player.sendMessage(prefix + "\u00a77Times players joined: \u00a7e" + this.statisticsFile.getPlayerJoined());
    }

    private void checkForUpdates(Player player) {
        String prefix = Vars.getVars().pr;
        if (this.isEnglish(this.getLanguage())) {
            player.sendMessage(prefix + "\u00a77Checking for updates...");
            player.sendMessage(prefix + "\u00a7aYour version of \u00a7elogCaptcha \u00a7ais up to date!");
        } else if (this.isGerman(this.getLanguage())) {
            player.sendMessage(prefix + "\u00a77\u00dcberpr\u00fcfe auf Updates...");
            player.sendMessage(prefix + "\u00a7aDeine Version von \u00a7elogCaptcha \u00a7aist auf dem neuesten Stand!");
        }
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private String getLanguage() {
        return this.plugin.getConfig().getString("logCaptcha.Language");
    }

    private boolean isEnglish(String language) {
        return "en-EN".equals(language);
    }

    private boolean isGerman(String language) {
        return "de-DE".equals(language);
    }

    private int getBuildNumber() {
        return this.plugin.getConfig().getInt("logCaptcha.Build");
    }

    private boolean isVersionCompatible() {
        return VersionCheck.getVersionCheck().isVersionCompatible(Bukkit.getServer().getBukkitVersion());
    }

    private boolean isResetListEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.ResetAlreadyDoneList");
    }

    private int getCountdownSeconds() {
        return Countdown.getCountdown().secs;
    }

    private boolean isStatisticsEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseStatistics");
    }

    private boolean isShowPercentageEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.ShowStatisticsInPercent");
    }

    private int getAlreadyDoneListSize() {
        return CaptchaFile.getCaptchaFile().getListSize();
    }

    private void sendMessage(Player player, String englishMessage, String germanMessage) {
        String prefix = Vars.getVars().pr;
        String language = this.getLanguage();
        if (this.isEnglish(language)) {
            player.sendMessage(prefix + englishMessage);
        } else if (this.isGerman(language)) {
            player.sendMessage(prefix + germanMessage);
        }
    }
}

