/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.commands;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.captcha.ChatCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.InventoryCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SquareCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.SteeringCaptcha;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Log;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.Random;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CaptchaCommand
implements CommandExecutor {
    private static final Random RANDOM = new Random();
    private static final String GERMAN_LANGUAGE = "de-DE";
    private static final String ENGLISH_LANGUAGE = "en-EN";

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player target;
        if (!cmd.getName().equalsIgnoreCase("captcha") || !(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!this.hasPermission(player)) {
            return false;
        }
        if (args.length > 1) {
            this.sendUsageMessage(sender);
            return true;
        }
        Player player2 = target = args.length == 1 ? this.getTargetPlayer(sender, args[0]) : player;
        if (target == null) {
            return true;
        }
        this.startCaptcha(target);
        return true;
    }

    private boolean hasPermission(Player player) {
        String permission = LogCaptcha.getInstance().getConfig().getString("logCaptcha.Permissions.CaptchaCMD");
        return player.hasPermission(permission);
    }

    private void sendUsageMessage(CommandSender sender) {
        String language = this.getCurrentLanguage();
        String message = this.getLanguageMessage(language + ".Messages.CaptchaUsage");
        sender.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    private Player getTargetPlayer(CommandSender sender, String playerName) {
        Player target = Bukkit.getPlayer((String)playerName);
        if (target == null) {
            String language = this.getCurrentLanguage();
            String message = this.getLanguageMessage(language + ".Messages.PlayerNotAvailable");
            sender.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
        return target;
    }

    private void startCaptcha(Player target) {
        if (this.isChatCaptchaEnabled()) {
            this.startChatCaptcha(target);
        } else if (this.isInventoryCaptchaEnabled()) {
            this.startInventoryCaptcha(target);
        } else if (this.isRaisingCaptchaEnabled()) {
            this.startRaisingCaptcha(target);
        } else if (this.isSquareCaptchaEnabled()) {
            this.startSquareCaptcha(target);
        }
        this.scheduleTimeoutTask(target);
    }

    private void startChatCaptcha(Player target) {
        Bukkit.getScheduler().runTaskLater((Plugin)LogCaptcha.getInstance(), () -> {
            this.sendCaptchaMessages(target);
            ChatCaptcha.getChatCaptcha().sendCaptcha(target, ChatCaptcha.getChatCaptcha().getCaptchaWord());
            Captcha.getCaptcha().playerInChatCaptcha.add(target);
        }, 20L);
    }

    private void startInventoryCaptcha(Player target) {
        int captchaId = this.generateCaptchaId();
        Bukkit.getScheduler().runTaskLater((Plugin)LogCaptcha.getInstance(), () -> {
            InventoryCaptcha.getInventoryCaptcha().openCaptcha(captchaId, target);
            Captcha.getCaptcha().playerInCaptcha.add(target);
            this.sendCaptchaMessages(target);
        }, 20L);
    }

    private void startRaisingCaptcha(Player target) {
        int randomNumber = this.generateRandomNumber();
        int finishNumber = this.generateFinishNumber();
        TemporaryFile.getTemporaryFile().setNumber(target.getName(), randomNumber);
        TemporaryFile.getTemporaryFile().setFinishNumber(target.getName(), finishNumber);
        Bukkit.getScheduler().runTaskLater((Plugin)LogCaptcha.getInstance(), () -> {
            SteeringCaptcha.getSteeringCaptcha().openCaptcha(target);
            Captcha.getCaptcha().playerInCaptcha.add(target);
            this.sendCaptchaMessages(target);
        }, 20L);
    }

    private void startSquareCaptcha(Player target) {
        SquareCaptcha.getSquareCaptcha().openCaptcha(target);
        Captcha.getCaptcha().playerInCaptcha.add(target);
    }

    private void sendCaptchaMessages(Player target) {
        String language = this.getCurrentLanguage();
        String joinMessage = this.getLanguageMessage(language + ".Messages.JoinMessage");
        int waitingTime = this.getWaitingTime();
        target.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)joinMessage));
        if (ENGLISH_LANGUAGE.equals(language)) {
            target.sendMessage(Vars.getVars().pr + "\u00a7cYou have to do this in \u00a7e" + waitingTime + "\u00a7c seconds!");
        } else if (GERMAN_LANGUAGE.equals(language)) {
            target.sendMessage(Vars.getVars().pr + "\u00a7cDu hast daf\u00fcr \u00a7e" + waitingTime + "\u00a7c Sekunden Zeit!");
        }
    }

    private void scheduleTimeoutTask(Player target) {
        int seconds = this.getWaitingTime() * 20;
        Bukkit.getScheduler().runTaskLater((Plugin)LogCaptcha.getInstance(), () -> {
            if (this.isPlayerInCaptcha(target)) {
                this.handleCaptchaTimeout(target);
            }
        }, (long)seconds);
    }

    private void handleCaptchaTimeout(Player target) {
        Log.getLog().log(target.getName() + " failed to solve the captcha in time!");
        String language = this.getCurrentLanguage();
        String kickMessage = this.getLanguageMessage(language + ".Messages.FailedCaptchaInTime");
        target.kickPlayer(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)kickMessage));
    }

    private boolean isPlayerInCaptcha(Player player) {
        return Captcha.getCaptcha().playerInCaptcha.contains(player) || Captcha.getCaptcha().playerInChatCaptcha.contains(player);
    }

    private boolean isChatCaptchaEnabled() {
        return LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.Options.UseChatCaptcha");
    }

    private boolean isInventoryCaptchaEnabled() {
        return LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.Options.UseInventoryCaptcha");
    }

    private boolean isRaisingCaptchaEnabled() {
        return LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.Options.UseRaisingCaptcha");
    }

    private boolean isSquareCaptchaEnabled() {
        return LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.Options.UseSquareCaptcha");
    }

    private String getCurrentLanguage() {
        return LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language");
    }

    private String getLanguageMessage(String key) {
        return LanguageFile.getLanguageFile().langCfg.getString(key);
    }

    private int getWaitingTime() {
        return LogCaptcha.getInstance().getConfig().getInt("logCaptcha.Options.WaitingTime");
    }

    private int generateCaptchaId() {
        return RANDOM.nextInt(21) + 1;
    }

    private int generateRandomNumber() {
        return RANDOM.nextInt(4) + 1;
    }

    private int generateFinishNumber() {
        return RANDOM.nextInt(28) + 2;
    }
}

