/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.api.captcha;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.ArrayList;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SquareCaptcha {
    private static final SquareCaptcha INSTANCE = new SquareCaptcha();
    private static final int INVENTORY_SIZE = 45;
    private static final int MAX_RED_BLOCKS = 7;
    private static final int GREEN_BLOCK_THRESHOLD = 10;
    private static final int[] CAPTCHA_SLOTS = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32};
    private static final int[] FILLER_SLOTS = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int QUESTION_SLOT = 4;
    private final Random random = new Random();
    private int redBlocks = 0;

    public static SquareCaptcha getSquareCaptcha() {
        return INSTANCE;
    }

    private ItemStack getRandomBlock(Player player) {
        if (this.redBlocks > 7 || this.random.nextInt(19) + 1 > 10) {
            TemporaryFile.getTemporaryFile().addProgressFinish(player.getName());
            return this.createGreenBlock();
        }
        ++this.redBlocks;
        return this.createRedBlock();
    }

    private ItemStack createGreenBlock() {
        return ItemCreator.getItemCreator().createItem("\u00a7a", 1, Material.GREEN_TERRACOTTA);
    }

    private ItemStack createRedBlock() {
        return ItemCreator.getItemCreator().createItem("\u00a7c", 1, Material.RED_TERRACOTTA);
    }

    private ItemStack createFillerBlock() {
        return ItemCreator.getItemCreator().createItem("\u00a70", 1, Material.BLACK_STAINED_GLASS_PANE);
    }

    private ItemStack createQuestionItem(String language) {
        String title;
        ArrayList<String> lore = new ArrayList<String>();
        if ("de-DE".equals(language)) {
            title = "\u00a7eAufgabe";
            lore.add("\u00a77Klicke auf die \u00a7aGr\u00fcnen \u00a7eBl\u00f6cke \u00a77um das \u00a7eCaptcha \u00a77zu bestehen!");
        } else {
            title = "\u00a7eTask";
            lore.add("\u00a77Click on all \u00a7agreen \u00a7eblocks \u00a77to get through the \u00a7ecaptcha\u00a77!");
        }
        return ItemCreator.getItemCreator().createItem(title, 1, Material.NAME_TAG, lore);
    }

    private void setupInventory(Player player, Inventory inventory) {
        ItemStack filler = this.createFillerBlock();
        for (int slot : FILLER_SLOTS) {
            inventory.setItem(slot, filler);
        }
        for (int slot : CAPTCHA_SLOTS) {
            inventory.setItem(slot, this.getRandomBlock(player));
        }
        String language = LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language");
        inventory.setItem(4, this.createQuestionItem(language));
    }

    public void openCaptcha(Player player) {
        Inventory captcha;
        this.redBlocks = 0;
        Vars.getVars().captcha = captcha = player.getServer().createInventory(null, 45, "\u00a7aSquare");
        this.setupInventory(player, captcha);
        player.openInventory(captcha);
    }
}

