/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.api.captcha;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.files.CustomCaptchaFile;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InventoryCaptcha {
    private static final InventoryCaptcha INSTANCE = new InventoryCaptcha();
    private static final int INVENTORY_SIZE = 27;
    private static final int QUESTION_SLOT = 4;
    private static final List<Integer> ANSWER_SLOTS = Arrays.asList(11, 12, 13, 14, 15);
    private final Random random = new Random();
    private final List<String> correctAnswerList = this.getConfigList("CorrectAnswerList");
    private final List<String> customQuestionList = this.getConfigList("CustomQuestionList");
    private final int customCaptchaId = this.customQuestionList.isEmpty() ? 0 : this.random.nextInt(this.customQuestionList.size());

    private InventoryCaptcha() {
    }

    public static InventoryCaptcha getInventoryCaptcha() {
        return INSTANCE;
    }

    public void openCaptcha(int captchaId, Player player) {
        Inventory captcha = this.createCaptchaInventory(captchaId, player);
        if (this.isCustomCaptchaEnabled()) {
            this.setupCustomCaptcha(captcha, captchaId);
        } else {
            String language = this.getConfiguredLanguage();
            this.setupStandardCaptcha(captcha, captchaId, language);
        }
        player.openInventory(captcha);
    }

    private Inventory createCaptchaInventory(int captchaId, Player player) {
        String title = Vars.getVars().pr + "\u00a7aCaptcha " + (this.isCustomCaptchaEnabled() ? this.customCaptchaId : captchaId);
        return player.getServer().createInventory(null, 27, title);
    }

    private void setupCustomCaptcha(Inventory captcha, int captchaId) {
        List<ItemStack> answers = this.createCustomAnswers(captchaId);
        ItemStack question = this.createCustomQuestion();
        this.fillInventoryWithItems(captcha, answers, question);
    }

    private void setupStandardCaptcha(Inventory captcha, int captchaId, String language) {
        List<ItemStack> answers = this.createStandardAnswers(captchaId);
        ItemStack question = this.createStandardQuestion(captchaId, language);
        this.fillInventoryWithItems(captcha, answers, question);
    }

    private List<ItemStack> createCustomAnswers(int captchaId) {
        ArrayList<ItemStack> answers = new ArrayList<ItemStack>();
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordOneList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordTwoList[captchaId]));
        answers.add(this.createCorrectAnswerItem(this.correctAnswerList.get(this.customCaptchaId)));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordFourList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordFiveList[captchaId]));
        return answers;
    }

    private List<ItemStack> createStandardAnswers(int captchaId) {
        ArrayList<ItemStack> answers = new ArrayList<ItemStack>();
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordOneList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordTwoList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaSolutionList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordFourList[captchaId]));
        answers.add(this.createAnswerItem(Captcha.getCaptcha().invCaptchaWordFiveList[captchaId]));
        return answers;
    }

    private ItemStack createCustomQuestion() {
        List<String> lore = Arrays.asList(this.customQuestionList.get(this.customCaptchaId));
        return ItemCreator.getItemCreator().createItem("\u00a7eQuestion", 1, Material.NAME_TAG, lore);
    }

    private ItemStack createStandardQuestion(int captchaId, String language) {
        String questionText = this.getQuestionText(language);
        String questionContent = this.getQuestionContent(captchaId, language);
        List<String> lore = Arrays.asList(questionContent);
        return ItemCreator.getItemCreator().createItem(questionText, 1, Material.NAME_TAG, lore);
    }

    private ItemStack createAnswerItem(String text) {
        return ItemCreator.getItemCreator().createItem(text, 1, Material.GREEN_TERRACOTTA);
    }

    private ItemStack createCorrectAnswerItem(String text) {
        return ItemCreator.getItemCreator().createItem(text, 1, Material.GREEN_TERRACOTTA, (short)5);
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem("\u00a770", 1, Material.BLACK_STAINED_GLASS_PANE, (short)7);
    }

    private void fillInventoryWithItems(Inventory captcha, List<ItemStack> answers, ItemStack question) {
        int i;
        ItemStack filler = this.createFillerItem();
        for (i = 0; i < 27; ++i) {
            captcha.setItem(i, filler);
        }
        captcha.setItem(4, question);
        for (i = 0; i < answers.size() && i < ANSWER_SLOTS.size(); ++i) {
            captcha.setItem(ANSWER_SLOTS.get(i).intValue(), answers.get(i));
        }
        Vars.getVars().captcha = captcha;
    }

    private boolean isCustomCaptchaEnabled() {
        return LogCaptcha.getInstance().getConfig().getBoolean("logCaptcha.UseCustomCaptchas");
    }

    private String getConfiguredLanguage() {
        return LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language", "en-EN");
    }

    private String getQuestionText(String language) {
        return "de-DE".equals(language) ? "\u00a7eFrage" : "\u00a7eQuestion";
    }

    private String getQuestionContent(int captchaId, String language) {
        return "de-DE".equals(language) ? Captcha.getCaptcha().invCaptchaQuestionListDE[captchaId] : Captcha.getCaptcha().invCaptchaQuestionListEN[captchaId];
    }

    private List<String> getConfigList(String key) {
        List list = (List)CustomCaptchaFile.getCustomCaptchaFile().customCaptchaCfg.get(key);
        return list != null ? list : new ArrayList();
    }
}

