/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.events;

import de.tofastforyou.bwaves.files.BanFile;
import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.files.CaptchaFile;
import de.tofastforyou.logcaptcha.files.CustomCaptchaFile;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.files.StatisticsFile;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.ListUser;
import de.tofastforyou.logcaptcha.utils.Log;
import de.tofastforyou.logcaptcha.utils.Vars;
import de.tofastforyou.logcaptcha.utils.inventories.ConfirmationInventory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class InventoryClickEventListener
implements Listener {
    private static final String LANGUAGE_EN = "en-EN";
    private static final String LANGUAGE_DE = "de-DE";
    private static final String TITLE_CAPTCHA = "Captcha";
    private static final String TITLE_RAISE = "Raise";
    private static final String TITLE_SQUARE = "\u00a7aSquare";
    private static final String TITLE_MENU_EN = "\u00a7aMenu";
    private static final String TITLE_MENU_DE = "\u00a7aMen\u00fc";
    private static final String TITLE_CONFIRM_EN = "\u00a7aAre you sure?";
    private static final String TITLE_CONFIRM_DE = "\u00a7aBist du dir sicher?";
    private static final String DISPLAY_PLUS_ONE = "\u00a7a+1";
    private static final String DISPLAY_MINUS_ONE = "\u00a7c-1";
    private static final String DISPLAY_YES_EN = "\u00a7aYes";
    private static final String DISPLAY_YES_DE = "\u00a7aJa";
    private static final String DISPLAY_NO_EN = "\u00a7cNo";
    private static final String DISPLAY_NO_DE = "\u00a7cNein";
    private static final int MAX_FAILS = 5;
    private static final int NUMBER_SLOT = 13;
    private final ArrayList<String> correctAnswerList;
    private final LogCaptcha plugin = LogCaptcha.getInstance();

    public InventoryClickEventListener() {
        this.correctAnswerList = (ArrayList)CustomCaptchaFile.getCustomCaptchaFile().customCaptchaCfg.get("CorrectAnswerList");
    }

    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (title.contains(TITLE_CAPTCHA)) {
            this.handleCaptchaInventory(event, player);
        } else if (title.contains(TITLE_RAISE)) {
            this.handleRaiseInventory(event, player);
        } else if (title.equals(TITLE_SQUARE)) {
            this.handleSquareInventory(event, player);
        } else if (title.equals(TITLE_MENU_EN) || title.equals(TITLE_MENU_DE)) {
            this.handleMenuInventory(event, player);
        } else if (title.equals(TITLE_CONFIRM_EN) || title.equals(TITLE_CONFIRM_DE)) {
            this.handleConfirmationInventory(event, player);
        }
    }

    private void handleCaptchaInventory(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        if (this.isUsingCustomCaptchas()) {
            this.handleCustomCaptcha(event, player);
        } else {
            this.handleStandardCaptcha(event, player);
        }
    }

    private void handleCustomCaptcha(InventoryClickEvent event, Player player) {
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (this.correctAnswerList.contains(displayName)) {
            this.handleCaptchaSuccess(player);
        } else if (!this.isUIElement(event.getCurrentItem(), displayName)) {
            this.handleCaptchaFailure(player);
        }
    }

    private void handleStandardCaptcha(InventoryClickEvent event, Player player) {
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (Arrays.asList(Captcha.getCaptcha().invCaptchaSolutionList).contains(displayName)) {
            this.handleCaptchaSuccess(player);
        } else if (!this.isUIElement(event.getCurrentItem(), displayName)) {
            this.handleCaptchaFailure(player);
        }
    }

    private void handleRaiseInventory(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (displayName.equals(DISPLAY_PLUS_ONE)) {
            this.handleNumberIncrease(event, player);
        } else if (displayName.equals(DISPLAY_MINUS_ONE)) {
            this.handleNumberDecrease(event, player);
        }
    }

    private void handleNumberIncrease(InventoryClickEvent event, Player player) {
        int finishNumber;
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        int currentNumber = tempFile.getNumber(player.getName());
        if (currentNumber >= (finishNumber = tempFile.getFinishNumber(player.getName())) - 1) {
            this.handleRaiseSuccess(player);
        } else {
            tempFile.setNumber(player.getName(), currentNumber + 1);
            this.updateNumberDisplay(event, tempFile.getNumber(player.getName()));
        }
    }

    private void handleNumberDecrease(InventoryClickEvent event, Player player) {
        int finishNumber;
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        int currentNumber = tempFile.getNumber(player.getName());
        if (currentNumber >= (finishNumber = tempFile.getFinishNumber(player.getName())) - 1) {
            this.handleRaiseSuccess(player);
        } else {
            tempFile.setNumber(player.getName(), currentNumber - 1);
            this.updateNumberDisplay(event, tempFile.getNumber(player.getName()));
        }
    }

    private void handleRaiseSuccess(Player player) {
        TemporaryFile.getTemporaryFile().setNumber(player.getName(), 0);
        this.removeCaptchaPlayer(player);
        this.playSuccessSound(player);
        this.updateStatisticsIfEnabled(true, false);
        this.savePlayerIfEnabled(player);
        this.sendSuccessMessage(player);
        player.closeInventory();
    }

    private void handleSquareInventory(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        if (event.getCurrentItem().getItemMeta().getDisplayName().contains("\u00a7a")) {
            this.handleSquareCorrectClick(event, player);
        } else {
            this.handleSquareWrongClick(player);
        }
    }

    private void handleSquareCorrectClick(InventoryClickEvent event, Player player) {
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        if (tempFile.getProgress(player.getName()) == tempFile.getProgressFinish(player.getName()) - 1) {
            this.handleSquareSuccess(player);
        } else {
            tempFile.addProgress(player.getName());
            if (event.getRawSlot() != -999) {
                ItemStack wrongItem = ItemCreator.getItemCreator().createItem("\u00a7c", 1, Material.RED_TERRACOTTA);
                event.getInventory().setItem(event.getRawSlot(), wrongItem);
            }
        }
    }

    private void handleSquareSuccess(Player player) {
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        this.removeCaptchaPlayer(player);
        this.playSuccessSound(player);
        tempFile.setProgressFinish(player.getName(), 0);
        tempFile.setProgress(player.getName(), 0);
        this.updateStatisticsIfEnabled(true, true);
        this.savePlayerIfEnabled(player);
        this.sendSuccessMessage(player);
        player.closeInventory();
    }

    private void handleSquareWrongClick(Player player) {
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        tempFile.setProgress(player.getName(), 0);
        tempFile.setProgressFinish(player.getName(), 0);
        if (this.isStatisticsEnabled()) {
            StatisticsFile.getStatisticsFile().addFailedPlayer();
            Log.getLog().log(player.getName() + " failed the captcha!");
            this.sendFailureMessage(player);
            player.kickPlayer(this.getFormattedMessage("Messages.FailedCaptcha"));
        }
    }

    private void handleMenuInventory(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (displayName.equals("\u00a7cReset AlradyDoneList") || displayName.equals("\u00a7cSetze die AlreadyDoneList zur\u00fcck")) {
            TemporaryFile.getTemporaryFile().setAction(player.getName(), "resetList");
            ConfirmationInventory.getConfirmationInventory().openInventory(player);
        } else if (displayName.equals("\u00a77List all \u00a7euser") || displayName.equals("\u00a77Liste alle \u00a7eSpieler \u00a77auf")) {
            player.closeInventory();
            ListUser.getListUser().listAllUser(player);
        } else if (displayName.equals("\u00a74Reset config file") || displayName.equals("\u00a74Setze die Config Datei zur\u00fcck")) {
            TemporaryFile.getTemporaryFile().setAction(player.getName(), "resetConfig");
            ConfirmationInventory.getConfirmationInventory().openInventory(player);
        } else if (displayName.equals("\u00a77Check for \u00a7eUpdates") || displayName.equals("\u00a77\u00dcberpr\u00fcfe auf \u00a7eUpdates")) {
            player.closeInventory();
            Bukkit.dispatchCommand((CommandSender)player, (String)"logcaptcha update");
        }
    }

    private void handleConfirmationInventory(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (displayName.equals(DISPLAY_YES_EN) || displayName.equals(DISPLAY_YES_DE)) {
            this.handleConfirmationYes(player);
        } else if (displayName.equals(DISPLAY_NO_EN) || displayName.equals(DISPLAY_NO_DE)) {
            player.closeInventory();
        }
    }

    private void handleConfirmationYes(Player player) {
        player.closeInventory();
        String action = TemporaryFile.getTemporaryFile().getAction(player.getName());
        if ("resetList".equals(action)) {
            this.handleResetList(player);
        } else if ("resetConfig".equals(action)) {
            this.handleResetConfig(player);
        }
    }

    private void handleResetList(Player player) {
        this.sendMessage(player, "Messages.ResetList");
        CaptchaFile.getCaptchaFile().captchaCfg.set("TemporaryNoCaptcha", null);
        CaptchaFile.getCaptchaFile().saveFile();
    }

    private void handleResetConfig(Player player) {
        player.closeInventory();
        this.sendMessage(player, "Messages.ResetConfig");
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        configFile.delete();
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        Bukkit.getConsoleSender().sendMessage(Vars.getVars().pr + "\u00a74WARNING: Config resetted!");
    }

    private void handleCaptchaSuccess(Player player) {
        this.removeCaptchaPlayer(player);
        this.playSuccessSound(player);
        this.updateStatisticsIfEnabled(true, true);
        this.savePlayerIfEnabled(player);
        this.sendSuccessMessage(player);
        player.closeInventory();
    }

    private void handleCaptchaFailure(Player player) {
        this.updateStatisticsIfEnabled(false, false);
        if (this.isBWavesEnabled()) {
            this.handleBWavesFailure(player);
        } else {
            this.handleStandardFailure(player);
        }
    }

    private void handleBWavesFailure(Player player) {
        TemporaryFile tempFile = TemporaryFile.getTemporaryFile();
        if (tempFile.getFails(player.getName()) > 5) {
            BanFile.getBanFile().banPlayer(player.getName());
        } else {
            tempFile.addFail(player.getName());
        }
        this.sendFailureMessage(player);
        player.kickPlayer(this.getFormattedMessage("Messages.FailedCaptcha"));
    }

    private void handleStandardFailure(Player player) {
        Log.getLog().log(player.getName() + " failed the captcha!");
        this.sendFailureMessage(player);
        player.kickPlayer(this.getFormattedMessage("Messages.FailedCaptcha"));
    }

    private void removeCaptchaPlayer(Player player) {
        Captcha.getCaptcha().playerInCaptcha.remove(player);
    }

    private void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private void updateStatisticsIfEnabled(boolean success, boolean inventoryCaptcha) {
        if (!this.isStatisticsEnabled()) {
            return;
        }
        StatisticsFile statsFile = StatisticsFile.getStatisticsFile();
        if (success) {
            statsFile.addApprovedPlayer();
            if (inventoryCaptcha) {
                statsFile.doneInventoryCaptcha();
            }
        } else {
            statsFile.addFailedPlayer();
        }
    }

    private void savePlayerIfEnabled(Player player) {
        if (this.isSaveAlreadyDoneEnabled()) {
            CaptchaFile.getCaptchaFile().addNameToList(player.getName());
        }
    }

    private void sendSuccessMessage(Player player) {
        this.sendMessage(player, "Messages.SuccessCaptcha");
    }

    private void sendFailureMessage(Player player) {
        this.sendMessage(player, "Messages.FailedCaptcha");
    }

    private void sendMessage(Player player, String messageKey) {
        player.sendMessage(this.getFormattedMessage(messageKey));
    }

    private String getFormattedMessage(String messageKey) {
        String language = this.getCurrentLanguage();
        String message = LanguageFile.getLanguageFile().langCfg.getString(language + "." + messageKey);
        return Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private void updateNumberDisplay(InventoryClickEvent event, int number) {
        ItemStack numberItem = ItemCreator.getItemCreator().createItem("\u00a7a" + Integer.toString(number), 1, Material.BLACK_WOOL);
        event.getInventory().setItem(13, numberItem);
    }

    private boolean isUIElement(ItemStack item, String displayName) {
        return !(!item.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE) && !item.getType().equals((Object)Material.OAK_SIGN) || !displayName.equals("\u00a70") && !displayName.equals("\u00a7eQuestion") && !displayName.equals("\u00a7eFrage"));
    }

    private boolean isUsingCustomCaptchas() {
        return this.plugin.getConfig().getBoolean("logCaptcha.UseCustomCaptchas");
    }

    private boolean isStatisticsEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseStatistics");
    }

    private boolean isSaveAlreadyDoneEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.SaveAlreadyDone");
    }

    private boolean isBWavesEnabled() {
        return this.plugin.getConfig().getBoolean("logCaptcha.Options.UseBWaves");
    }

    private String getCurrentLanguage() {
        return this.plugin.getConfig().getString("logCaptcha.Language");
    }
}

