/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.commands;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.captcha.Captcha;
import de.tofastforyou.logcaptcha.api.captcha.ClickChatCaptcha;
import de.tofastforyou.logcaptcha.files.LanguageFile;
import de.tofastforyou.logcaptcha.utils.Vars;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ApproveCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("captchaprove")) {
            return false;
        }
        Player player = (Player)sender;
        ClickChatCaptcha clickCaptcha = ClickChatCaptcha.getClickChatCaptcha();
        if (!clickCaptcha.inClickCaptcha.contains(player)) {
            player.sendMessage("\u00a7cYou're not in captcha!");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage("\u00a7cUnknown command syntax!");
            return true;
        }
        if (clickCaptcha.randomWordList.contains(args[0])) {
            this.handleSuccessfulCaptcha(player, clickCaptcha, args[0]);
        } else {
            this.handleFailedCaptcha(player);
        }
        return true;
    }

    private void handleSuccessfulCaptcha(Player player, ClickChatCaptcha clickCaptcha, String word) {
        Captcha.getCaptcha().playerInCaptcha.remove(player);
        clickCaptcha.inClickCaptcha.remove(player);
        clickCaptcha.randomWordList.remove(word);
        String message = this.getSuccessMessage();
        player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private void handleFailedCaptcha(Player player) {
        String language = this.getLanguage();
        String errorMessage = language.equals("en-EN") ? "\u00a7cYour code is incorrect!" : "\u00a7cDein Code ist nicht korrekt!";
        player.sendMessage(Vars.getVars().pr + errorMessage);
    }

    private String getSuccessMessage() {
        String language = this.getLanguage();
        String key = language + ".Messages.SuccessCaptcha";
        return LanguageFile.getLanguageFile().langCfg.getString(key);
    }

    private String getLanguage() {
        return LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language");
    }
}

