/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logcaptcha.api.captcha;

import de.tofastforyou.logcaptcha.LogCaptcha;
import de.tofastforyou.logcaptcha.api.item.ItemCreator;
import de.tofastforyou.logcaptcha.files.TemporaryFile;
import de.tofastforyou.logcaptcha.utils.Vars;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SteeringCaptcha {
    private static final SteeringCaptcha INSTANCE = new SteeringCaptcha();
    private static final int INVENTORY_SIZE = 27;
    private static final int QUESTION_SLOT = 4;
    private static final int NUMBER_SLOT = 13;
    private static final int UP_BUTTON_SLOT = 20;
    private static final int DOWN_BUTTON_SLOT = 24;
    private static final Map<String, CaptchaConfig> LANGUAGE_CONFIGS = new HashMap<String, CaptchaConfig>();

    private SteeringCaptcha() {
    }

    public static SteeringCaptcha getSteeringCaptcha() {
        return INSTANCE;
    }

    public void openCaptcha(Player player) {
        String language = this.getConfiguredLanguage();
        CaptchaConfig config = LANGUAGE_CONFIGS.get(language);
        if (config == null) {
            config = LANGUAGE_CONFIGS.get("en-EN");
        }
        Inventory captchaInventory = this.createCaptchaInventory(player, config);
        player.openInventory(captchaInventory);
        Vars.getVars().captcha = captchaInventory;
    }

    private Inventory createCaptchaInventory(Player player, CaptchaConfig config) {
        Inventory inventory = player.getServer().createInventory(null, 27, config.title);
        ItemStack filler = this.createFillerItem();
        ItemStack question = this.createQuestionItem(player, config);
        ItemStack number = this.createNumberItem(player);
        ItemStack upButton = this.createUpButton();
        ItemStack downButton = this.createDownButton();
        this.fillInventoryWithFiller(inventory, filler);
        inventory.setItem(4, question);
        inventory.setItem(13, number);
        inventory.setItem(20, upButton);
        inventory.setItem(24, downButton);
        return inventory;
    }

    private void fillInventoryWithFiller(Inventory inventory, ItemStack filler) {
        for (int i = 0; i < 27; ++i) {
            inventory.setItem(i, filler);
        }
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem("\u00a770", 1, Material.BLACK_STAINED_GLASS_PANE);
    }

    private ItemStack createQuestionItem(Player player, CaptchaConfig config) {
        int finishNumber = TemporaryFile.getTemporaryFile().getFinishNumber(player.getName());
        List<String> lore = Arrays.asList(String.format(config.questionLore, finishNumber));
        return ItemCreator.getItemCreator().createItem(config.questionTitle, 1, Material.NAME_TAG, lore);
    }

    private ItemStack createNumberItem(Player player) {
        int currentNumber = TemporaryFile.getTemporaryFile().getNumber(player.getName());
        return ItemCreator.getItemCreator().createItem("\u00a7a" + currentNumber, 1, Material.BLACK_WOOL);
    }

    private ItemStack createUpButton() {
        return ItemCreator.getItemCreator().createItem("\u00a7a+1", 1, Material.GREEN_TERRACOTTA);
    }

    private ItemStack createDownButton() {
        return ItemCreator.getItemCreator().createItem("\u00a7c-1", 1, Material.RED_TERRACOTTA);
    }

    private String getConfiguredLanguage() {
        return LogCaptcha.getInstance().getConfig().getString("logCaptcha.Language", "en-EN");
    }

    static {
        LANGUAGE_CONFIGS.put("en-EN", new CaptchaConfig("\u00a7aRaise Number", "\u00a7eTask", "\u00a77Raise the \u00a7enumber \u00a77to \u00a7e%d\u00a77!"));
        LANGUAGE_CONFIGS.put("de-DE", new CaptchaConfig("\u00a7aRaise Number", "\u00a7eAufgabe", "\u00a77Erh\u00f6he die \u00a7eZahl \u00a77auf \u00a7e%d\u00a77!"));
    }

    private static class CaptchaConfig {
        final String title;
        final String questionTitle;
        final String questionLore;

        CaptchaConfig(String title, String questionTitle, String questionLore) {
            this.title = title;
            this.questionTitle = questionTitle;
            this.questionLore = questionLore;
        }
    }
}

