/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.util.inventories;

import de.tofastforyou.logauth.util.ItemCreator;
import de.tofastforyou.logauth.util.Vars;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PINLoginMenuGUI {
    private static final int INVENTORY_SIZE = 45;
    private static final String MENU_TITLE = "\u00a77PIN Login";
    private static final String FILLER_NAME = "\u00a70";
    private static final String INFO_TITLE = "\u00a7eInformation";
    private static final int INFO_SLOT = 4;
    private static final int[] NUMBER_SLOTS = new int[]{12, 13, 14, 21, 22, 23, 30, 31, 32, 40};
    private static final int[] FILLER_SLOTS = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 24, 25, 26, 27, 28, 29, 33, 34, 35, 36, 37, 38, 39, 41, 42, 43, 44};
    private static final PINLoginMenuGUI instance = new PINLoginMenuGUI();

    private PINLoginMenuGUI() {
    }

    public static PINLoginMenuGUI getInstance() {
        return instance;
    }

    public void openGUI(Player player) {
        Inventory menu = this.createInventory(player);
        this.fillInventoryWithItems(menu);
        player.openInventory(menu);
    }

    private Inventory createInventory(Player player) {
        String title = Vars.getVars().pr + MENU_TITLE;
        return player.getServer().createInventory(null, 45, title);
    }

    private void fillInventoryWithItems(Inventory menu) {
        ItemStack filler = this.createFillerItem();
        ItemStack[] numberItems = this.createNumberItems();
        ItemStack infoSign = this.createInfoSign();
        this.fillSlots(menu, FILLER_SLOTS, filler);
        this.fillNumberSlots(menu, numberItems);
        menu.setItem(4, infoSign);
        Vars.getVars().menu = menu;
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem(FILLER_NAME, 1, Material.BLACK_STAINED_GLASS_PANE, (short)7);
    }

    private ItemStack[] createNumberItems() {
        ItemStack[] buttons = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            ItemStack button = new ItemStack(Material.STONE_BUTTON);
            ItemMeta meta = button.getItemMeta();
            if (meta != null) {
                meta.setDisplayName("\u00a7e" + i);
                meta.setLore(Arrays.asList("\u00a77Klicke um " + i + " einzugeben"));
                button.setItemMeta(meta);
            }
            buttons[i] = button;
        }
        return buttons;
    }

    private ItemStack createInfoSign() {
        List<String> lore = Arrays.asList("\u00a77Please enter your \u00a7ePIN\u00a77!", "\u00a77You have \u00a7e30 seconds \u00a77to do so.", "\u00a77(If you don't have one, \u00a7ecreate \u00a77one\u00a77!)");
        return ItemCreator.getItemCreator().createItem(INFO_TITLE, 1, Material.OAK_SIGN, lore);
    }

    private void fillSlots(Inventory menu, int[] slots, ItemStack item) {
        for (int slot : slots) {
            menu.setItem(slot, item);
        }
    }

    private void fillNumberSlots(Inventory menu, ItemStack[] numberItems) {
        for (int i = 0; i < NUMBER_SLOTS.length - 1 && i < numberItems.length - 1; ++i) {
            menu.setItem(NUMBER_SLOTS[i], numberItems[i + 1]);
        }
        menu.setItem(NUMBER_SLOTS[9], numberItems[0]);
    }
}

