/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.security;

import org.mindrot.jbcrypt.BCrypt;

public class PasswordUtils {
    public static String hashPasword(String password) {
        return BCrypt.hashpw(password, BCrypt.gensalt(12));
    }

    public static boolean checkPasword(String password, String stored) {
        if (stored == null || !stored.startsWith("$2a$")) {
            throw new IllegalArgumentException("Illegal hash format");
        }
        return BCrypt.checkpw(password, stored);
    }
}

