/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.listener;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.util.LogAuthLogger;
import de.tofastforyou.logauth.util.Vars;
import de.tofastforyou.logauth.util.inventories.PINLoginMenuGUI;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class InventoryClickListener
implements Listener {
    private static final String GUI_TITLE = Vars.getVars().pr + "\u00a77Mangement-GUI";
    private static final String PIN_GUI_TITLE = Vars.getVars().pr + "\u00a77PIN Login";
    private static final String LIST_USERS_DISPLAY_NAME = "\u00a7eList all registered user";
    private static final String RESET_PASSWORDS_DISPLAY_NAME = "\u00a7cReset all \u00a7epasswords";
    private static final String SET_SPAWN_DISPLAY_NAME = "\u00a7eSet the NotLoggedIn spawn";
    private static final int PIN_LENGTH = LogAuth.getLogAuth().getConfig().getInt("logAuth.PINLength");
    private static final Map<Player, StringBuilder> playerPinInput = new HashMap<Player, StringBuilder>();

    @EventHandler
    public void onInvClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (this.isManagementGUI(event)) {
            this.handleManagementGUI(event, player);
        } else if (this.isPinGUI(event)) {
            this.handlePinGUI(event, player);
        }
    }

    private void handleManagementGUI(InventoryClickEvent event, Player player) {
        String displayName;
        event.setCancelled(true);
        switch (displayName = event.getCurrentItem().getItemMeta().getDisplayName()) {
            case "\u00a7eList all registered user": {
                this.handleListUsers(player);
                break;
            }
            case "\u00a7cReset all \u00a7epasswords": {
                this.handleResetPasswords(player);
                break;
            }
            case "\u00a7eSet the NotLoggedIn spawn": {
                this.handleSetSpawn(player);
            }
        }
    }

    private void handlePinGUI(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        String displayName = event.getCurrentItem().getItemMeta().getDisplayName();
        if (displayName.length() == 3 && displayName.startsWith("\u00a7e") && Character.isDigit(displayName.charAt(2))) {
            char digit = displayName.charAt(2);
            this.addDigitToPIN(player, digit);
        }
    }

    private boolean isManagementGUI(InventoryClickEvent event) {
        return GUI_TITLE.equals(event.getView().getTitle());
    }

    private boolean isPinGUI(InventoryClickEvent event) {
        return PIN_GUI_TITLE.equals(event.getView().getTitle());
    }

    private void handleListUsers(Player player) {
        player.closeInventory();
        player.sendMessage(Vars.getVars().pr + "\u00a77Registered players:");
        UserManagementAPI.getUserManagementAPI().getPlayerList().forEach(playerName -> this.sendPlayerListEntry(player, (String)playerName));
    }

    private void addDigitToPIN(Player player, char digit) {
        StringBuilder currentPin = playerPinInput.get(player);
        if (currentPin == null) {
            currentPin = new StringBuilder();
            playerPinInput.put(player, currentPin);
        }
        if (currentPin.length() < PIN_LENGTH) {
            currentPin.append(digit);
            if (currentPin.length() == PIN_LENGTH) {
                String enteredPin = currentPin.toString();
                player.closeInventory();
                this.validatePIN(player, enteredPin);
                playerPinInput.remove(player);
            }
        }
    }

    private void validatePIN(Player player, String pin) {
        if (UserManagementAPI.getUserManagementAPI().isPINCreated(player.getName())) {
            if (UserManagementAPI.getUserManagementAPI().checkPIN(pin, player.getName())) {
                Vars.getVars().logOut.remove(player);
                player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageFile.getInstance().getMessage(Vars.getVars().currentLanguage + ".Messages.PINIsCorrect")));
                LogAuthLogger.getLogAuthLogger().log(player.getName() + " logged in successfully!");
                this.teleportOnLogin(player);
                this.track(player);
            } else {
                player.closeInventory();
                player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageFile.getInstance().getMessage(Vars.getVars().currentLanguage + ".Messages.PINIsIncorrect")));
                PINLoginMenuGUI.getInstance().openGUI(player);
            }
        } else {
            UserManagementAPI.getUserManagementAPI().setPINNumber(pin, player.getName());
            Vars.getVars().logOut.remove(player);
            player.sendMessage(Vars.getVars().pr + ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageFile.getInstance().getMessage(Vars.getVars().currentLanguage + ".Messages.PINCreated")));
            LogAuthLogger.getLogAuthLogger().log(player.getName() + " logged in successfully!");
            this.teleportOnLogin(player);
            this.track(player);
        }
    }

    private void track(Player player) {
        boolean hasNotLoggedInBefore;
        boolean shouldSaveLogins = LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.SavePlayersWhoLoggedIn");
        boolean bl = hasNotLoggedInBefore = !UserManagementAPI.getUserManagementAPI().hasPlayerLoggedIn(player.getName());
        if (shouldSaveLogins && hasNotLoggedInBefore) {
            UserManagementAPI.getUserManagementAPI().addPlayerToLoggedInList(player.getName());
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageFile.getInstance().getMessage(Vars.getVars().currentLanguage + ".Messages.AddedToLoggedInList")));
        }
    }

    private void teleportOnLogin(Player player) {
        boolean shouldTeleport = LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.TeleportNotLoggedInPlayers");
        boolean hasSpawnLocation = UserManagementAPI.getUserManagementAPI().isNotLoggedInSpawnLocationSet();
        if (shouldTeleport && hasSpawnLocation) {
            player.teleport(UserManagementAPI.getUserManagementAPI().getTemporaryLocation(player.getName()));
            UserManagementAPI.getUserManagementAPI().deleteTemporaryLocationSection(player.getName());
        }
    }

    private void sendPlayerListEntry(Player player, String playerName) {
        TextComponent component = new TextComponent("\u00a77- \u00a7e" + playerName);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/adminreset " + playerName));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click here to reset the \u00a7epassword \u00a77of \u00a7e" + playerName + "\u00a77!").create()));
        player.spigot().sendMessage((BaseComponent)component);
    }

    private void handleResetPasswords(Player player) {
        player.closeInventory();
        player.sendMessage(Vars.getVars().pr + "\u00a77Are you sure?");
        TextComponent[] confirmationMessage = this.createConfirmationMessage("/adminreset all", "\u00a77Click here to \u00a7creset\u00a77 all \u00a7epasswords\u00a77!");
        player.spigot().sendMessage((BaseComponent[])confirmationMessage);
    }

    private void handleSetSpawn(Player player) {
        player.closeInventory();
        if (UserManagementAPI.getUserManagementAPI().isNotLoggedInSpawnLocationSet()) {
            this.showSetSpawnConfirmation(player);
        } else {
            this.setNotLoggedInSpawn(player);
        }
    }

    private void showSetSpawnConfirmation(Player player) {
        player.sendMessage(Vars.getVars().pr + "\u00a77Are you sure?");
        TextComponent[] confirmationMessage = this.createConfirmationMessage("/setnotloggedinspawn", "\u00a77Click \u00a7ehere \u00a77to set the new \u00a7eNotLoggedInSpawn \u00a77location!");
        player.spigot().sendMessage((BaseComponent[])confirmationMessage);
    }

    private void setNotLoggedInSpawn(Player player) {
        UserManagementAPI.getUserManagementAPI().createNotLoggedInSpawn(player.getLocation());
        player.sendMessage(Vars.getVars().pr + "\u00a77You \u00a7asuccessfully \u00a77saved the \u00a7eNotLoggedInSpawn \u00a77location!");
    }

    private TextComponent[] createConfirmationMessage(String yesCommand, String yesHoverText) {
        TextComponent prefix = new TextComponent(Vars.getVars().pr);
        TextComponent yes = new TextComponent("\u00a7a\u00a7l[YES] ");
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, yesCommand));
        yes.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(yesHoverText).create()));
        TextComponent no = new TextComponent("\u00a7c\u00a7l[NO]");
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/logadmin"));
        no.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a77Click here to get back to the \u00a7emenu\u00a77!").create()));
        return new TextComponent[]{prefix, yes, no};
    }
}

