/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth;

import de.tofastforyou.logauth.api.UserManagementAPI;
import de.tofastforyou.logauth.commands.BackupCodeCommand;
import de.tofastforyou.logauth.commands.LogAdminCommand;
import de.tofastforyou.logauth.commands.LoginCommand;
import de.tofastforyou.logauth.commands.RegisterCommand;
import de.tofastforyou.logauth.commands.ResetCommand;
import de.tofastforyou.logauth.commands.ResetUserCommand;
import de.tofastforyou.logauth.commands.SetNotLoggedInSpawnCommand;
import de.tofastforyou.logauth.files.LanguageFile;
import de.tofastforyou.logauth.files.LogFile;
import de.tofastforyou.logauth.listener.ChatListener;
import de.tofastforyou.logauth.listener.CommandListener;
import de.tofastforyou.logauth.listener.DamageListener;
import de.tofastforyou.logauth.listener.FoodLevelChangeListener;
import de.tofastforyou.logauth.listener.InventoryClickListener;
import de.tofastforyou.logauth.listener.JoinListener;
import de.tofastforyou.logauth.listener.MoveListener;
import de.tofastforyou.logauth.util.CommandLogFilter;
import de.tofastforyou.logauth.util.ErrorSaver;
import de.tofastforyou.logauth.util.ErrorTypes;
import de.tofastforyou.logauth.util.Vars;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Filter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LogAuth
extends JavaPlugin {
    private static LogAuth logAuth;
    private String configVersion = "1.2.4";

    public void onEnable() {
        logAuth = this;
        this.sendConsoleMessages(Bukkit.getConsoleSender());
    }

    public void onDisable() {
        UserManagementAPI.getUserManagementAPI().closeConnection();
    }

    private void initialize() {
        LanguageFile.getInstance().initializeDefaultMessages();
        this.saveDefaultConfig();
        this.registerListener();
        this.registerCommands();
        this.createFiles();
        this.checkConfigVersion();
        UserManagementAPI.getUserManagementAPI();
        this.registerLoggerFilters(new Filter[]{new CommandLogFilter()});
    }

    private void registerListener() {
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new ChatListener(), (Plugin)this);
        pm.registerEvents((Listener)new CommandListener(), (Plugin)this);
        pm.registerEvents((Listener)new DamageListener(), (Plugin)this);
        pm.registerEvents((Listener)new FoodLevelChangeListener(), (Plugin)this);
        pm.registerEvents((Listener)new JoinListener(), (Plugin)this);
        pm.registerEvents((Listener)new MoveListener(), (Plugin)this);
        pm.registerEvents((Listener)new InventoryClickListener(), (Plugin)this);
        pm.registerEvents((Listener)new CommandListener(), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("reset").setExecutor((CommandExecutor)new ResetCommand());
        this.getCommand("register").setExecutor((CommandExecutor)new RegisterCommand());
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCommand());
        this.getCommand("backupcode").setExecutor((CommandExecutor)new BackupCodeCommand());
        this.getCommand("adminreset").setExecutor((CommandExecutor)new ResetUserCommand());
        this.getCommand("logadmin").setExecutor((CommandExecutor)new LogAdminCommand());
        this.getCommand("setnotloggedinspawn").setExecutor((CommandExecutor)new SetNotLoggedInSpawnCommand());
    }

    private void createFiles() {
        LanguageFile.getInstance().saveConfiguration();
        if (!LogFile.getLogFile().logFile.exists()) {
            try {
                LogFile.getLogFile().logFile.createNewFile();
            }
            catch (Exception e) {
                ErrorSaver.getErrorSaver().saveError(ErrorTypes.FILE_CREATION_FAIL, this.toString(), "Failed to create logFile!");
            }
        }
    }

    private void checkConfigVersion() {
        if (!this.getConfig().getString("Version").equals(this.configVersion)) {
            File cfg = new File(this.getDataFolder(), "config.yml");
            cfg.delete();
            this.saveDefaultConfig();
            this.reloadConfig();
            Bukkit.getConsoleSender().sendMessage(Vars.getVars().pr + "\u00a74WARNING: Config file has been set to default settings!");
        }
    }

    private void sendConsoleMessages(ConsoleCommandSender cs) {
        String[] messages = new String[]{"                            #                           ", " #        ####    ####     # #    #    #  #####  #    # ", " #       #    #  #    #   #   #   #    #    #    #    # ", " #       #    #  #       #     #  #    #    #    ###### ", " #       #    #  #  ###  #######  #    #    #    #    # ", " #       #    #  #    #  #     #  #    #    #    #    # ", " ######   ####    ####   #     #   ####     #    #    # ", "Thanks for using \u00a7clogAuth", "Now loading \u00a7clogAuth\u00a77..."};
        cs.sendMessage(messages);
        this.initialize();
        cs.sendMessage("Loaded! You can now use \u00a7clogAuth\u00a77!");
    }

    private void registerLoggerFilters(Filter ... filters) {
        Logger rootLogger = LogManager.getRootLogger();
        if (!(rootLogger instanceof org.apache.logging.log4j.core.Logger)) {
            return;
        }
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)rootLogger;
        for (Filter filter : filters) {
            logger.addFilter(filter);
        }
    }

    public static LogAuth getLogAuth() {
        return logAuth;
    }
}

