/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.util.inventories;

import de.tofastforyou.logauth.LogAuth;
import de.tofastforyou.logauth.util.ItemCreator;
import de.tofastforyou.logauth.util.Vars;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ManagementMenuGUI {
    private static final ManagementMenuGUI INSTANCE = new ManagementMenuGUI();
    private static final int INVENTORY_SIZE = 27;
    private static final String INVENTORY_TITLE = "\u00a77Mangement-GUI";

    public static ManagementMenuGUI getManagementMenuGUI() {
        return INSTANCE;
    }

    public void openGUI(Player p) {
        Inventory menu = this.createInventory(p);
        if (this.shouldShowTeleportOption()) {
            this.setupMenuWithTeleportOption(menu);
        } else {
            this.setupBasicMenu(menu);
        }
        p.openInventory(menu);
    }

    private Inventory createInventory(Player p) {
        return p.getServer().createInventory(null, 27, String.valueOf(Vars.getVars().pr) + INVENTORY_TITLE);
    }

    private boolean shouldShowTeleportOption() {
        return LogAuth.getLogAuth().getConfig().getBoolean("logAuth.Options.TeleportNotLoggedInPlayers");
    }

    private void setupBasicMenu(Inventory menu) {
        ItemStack filler = this.createFillerItem();
        ItemStack listUser = this.createListUserItem();
        ItemStack reset = this.createResetItem();
        this.fillInventoryBorders(menu, filler);
        menu.setItem(12, listUser);
        menu.setItem(14, reset);
        Vars.getVars().menu = menu;
    }

    private void setupMenuWithTeleportOption(Inventory menu) {
        ItemStack filler = this.createFillerItem();
        ItemStack listUser = this.createListUserItem();
        ItemStack reset = this.createResetItem();
        ItemStack setNotLoggedInSpawn = this.createSetSpawnItem();
        this.fillInventoryBorders(menu, filler);
        menu.setItem(11, listUser);
        menu.setItem(13, setNotLoggedInSpawn);
        menu.setItem(15, reset);
        Vars.getVars().menu = menu;
    }

    private ItemStack createFillerItem() {
        return ItemCreator.getItemCreator().createItem("\u00a70", 1, Material.BLACK_STAINED_GLASS_PANE, (short)7);
    }

    private ItemStack createListUserItem() {
        return ItemCreator.getItemCreator().createItem("\u00a7eList all registered user", 1, Material.PAPER);
    }

    private ItemStack createResetItem() {
        return ItemCreator.getItemCreator().createItem("\u00a7cReset all \u00a7epasswords", 1, Material.BARRIER);
    }

    private ItemStack createSetSpawnItem() {
        ArrayList<String> itemLore = new ArrayList<String>();
        itemLore.add("\u00a77Here you can set the \u00a7espawn");
        itemLore.add("\u00a77for those \u00a7eplayers \u00a77who are \u00a7cnot \u00a77logged in.");
        return ItemCreator.getItemCreator().createItem("\u00a7eSet the NotLoggedIn spawn", 1, Material.NAME_TAG);
    }

    private void fillInventoryBorders(Inventory menu, ItemStack filler) {
        for (int i = 0; i < 27; ++i) {
            menu.setItem(i, filler);
        }
    }
}

