/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.util;

import de.tofastforyou.logauth.files.LogFile;
import de.tofastforyou.logauth.util.ErrorSaver;
import de.tofastforyou.logauth.util.ErrorTypes;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogAuthLogger {
    private static LogAuthLogger logAuthLogger = new LogAuthLogger();

    public static LogAuthLogger getLogAuthLogger() {
        return logAuthLogger;
    }

    public void log(String logEntry) {
        if (!LogFile.getLogFile().logFile.exists()) {
            try {
                LogFile.getLogFile().logFile.createNewFile();
            }
            catch (IOException e) {
                ErrorSaver.getErrorSaver().saveError(ErrorTypes.FILE_CREATION_FAIL, this.getClass().getName(), "Could not create the log.txt file.");
            }
        }
        try {
            FileWriter fw = new FileWriter(LogFile.getLogFile().logFile, true);
            PrintWriter pw = new PrintWriter(fw);
            if (!logEntry.startsWith("\n")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd | HH:mm:ss");
                Date date = new Date();
                pw.write("[" + dateFormat.format(date) + "] ");
            }
            pw.write(String.valueOf(logEntry) + "\n");
            pw.close();
        }
        catch (IOException e) {
            ErrorSaver.getErrorSaver().saveError(ErrorTypes.FILE_WRITE_FAIL, this.getClass().getName(), "Could not write in the log.txt file.");
        }
    }
}

