/*
 * Decompiled with CFR 0.152.
 */
package de.tofastforyou.logauth.security;

import java.io.File;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bukkit.configuration.file.YamlConfiguration;

public class AESCryptoUtil {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/GCM/NoPadding";
    private static final int GCM_IV_LENGTH = 12;
    private static final int GCM_TAG_LENGTH = 16;
    private final SecretKey secretKey;

    public AESCryptoUtil() {
        try {
            this.secretKey = this.loadOrCreateKey();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private SecretKey loadOrCreateKey() throws Exception {
        File configFile = new File("Data", "Userdata.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String keyFromConfig = config.getString("SecretKey");
        if (keyFromConfig != null && !keyFromConfig.isEmpty()) {
            byte[] keyBytes = Base64.getDecoder().decode(keyFromConfig);
            return new SecretKeySpec(keyBytes, ALGORITHM);
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        keyGenerator.init(256);
        SecretKey newKey = keyGenerator.generateKey();
        String base64Key = Base64.getEncoder().encodeToString(newKey.getEncoded());
        config.set("SecretKey", (Object)base64Key);
        configFile.getParentFile().mkdirs();
        config.save(configFile);
        return newKey;
    }

    public String encrypt(String plaintext) throws Exception {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        byte[] iv = new byte[12];
        new SecureRandom().nextBytes(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.secretKey, parameterSpec);
        byte[] encryptedData = cipher.doFinal(plaintext.getBytes("UTF-8"));
        byte[] encryptedWithIv = new byte[12 + encryptedData.length];
        System.arraycopy(iv, 0, encryptedWithIv, 0, 12);
        System.arraycopy(encryptedData, 0, encryptedWithIv, 12, encryptedData.length);
        return Base64.getEncoder().encodeToString(encryptedWithIv);
    }

    public String decrypt(String encryptedText) throws Exception {
        byte[] encryptedData = Base64.getDecoder().decode(encryptedText);
        byte[] iv = new byte[12];
        System.arraycopy(encryptedData, 0, iv, 0, 12);
        byte[] encrypted = new byte[encryptedData.length - 12];
        System.arraycopy(encryptedData, 12, encrypted, 0, encrypted.length);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(2, (Key)this.secretKey, parameterSpec);
        byte[] decryptedData = cipher.doFinal(encrypted);
        return new String(decryptedData, "UTF-8");
    }
}

